/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.IncomingPhoneNumber;
import com.twilio.type.PhoneNumber;

public class IncomingPhoneNumberReader
extends Reader<IncomingPhoneNumber> {
    private String pathAccountSid;
    private Boolean beta;
    private String friendlyName;
    private PhoneNumber phoneNumber;
    private String origin;

    public IncomingPhoneNumberReader() {
    }

    public IncomingPhoneNumberReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public IncomingPhoneNumberReader setBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public IncomingPhoneNumberReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public IncomingPhoneNumberReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public IncomingPhoneNumberReader setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    @Override
    public ResourceSet<IncomingPhoneNumber> read(TwilioRestClient client) {
        return new ResourceSet<IncomingPhoneNumber>(this, client, this.firstPage(client));
    }

    @Override
    public Page<IncomingPhoneNumber> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/IncomingPhoneNumbers.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IncomingPhoneNumber> getPage(String targetUrl, TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IncomingPhoneNumber> nextPage(Page<IncomingPhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IncomingPhoneNumber> previousPage(Page<IncomingPhoneNumber> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<IncomingPhoneNumber> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IncomingPhoneNumber read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("incoming_phone_numbers", response.getContent(), IncomingPhoneNumber.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.origin != null) {
            request.addQueryParam("Origin", this.origin);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

