/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.Account;

public class AccountReader
extends Reader<Account> {
    private String friendlyName;
    private Account.Status status;

    public AccountReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AccountReader setStatus(Account.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public ResourceSet<Account> read(TwilioRestClient client) {
        return new ResourceSet<Account>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Account> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Account> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Account> nextPage(Page<Account> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Account> previousPage(Page<Account> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Account> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Account read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("accounts", response.getContent(), Account.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

