/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.validation;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.twilio.exception.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

class RequestCanonicalizer {
    private static final String NEW_LINE = "\n";
    private static final Pattern TOKEN_REPLACE_PATTERN = Pattern.compile(String.format("%s|\\%s|\\%s|%s", "%7E", "+", "*", "%2F"));
    private final String method;
    private final String uri;
    private final String queryString;
    private final String requestBody;
    private final Header[] headers;
    private static Function<Header[], Map<String, List<String>>> COMBINE_HEADERS = new Function<Header[], Map<String, List<String>>>(){

        public Map<String, List<String>> apply(Header[] headers) {
            HashMap<String, List<String>> combinedHeaders = new HashMap<String, List<String>>();
            for (Header header : headers) {
                if (combinedHeaders.containsKey(header.getName())) {
                    ((List)combinedHeaders.get(header.getName())).add(header.getValue());
                    continue;
                }
                combinedHeaders.put(header.getName(), Lists.newArrayList((Object[])new String[]{header.getValue()}));
            }
            return combinedHeaders;
        }
    };
    private static Function<String, String> CANONICALIZE_PATH = new Function<String, String>(){

        public String apply(String string) {
            if (Strings.isNullOrEmpty((String)string)) {
                return "/";
            }
            try {
                URI normalizedUri = new URI(string).normalize();
                String encoded = URLEncoder.encode(normalizedUri.getPath(), "UTF-8");
                return RequestCanonicalizer.replace(encoded, true);
            }
            catch (URISyntaxException e) {
                throw new InvalidRequestException("Bad URI path: '" + string + "'", string, e);
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("It must be possible to encode request path as ascii", string, e);
            }
        }
    };
    private static Function<String, String> CANONICALIZE_QUERY = new Function<String, String>(){

        public String apply(String string) {
            String replacedQueryString = RequestCanonicalizer.replace(string, false);
            Object[] queryArgs = replacedQueryString.split("&");
            Arrays.sort(queryArgs);
            return Joiner.on((String)"&").join(queryArgs);
        }
    };
    private static Function<Header[], Header[]> LOWERCASE_KEYS = new Function<Header[], Header[]>(){

        public Header[] apply(Header[] headers) {
            Header[] lowercaseHeaders = new Header[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                lowercaseHeaders[i] = new BasicHeader(headers[i].getName().toLowerCase(), headers[i].getValue());
            }
            return lowercaseHeaders;
        }
    };

    public RequestCanonicalizer(String method, String uri, String queryString, String requestBody, Header[] headers) {
        this.method = method;
        this.uri = uri;
        this.queryString = queryString;
        this.requestBody = requestBody;
        this.headers = headers;
    }

    public String create(List<String> sortedIncludedHeaders, HashFunction hashFunction) {
        StringBuilder canonicalRequest = new StringBuilder();
        canonicalRequest.append(this.method).append(NEW_LINE);
        String canonicalUri = (String)CANONICALIZE_PATH.apply((Object)this.uri);
        canonicalRequest.append(canonicalUri).append(NEW_LINE);
        String canonicalQuery = (String)CANONICALIZE_QUERY.apply((Object)this.queryString);
        canonicalRequest.append(canonicalQuery).append(NEW_LINE);
        Header[] lowercaseHeaders = (Header[])LOWERCASE_KEYS.apply((Object)this.headers);
        Map combinedHeaders = (Map)COMBINE_HEADERS.apply((Object)lowercaseHeaders);
        for (String header : sortedIncludedHeaders) {
            String lowercase = header.toLowerCase().trim();
            if (!combinedHeaders.containsKey(lowercase)) continue;
            List values = (List)combinedHeaders.get(lowercase);
            Collections.sort(values);
            canonicalRequest.append(lowercase).append(":").append(Joiner.on((char)',').join((Iterable)values)).append(NEW_LINE);
        }
        canonicalRequest.append(NEW_LINE);
        canonicalRequest.append(Joiner.on((String)";").join(sortedIncludedHeaders)).append(NEW_LINE);
        if (!Strings.isNullOrEmpty((String)this.requestBody)) {
            String hashedPayload = hashFunction.hashString((CharSequence)this.requestBody, Charsets.UTF_8).toString();
            canonicalRequest.append(hashedPayload);
        }
        return canonicalRequest.toString();
    }

    private static String replace(String string, boolean replaceSlash) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string.length());
        Matcher matcher = TOKEN_REPLACE_PATTERN.matcher(string);
        while (matcher.find()) {
            String replacement = matcher.group(0);
            if ("+".equals(replacement)) {
                replacement = "%20";
            } else if ("*".equals(replacement)) {
                replacement = "%2A";
            } else if ("%7E".equals(replacement)) {
                replacement = "~";
            } else if (replaceSlash && "%2F".equals(replacement)) {
                replacement = "/";
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

