/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.taskrouter;

import com.google.common.base.Joiner;

public class UrlUtils {
    private static final String TASKROUTER_BASE_URL = "https://taskrouter.twilio.com";
    private static final String TASKROUTER_VERSION = "v1";

    private UrlUtils() {
    }

    public static String workspaces() {
        return Joiner.on((char)'/').join((Object)TASKROUTER_BASE_URL, (Object)TASKROUTER_VERSION, new Object[]{"Workspaces"});
    }

    public static String allWorkspaces() {
        return Joiner.on((char)'/').join((Object)TASKROUTER_BASE_URL, (Object)TASKROUTER_VERSION, new Object[]{"Workspaces", "**"});
    }

    public static String workspace(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)TASKROUTER_BASE_URL, (Object)TASKROUTER_VERSION, new Object[]{"Workspaces", workspaceSid});
    }

    public static String taskQueues(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"TaskQueues", new Object[0]);
    }

    public static String allTaskQueues(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"TaskQueues", new Object[]{"**"});
    }

    public static String taskQueue(String workspaceSid, String taskQueueSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"TaskQueues", new Object[]{taskQueueSid});
    }

    public static String tasks(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Tasks", new Object[0]);
    }

    public static String allTasks(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Tasks", new Object[]{"**"});
    }

    public static String task(String workspaceSid, String taskSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Tasks", new Object[]{taskSid});
    }

    public static String activities(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Activities", new Object[0]);
    }

    public static String allActivities(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Activities", new Object[]{"**"});
    }

    public static String activity(String workspaceSid, String activitySid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Activities", new Object[]{activitySid});
    }

    public static String workers(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Workers", new Object[0]);
    }

    public static String allWorkers(String workspaceSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Workers", new Object[]{"**"});
    }

    public static String worker(String workspaceSid, String workerSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.workspace(workspaceSid), (Object)"Workers", new Object[]{workerSid});
    }

    public static String reservations(String workspaceSid, String workerSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.worker(workspaceSid, workerSid), (Object)"Reservations", new Object[0]);
    }

    public static String allReservations(String workspaceSid, String workerSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.worker(workspaceSid, workerSid), (Object)"Reservations", new Object[]{"**"});
    }

    public static String reservation(String workspaceSid, String workerSid, String reservationSid) {
        return Joiner.on((char)'/').join((Object)UrlUtils.worker(workspaceSid, workerSid), (Object)"Reservations", new Object[]{reservationSid});
    }
}

