/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.google.common.collect.Lists;
import com.twilio.jwt.validation.ValidationToken;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class ValidationInterceptor
implements HttpRequestInterceptor {
    private static final List<String> HEADERS = Lists.newArrayList((Object[])new String[]{"authorization", "host"});
    private final String accountSid;
    private final String credentialSid;
    private final String signingKeySid;
    private final PrivateKey privateKey;

    public ValidationInterceptor(String accountSid, String credentialSid, String signingKeySid, PrivateKey privateKey) {
        this.accountSid = accountSid;
        this.credentialSid = credentialSid;
        this.signingKeySid = signingKeySid;
        this.privateKey = privateKey;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        ValidationToken jwt = ValidationToken.fromHttpRequest(this.accountSid, this.credentialSid, this.signingKeySid, this.privateKey, request, HEADERS);
        request.addHeader("Twilio-Client-Validation", jwt.toJwt());
    }
}

