/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.upgrade;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Generated;

@Schema(name="upgradeableDevices")
public class UpgradeableDevicesOpenApiVO {
    @Schema(name="name", description="Device name")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String name;
    @Schema(name="mac", description="Device MAC")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="type", description="Device type")
    private String type;
    @Schema(name="model", description="Device model name with version")
    private String model;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="status", description="Status of device,status should be a value as follows: 0:Disconnected;1:Disconnected(Migrating);10:Provisioning;11:Configuring;12:Upgrading;13:Rebooting;14:Connected;15:Connected(Wireless);16:Connected(Migrating);17:Connected(Wireless,Migrating);20:Pending;21:Pending(Wireless);22:Adopting;23:Adopting(Wireless);24:Adopt Failed;25:Adopt Failed(Wireless);26:Managed By Others;27:Managed By Others(Wireless);30:Heartbeat Missed;31:Heartbeat Missed(Wireless);32:Heartbeat Missed(Migrating);33:Heartbeat Missed(Wireless,Migrating);40:Isolated;41:Isolated(Migrating);50:Slice Configuring")
    private Integer status;
    @Schema(name="latestVersion", description="Latest version")
    private String latestVersion;
    @Schema(name="omadacId", description="ID of current Controller.")
    private String omadacId;
    @Schema(name="siteId", description="ID of current Site.")
    private String siteId;
    @Schema(name="licenseStatus", description="Device license status (Only for cloud base) should be a value as follows: 0: unActive; 1: Unbind; 2: Expired; 3: active")
    private Integer licenseStatus;
    @Schema(name="statusCategory", description="Device status category should be a value as follows: 0: Disconnected; 1: Connected; 2: Pending; 3: Heartbeat Missed; 4: Isolated")
    private Integer statusCategory;
    @Schema(name="version", description="The device firmware version.")
    private String version;
    @Schema(name="addedInAdvanced", description="Whether the device is added in advanced.")
    private Boolean addedInAdvanced;
    @Schema(name="active", description="whether to active the device(cloud base exclusive)")
    private Boolean active;
    @Schema(name="wirelessLinked", description="whether ap is wireless linked")
    private Boolean wirelessLinked;
    @Schema(name="fwDownload", description="Indicates whether the upgrade status is downloading")
    private Boolean fwDownload;
    @Schema(name="needUpgrade", description="Indicates whether an upgrade is required")
    private Boolean needUpgrade;

    public static UpgradeableDevicesOpenApiVO buildByDeviceVO(DeviceVO deviceVO) {
        if (Objects.isNull(deviceVO)) {
            return new UpgradeableDevicesOpenApiVO();
        }
        return new UpgradeableDevicesOpenApiVO(deviceVO.getName(), deviceVO.getMac(), deviceVO.getType(), deviceVO.getModel(), deviceVO.getModelVersion(), deviceVO.getStatus(), deviceVO.getLatestVersion(), deviceVO.getCustomId(), deviceVO.getSite(), deviceVO.getLicenseStatus(), deviceVO.getStatusCategory(), deviceVO.getVersion(), deviceVO.getAddedInAdvanced(), deviceVO.getActive(), null, deviceVO.getFwDownload(), deviceVO.getNeedUpgrade());
    }

    @Generated
    public UpgradeableDevicesOpenApiVO() {
    }

    @Generated
    public UpgradeableDevicesOpenApiVO(String name, String mac, String type, String model, String modelVersion, Integer status, String latestVersion, String omadacId, String siteId, Integer licenseStatus, Integer statusCategory, String version, Boolean addedInAdvanced, Boolean active, Boolean wirelessLinked, Boolean fwDownload, Boolean needUpgrade) {
        this.name = name;
        this.mac = mac;
        this.type = type;
        this.model = model;
        this.modelVersion = modelVersion;
        this.status = status;
        this.latestVersion = latestVersion;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.licenseStatus = licenseStatus;
        this.statusCategory = statusCategory;
        this.version = version;
        this.addedInAdvanced = addedInAdvanced;
        this.active = active;
        this.wirelessLinked = wirelessLinked;
        this.fwDownload = fwDownload;
        this.needUpgrade = needUpgrade;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public Integer getStatusCategory() {
        return this.statusCategory;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Boolean getAddedInAdvanced() {
        return this.addedInAdvanced;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getWirelessLinked() {
        return this.wirelessLinked;
    }

    @Generated
    public Boolean getFwDownload() {
        return this.fwDownload;
    }

    @Generated
    public Boolean getNeedUpgrade() {
        return this.needUpgrade;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    @Generated
    public void setStatusCategory(Integer statusCategory) {
        this.statusCategory = statusCategory;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setAddedInAdvanced(Boolean addedInAdvanced) {
        this.addedInAdvanced = addedInAdvanced;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setWirelessLinked(Boolean wirelessLinked) {
        this.wirelessLinked = wirelessLinked;
    }

    @Generated
    public void setFwDownload(Boolean fwDownload) {
        this.fwDownload = fwDownload;
    }

    @Generated
    public void setNeedUpgrade(Boolean needUpgrade) {
        this.needUpgrade = needUpgrade;
    }

    @Generated
    public String toString() {
        return "UpgradeableDevicesOpenApiVO(name=" + this.getName() + ", mac=" + this.getMac() + ", type=" + this.getType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", status=" + this.getStatus() + ", latestVersion=" + this.getLatestVersion() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", licenseStatus=" + this.getLicenseStatus() + ", statusCategory=" + this.getStatusCategory() + ", version=" + this.getVersion() + ", addedInAdvanced=" + this.getAddedInAdvanced() + ", active=" + this.getActive() + ", wirelessLinked=" + this.getWirelessLinked() + ", fwDownload=" + this.getFwDownload() + ", needUpgrade=" + this.getNeedUpgrade() + ")";
    }
}

