/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.embed;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.embed.MultiBandInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.CandidateParentWebVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(description="Candidate parent ap info")
public class CandidateParentOpenApiVO {
    @Schema(name="priorityStatus", description="priority parent ap status")
    private Integer priorityStatus;
    @Schema(name="mac", description="candidate parent ap mac")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="name", description="candidate parent ap name")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    @Schema(name="linkStatus", description="0-init; 1-linking; 2-linked; 3-link fail; 4-offline")
    private Integer linkStatus;
    @Schema(name="hop", description="The number of hops to mesh with the candidate parent AP")
    private Integer hop;
    @Schema(name="childsnum", description="The number of child aps already connected to the candidate parent ap")
    private Integer childsNum;
    @Schema(name="support5gMultiBand", description="5G support 5G1 & 5G2 multi band")
    private Boolean support5gMultiBand;
    @Schema(name="multiBandInfo", description="multi band info of candidate parent ap")
    @JsonProperty(value="multiBandInfo")
    @Valid
    private List<MultiBandInfoOpenApiVO> multiBandInfo;
    @Schema(name="model", description="Model")
    private String model;
    @Schema(name="modelVersion", description="Model version")
    private String modelVersion;

    public static CandidateParentOpenApiVO buildFromWebVO(CandidateParentWebVO vo) {
        CandidateParentOpenApiVO candidateParentOpenApiVO = new CandidateParentOpenApiVO();
        candidateParentOpenApiVO.setPriorityStatus(vo.getPriorityStatus());
        candidateParentOpenApiVO.setMac(vo.getMac());
        candidateParentOpenApiVO.setName(vo.getName());
        candidateParentOpenApiVO.setLinkStatus(vo.getLinkStatus());
        candidateParentOpenApiVO.setHop(vo.getHop());
        candidateParentOpenApiVO.setChildsNum(vo.getChildsNum());
        candidateParentOpenApiVO.setSupport5gMultiBand(vo.getSupport5gMultiBand());
        candidateParentOpenApiVO.setMultiBandInfo(Optional.ofNullable(vo.getMultiBandInfo()).map(list -> list.stream().map(MultiBandInfoOpenApiVO::buildFromWebVO).toList()).orElse(null));
        candidateParentOpenApiVO.setModel(vo.getModel());
        candidateParentOpenApiVO.setModelVersion(vo.getModelVersion());
        return candidateParentOpenApiVO;
    }

    @Generated
    public String toString() {
        return "CandidateParentOpenApiVO(priorityStatus=" + this.getPriorityStatus() + ", mac=" + this.getMac() + ", name=" + this.getName() + ", linkStatus=" + this.getLinkStatus() + ", hop=" + this.getHop() + ", childsNum=" + this.getChildsNum() + ", support5gMultiBand=" + this.getSupport5gMultiBand() + ", multiBandInfo=" + this.getMultiBandInfo() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ")";
    }

    @Generated
    public Integer getPriorityStatus() {
        return this.priorityStatus;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLinkStatus() {
        return this.linkStatus;
    }

    @Generated
    public Integer getHop() {
        return this.hop;
    }

    @Generated
    public Integer getChildsNum() {
        return this.childsNum;
    }

    @Generated
    public Boolean getSupport5gMultiBand() {
        return this.support5gMultiBand;
    }

    @Generated
    public List<MultiBandInfoOpenApiVO> getMultiBandInfo() {
        return this.multiBandInfo;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public void setPriorityStatus(Integer priorityStatus) {
        this.priorityStatus = priorityStatus;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLinkStatus(Integer linkStatus) {
        this.linkStatus = linkStatus;
    }

    @Generated
    public void setHop(Integer hop) {
        this.hop = hop;
    }

    @Generated
    public void setChildsNum(Integer childsNum) {
        this.childsNum = childsNum;
    }

    @Generated
    public void setSupport5gMultiBand(Boolean support5gMultiBand) {
        this.support5gMultiBand = support5gMultiBand;
    }

    @JsonProperty(value="multiBandInfo")
    @Generated
    public void setMultiBandInfo(List<MultiBandInfoOpenApiVO> multiBandInfo) {
        this.multiBandInfo = multiBandInfo;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public CandidateParentOpenApiVO() {
    }

    @Generated
    public CandidateParentOpenApiVO(Integer priorityStatus, String mac, String name, Integer linkStatus, Integer hop, Integer childsNum, Boolean support5gMultiBand, List<MultiBandInfoOpenApiVO> multiBandInfo, String model, String modelVersion) {
        this.priorityStatus = priorityStatus;
        this.mac = mac;
        this.name = name;
        this.linkStatus = linkStatus;
        this.hop = hop;
        this.childsNum = childsNum;
        this.support5gMultiBand = support5gMultiBand;
        this.multiBandInfo = multiBandInfo;
        this.model = model;
        this.modelVersion = modelVersion;
    }
}

