/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.cache.a.a.c;
import com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting.embed.MultiBandInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.CandidateParentForAdoptWebVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.MultiBandInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;

public class CandidateParentForAdoptOpenApiVO
extends com.tplink.smb.omada.common.cache.a.a {
    @Schema(name="mac", description="candidate parent ap mac")
    @c(b="mac")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="name", description="candidate parent ap name")
    @c(b="name")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String name;
    @Schema(name="linkStatus", description="0-init; 1-linking; 2-linked; 3-link fail; 4-offline")
    private Integer linkStatus;
    @Schema(name="hop", description="The number of hops to mesh with the candidate parent AP")
    private Integer hop;
    @Schema(name="childsnum", description="The number of child aps already connected to the candidate parent ap")
    private Integer childsNum;
    @Schema(name="recommend", description="Whether the ap is recommended by the algorithm for connection")
    private Boolean recommend;
    @Schema(name="recommendRadioId", description="The radio ID for mesh recommended by the algorithm")
    private Integer recommendRadioId;
    @Schema(name="multiBandInfo", description="multi band info of candidate parent ap")
    @JsonProperty(value="multiBandInfo")
    @Valid
    private List<MultiBandInfoOpenApiVO> multiBandInfo;

    public static String[] getSearchKeys() {
        return new String[]{"name", "mac"};
    }

    public static CandidateParentForAdoptOpenApiVO buildFromWebVO(CandidateParentForAdoptWebVO vo) {
        CandidateParentForAdoptOpenApiVO candidateParentForAdoptOpenApiVO = new CandidateParentForAdoptOpenApiVO();
        candidateParentForAdoptOpenApiVO.setMac(vo.getMac());
        candidateParentForAdoptOpenApiVO.setName(vo.getName());
        candidateParentForAdoptOpenApiVO.setLinkStatus(vo.getLinkStatus());
        candidateParentForAdoptOpenApiVO.setHop(vo.getHop());
        candidateParentForAdoptOpenApiVO.setChildsNum(vo.getChildsNum());
        candidateParentForAdoptOpenApiVO.setRecommend(vo.getRecommend());
        candidateParentForAdoptOpenApiVO.setRecommendRadioId(vo.getRecommendRadioId());
        candidateParentForAdoptOpenApiVO.setMultiBandInfo(CandidateParentForAdoptOpenApiVO.convertMultiBandInfo(vo.getMultiBandInfo()));
        return candidateParentForAdoptOpenApiVO;
    }

    private static List<MultiBandInfoOpenApiVO> convertMultiBandInfo(List<MultiBandInfoVO> multiBandInfoVOS) {
        return multiBandInfoVOS.stream().map(MultiBandInfoOpenApiVO::buildFromWebVO).toList();
    }

    @Generated
    public String toString() {
        return "CandidateParentForAdoptOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", linkStatus=" + this.getLinkStatus() + ", hop=" + this.getHop() + ", childsNum=" + this.getChildsNum() + ", recommend=" + this.getRecommend() + ", recommendRadioId=" + this.getRecommendRadioId() + ", multiBandInfo=" + this.getMultiBandInfo() + ")";
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLinkStatus() {
        return this.linkStatus;
    }

    @Generated
    public Integer getHop() {
        return this.hop;
    }

    @Generated
    public Integer getChildsNum() {
        return this.childsNum;
    }

    @Generated
    public Boolean getRecommend() {
        return this.recommend;
    }

    @Generated
    public Integer getRecommendRadioId() {
        return this.recommendRadioId;
    }

    @Generated
    public List<MultiBandInfoOpenApiVO> getMultiBandInfo() {
        return this.multiBandInfo;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLinkStatus(Integer linkStatus) {
        this.linkStatus = linkStatus;
    }

    @Generated
    public void setHop(Integer hop) {
        this.hop = hop;
    }

    @Generated
    public void setChildsNum(Integer childsNum) {
        this.childsNum = childsNum;
    }

    @Generated
    public void setRecommend(Boolean recommend) {
        this.recommend = recommend;
    }

    @Generated
    public void setRecommendRadioId(Integer recommendRadioId) {
        this.recommendRadioId = recommendRadioId;
    }

    @JsonProperty(value="multiBandInfo")
    @Generated
    public void setMultiBandInfo(List<MultiBandInfoOpenApiVO> multiBandInfo) {
        this.multiBandInfo = multiBandInfo;
    }

    @Generated
    public CandidateParentForAdoptOpenApiVO() {
    }

    @Generated
    public CandidateParentForAdoptOpenApiVO(String mac, String name, Integer linkStatus, Integer hop, Integer childsNum, Boolean recommend, Integer recommendRadioId, List<MultiBandInfoOpenApiVO> multiBandInfo) {
        this.mac = mac;
        this.name = name;
        this.linkStatus = linkStatus;
        this.hop = hop;
        this.childsNum = childsNum;
        this.recommend = recommend;
        this.recommendRadioId = recommendRadioId;
        this.multiBandInfo = multiBandInfo;
    }
}

