/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

public class BatchUpdateApPowerSavingConfigOpenApiVO {
    @Schema(name="apMacList", description="AP mac list")
    @NotNull(message="Parameter [apMacList] should not be null")
    @a
    private @NotNull(message="Parameter [apMacList] should not be null") List<String> apMacList;
    @Schema(name="timeEnable", description="Power Saving trigger by time config status. True: enable, false: disable.")
    private Boolean timeEnable;
    @Schema(name="startTimeH", description="Start time of trigger by time(unit: hour); It should be within the range of 0\u201323; This field is required when Parameter [timeEnable] is true.")
    @Range(min=0L, max=23L, message="Parameter [startTimeH] should be between 0 and 23")
    private @Range(min=0L, max=23L, message="Parameter [startTimeH] should be between 0 and 23") Integer startTimeH;
    @Schema(name="startTimeM", description="Start time of trigger by time(unit: minute); It should be within the range of 0\u201359; This field is required when Parameter [timeEnable] is true.")
    @Range(min=0L, max=59L, message="Parameter [startTimeM] should be between 0 and 59")
    private @Range(min=0L, max=59L, message="Parameter [startTimeM] should be between 0 and 59") Integer startTimeM;
    @Schema(name="endTimeH", description="End time of trigger by time(unit: hour); It should be within the range of 0\u201323; This field is required when Parameter [timeEnable] is true.")
    @Range(min=0L, max=23L, message="Parameter [endTimeH] should be between 0 and 23")
    private @Range(min=0L, max=23L, message="Parameter [endTimeH] should be between 0 and 23") Integer endTimeH;
    @Schema(name="endTimeM", description="End time of trigger by time(unit: minute); It should be within the range of 0\u201359; This field is required when Parameter [timeEnable] is true.")
    @Range(min=0L, max=59L, message="Parameter [endTimeM] should be between 0 and 59")
    private @Range(min=0L, max=59L, message="Parameter [endTimeM] should be between 0 and 59") Integer endTimeM;
    @Schema(name="bandEnable", description="Power Saving trigger by band config status. True: enable, false: disable.")
    private Boolean bandEnable;
    @Schema(name="bands", description="Select bands list config of trigger by band;It should be a value as follows: 0: 2.4GHz; 1: 5GHz; 2: 5G2Hz; 3: 6GHz;This field is required when Parameter [bandEnable] is true;Please note that the band filled in must be supported by the device, otherwise the modified configuration will not take effect properly")
    @Size(min=1, message="Parameter [bands] should contain at least one band")
    private @Size(min=1, message="Parameter [bands] should contain at least one band") List<Integer> bands;
    @Schema(name="idleDuration", description="Idle duration config of trigger by band(unit: minute); It should be within the range of 60\u20131440; This field is required when Parameter [bandEnable] is true.")
    @Range(min=60L, max=1440L, message="Parameter [idleDuration] should between 60 and 1440.")
    private @Range(min=60L, max=1440L, message="Parameter [idleDuration] should between 60 and 1440.") Integer idleDuration;

    public static OperationResponse validatePowerSavingConfigOpenApiVO(BatchUpdateApPowerSavingConfigOpenApiVO configVO) {
        if (Boolean.TRUE.equals(configVO.getTimeEnable()) && (configVO.getStartTimeH() == null || configVO.getStartTimeM() == null || configVO.getEndTimeH() == null || configVO.getEndTimeM() == null)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(configVO.getBandEnable()) && (CollectionUtils.isEmpty(configVO.getBands()) || configVO.getIdleDuration() == null)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    protected BatchUpdateApPowerSavingConfigOpenApiVO(BatchUpdateApPowerSavingConfigOpenApiVOBuilder<?, ?> b2) {
        this.apMacList = b2.apMacList;
        this.timeEnable = b2.timeEnable;
        this.startTimeH = b2.startTimeH;
        this.startTimeM = b2.startTimeM;
        this.endTimeH = b2.endTimeH;
        this.endTimeM = b2.endTimeM;
        this.bandEnable = b2.bandEnable;
        this.bands = b2.bands;
        this.idleDuration = b2.idleDuration;
    }

    @Generated
    public static BatchUpdateApPowerSavingConfigOpenApiVOBuilder<?, ?> builder() {
        return new BatchUpdateApPowerSavingConfigOpenApiVOBuilderImpl();
    }

    @Generated
    public List<String> getApMacList() {
        return this.apMacList;
    }

    @Generated
    public Boolean getTimeEnable() {
        return this.timeEnable;
    }

    @Generated
    public Integer getStartTimeH() {
        return this.startTimeH;
    }

    @Generated
    public Integer getStartTimeM() {
        return this.startTimeM;
    }

    @Generated
    public Integer getEndTimeH() {
        return this.endTimeH;
    }

    @Generated
    public Integer getEndTimeM() {
        return this.endTimeM;
    }

    @Generated
    public Boolean getBandEnable() {
        return this.bandEnable;
    }

    @Generated
    public List<Integer> getBands() {
        return this.bands;
    }

    @Generated
    public Integer getIdleDuration() {
        return this.idleDuration;
    }

    @Generated
    public void setApMacList(List<String> apMacList) {
        this.apMacList = apMacList;
    }

    @Generated
    public void setTimeEnable(Boolean timeEnable) {
        this.timeEnable = timeEnable;
    }

    @Generated
    public void setStartTimeH(Integer startTimeH) {
        this.startTimeH = startTimeH;
    }

    @Generated
    public void setStartTimeM(Integer startTimeM) {
        this.startTimeM = startTimeM;
    }

    @Generated
    public void setEndTimeH(Integer endTimeH) {
        this.endTimeH = endTimeH;
    }

    @Generated
    public void setEndTimeM(Integer endTimeM) {
        this.endTimeM = endTimeM;
    }

    @Generated
    public void setBandEnable(Boolean bandEnable) {
        this.bandEnable = bandEnable;
    }

    @Generated
    public void setBands(List<Integer> bands) {
        this.bands = bands;
    }

    @Generated
    public void setIdleDuration(Integer idleDuration) {
        this.idleDuration = idleDuration;
    }

    @Generated
    public BatchUpdateApPowerSavingConfigOpenApiVO() {
    }

    @Generated
    public BatchUpdateApPowerSavingConfigOpenApiVO(List<String> apMacList, Boolean timeEnable, Integer startTimeH, Integer startTimeM, Integer endTimeH, Integer endTimeM, Boolean bandEnable, List<Integer> bands, Integer idleDuration) {
        this.apMacList = apMacList;
        this.timeEnable = timeEnable;
        this.startTimeH = startTimeH;
        this.startTimeM = startTimeM;
        this.endTimeH = endTimeH;
        this.endTimeM = endTimeM;
        this.bandEnable = bandEnable;
        this.bands = bands;
        this.idleDuration = idleDuration;
    }

    @Generated
    public String toString() {
        return "BatchUpdateApPowerSavingConfigOpenApiVO(apMacList=" + this.getApMacList() + ", timeEnable=" + this.getTimeEnable() + ", startTimeH=" + this.getStartTimeH() + ", startTimeM=" + this.getStartTimeM() + ", endTimeH=" + this.getEndTimeH() + ", endTimeM=" + this.getEndTimeM() + ", bandEnable=" + this.getBandEnable() + ", bands=" + this.getBands() + ", idleDuration=" + this.getIdleDuration() + ")";
    }

    @Generated
    public static abstract class BatchUpdateApPowerSavingConfigOpenApiVOBuilder<C extends BatchUpdateApPowerSavingConfigOpenApiVO, B extends BatchUpdateApPowerSavingConfigOpenApiVOBuilder<C, B>> {
        @Generated
        private List<String> apMacList;
        @Generated
        private Boolean timeEnable;
        @Generated
        private Integer startTimeH;
        @Generated
        private Integer startTimeM;
        @Generated
        private Integer endTimeH;
        @Generated
        private Integer endTimeM;
        @Generated
        private Boolean bandEnable;
        @Generated
        private List<Integer> bands;
        @Generated
        private Integer idleDuration;

        @Generated
        public B apMacList(List<String> apMacList) {
            this.apMacList = apMacList;
            return this.self();
        }

        @Generated
        public B timeEnable(Boolean timeEnable) {
            this.timeEnable = timeEnable;
            return this.self();
        }

        @Generated
        public B startTimeH(Integer startTimeH) {
            this.startTimeH = startTimeH;
            return this.self();
        }

        @Generated
        public B startTimeM(Integer startTimeM) {
            this.startTimeM = startTimeM;
            return this.self();
        }

        @Generated
        public B endTimeH(Integer endTimeH) {
            this.endTimeH = endTimeH;
            return this.self();
        }

        @Generated
        public B endTimeM(Integer endTimeM) {
            this.endTimeM = endTimeM;
            return this.self();
        }

        @Generated
        public B bandEnable(Boolean bandEnable) {
            this.bandEnable = bandEnable;
            return this.self();
        }

        @Generated
        public B bands(List<Integer> bands) {
            this.bands = bands;
            return this.self();
        }

        @Generated
        public B idleDuration(Integer idleDuration) {
            this.idleDuration = idleDuration;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchUpdateApPowerSavingConfigOpenApiVO.BatchUpdateApPowerSavingConfigOpenApiVOBuilder(apMacList=" + this.apMacList + ", timeEnable=" + this.timeEnable + ", startTimeH=" + this.startTimeH + ", startTimeM=" + this.startTimeM + ", endTimeH=" + this.endTimeH + ", endTimeM=" + this.endTimeM + ", bandEnable=" + this.bandEnable + ", bands=" + this.bands + ", idleDuration=" + this.idleDuration + ")";
        }
    }

    @Generated
    private static final class BatchUpdateApPowerSavingConfigOpenApiVOBuilderImpl
    extends BatchUpdateApPowerSavingConfigOpenApiVOBuilder<BatchUpdateApPowerSavingConfigOpenApiVO, BatchUpdateApPowerSavingConfigOpenApiVOBuilderImpl> {
        @Generated
        private BatchUpdateApPowerSavingConfigOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchUpdateApPowerSavingConfigOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchUpdateApPowerSavingConfigOpenApiVO build() {
            return new BatchUpdateApPowerSavingConfigOpenApiVO(this);
        }
    }
}

