/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApVoipVlanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ApVoipVlanSettingOpenApiVO {
    private static final Integer VOIP_VLAN_MODE_FOLLOW_MVLAN = 0;
    private static final Integer VOIP_VLAN_MODE_FOLLOW_CUSTOM = 1;
    private static final Integer VOIP_VLAN_IP_TYPE_STATIC = 0;
    private static final Integer VOIP_VLAN_IP_TYPE_DHCP = 1;
    @Range(min=0L, max=1L)
    @NotNull
    @Schema(name="mode", description="VoIP VLAN mode. 0 : Follow Management VLAN. 1: Custom.")
    private @Range(min=0L, max=1L) @NotNull Integer mode;
    @Schema(name="lanNetworkId", description="LAN network ID. Parameter [lanNetworkId] should not be null, and should not be the same as the lanNetworkId of management VLAN when parameter [mode] is 1.")
    private String lanNetworkId;
    @Range(min=1L, max=4090L, message="Invalid bridge VLAN.")
    @Schema(name="voipBridgeVlan", description="VoIP bridge vlan. Parameter [voipBridgeVlan] should not be null and be between 1 and 4090 when parameter [lanNetworkId] corresponds to a multiple VLAN LAN network.")
    private @Range(min=1L, max=4090L, message="Invalid bridge VLAN.") Integer voipBridgeVlan;
    @Range(min=0L, max=1L)
    @Schema(name="ipType", description="VoIP VLAN IP Type. 0: Static IP. 1: DHCP.")
    private @Range(min=0L, max=1L) Integer ipType;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ip", description="VoIP VLAN IP. Parameter [ip] should not be null when [ipType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ip address.") String ip;
    @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid ipMask.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ipMask", description="VoIP VLAN IP mask. Parameter [ipMask] should not be null when [ipType] is 0.")
    private @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid ipMask.") String ipMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipGateway.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ipGateway", description="VoIP VLAN IP gateway. Parameter [ipGateway] should not be null when [ipType] is 0.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipGateway.") String ipGateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns1.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ipDns1", description="IP DNS1.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns1.") String ipDns1;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns2.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ipDns2", description="IP DNS2.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid ipDns2.") String ipDns2;

    public boolean validate() {
        if (Objects.equals(this.getMode(), VOIP_VLAN_MODE_FOLLOW_CUSTOM)) {
            if (this.getIpType() == null) {
                return false;
            }
            if (Objects.equals(this.getIpType(), VOIP_VLAN_IP_TYPE_STATIC) && (T.a((String)this.getIp()) || T.a((String)this.getIpMask()) || T.a((String)this.getIpGateway()))) {
                return false;
            }
        }
        return true;
    }

    public boolean validateByBatchModify() {
        if (Objects.equals(this.getMode(), VOIP_VLAN_MODE_FOLLOW_CUSTOM)) {
            if (this.getIpType() == null) {
                return true;
            }
            if (Objects.equals(this.getIpType(), VOIP_VLAN_IP_TYPE_STATIC)) {
                return false;
            }
        }
        return true;
    }

    public static ApVoipVlanSettingVO toApVoipVlanSettingVO(ApVoipVlanSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        ApVoipVlanSettingVO apVoipVlanSettingVO = new ApVoipVlanSettingVO();
        apVoipVlanSettingVO.setIp(openApiVO.getIp());
        apVoipVlanSettingVO.setVoipBridgeVlan(openApiVO.getVoipBridgeVlan());
        apVoipVlanSettingVO.setMode(openApiVO.getMode());
        apVoipVlanSettingVO.setIpGateway(openApiVO.getIpGateway());
        apVoipVlanSettingVO.setIpDns2(openApiVO.getIpDns2());
        apVoipVlanSettingVO.setIpDns1(openApiVO.getIpDns1());
        apVoipVlanSettingVO.setIpMask(openApiVO.getIpMask());
        apVoipVlanSettingVO.setIpType(openApiVO.getIpType());
        apVoipVlanSettingVO.setLanNetworkId(openApiVO.getLanNetworkId());
        return apVoipVlanSettingVO;
    }

    public static ApVoipVlanSettingOpenApiVO fromApVoipVlanSettingVO(ApVoipVlanSettingVO webVO) {
        if (webVO == null) {
            return null;
        }
        ApVoipVlanSettingOpenApiVO openApiVO = new ApVoipVlanSettingOpenApiVO();
        openApiVO.setIp(webVO.getIp());
        openApiVO.setVoipBridgeVlan(webVO.getVoipBridgeVlan());
        openApiVO.setMode(webVO.getMode());
        openApiVO.setIpGateway(webVO.getIpGateway());
        openApiVO.setIpDns2(webVO.getIpDns2());
        openApiVO.setIpDns1(webVO.getIpDns1());
        openApiVO.setIpMask(webVO.getIpMask());
        openApiVO.setIpType(webVO.getIpType());
        openApiVO.setLanNetworkId(webVO.getLanNetworkId());
        return openApiVO;
    }

    @Generated
    public static ApVoipVlanSettingOpenApiVOBuilder builder() {
        return new ApVoipVlanSettingOpenApiVOBuilder();
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getLanNetworkId() {
        return this.lanNetworkId;
    }

    @Generated
    public Integer getVoipBridgeVlan() {
        return this.voipBridgeVlan;
    }

    @Generated
    public Integer getIpType() {
        return this.ipType;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getIpMask() {
        return this.ipMask;
    }

    @Generated
    public String getIpGateway() {
        return this.ipGateway;
    }

    @Generated
    public String getIpDns1() {
        return this.ipDns1;
    }

    @Generated
    public String getIpDns2() {
        return this.ipDns2;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setLanNetworkId(String lanNetworkId) {
        this.lanNetworkId = lanNetworkId;
    }

    @Generated
    public void setVoipBridgeVlan(Integer voipBridgeVlan) {
        this.voipBridgeVlan = voipBridgeVlan;
    }

    @Generated
    public void setIpType(Integer ipType) {
        this.ipType = ipType;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpMask(String ipMask) {
        this.ipMask = ipMask;
    }

    @Generated
    public void setIpGateway(String ipGateway) {
        this.ipGateway = ipGateway;
    }

    @Generated
    public void setIpDns1(String ipDns1) {
        this.ipDns1 = ipDns1;
    }

    @Generated
    public void setIpDns2(String ipDns2) {
        this.ipDns2 = ipDns2;
    }

    @Generated
    public String toString() {
        return "ApVoipVlanSettingOpenApiVO(mode=" + this.getMode() + ", lanNetworkId=" + this.getLanNetworkId() + ", voipBridgeVlan=" + this.getVoipBridgeVlan() + ", ipType=" + this.getIpType() + ", ip=" + this.getIp() + ", ipMask=" + this.getIpMask() + ", ipGateway=" + this.getIpGateway() + ", ipDns1=" + this.getIpDns1() + ", ipDns2=" + this.getIpDns2() + ")";
    }

    @Generated
    public ApVoipVlanSettingOpenApiVO() {
    }

    @Generated
    public ApVoipVlanSettingOpenApiVO(Integer mode, String lanNetworkId, Integer voipBridgeVlan, Integer ipType, String ip, String ipMask, String ipGateway, String ipDns1, String ipDns2) {
        this.mode = mode;
        this.lanNetworkId = lanNetworkId;
        this.voipBridgeVlan = voipBridgeVlan;
        this.ipType = ipType;
        this.ip = ip;
        this.ipMask = ipMask;
        this.ipGateway = ipGateway;
        this.ipDns1 = ipDns1;
        this.ipDns2 = ipDns2;
    }

    @Generated
    public static class ApVoipVlanSettingOpenApiVOBuilder {
        @Generated
        private Integer mode;
        @Generated
        private String lanNetworkId;
        @Generated
        private Integer voipBridgeVlan;
        @Generated
        private Integer ipType;
        @Generated
        private String ip;
        @Generated
        private String ipMask;
        @Generated
        private String ipGateway;
        @Generated
        private String ipDns1;
        @Generated
        private String ipDns2;

        @Generated
        ApVoipVlanSettingOpenApiVOBuilder() {
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder mode(Integer mode) {
            this.mode = mode;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder lanNetworkId(String lanNetworkId) {
            this.lanNetworkId = lanNetworkId;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder voipBridgeVlan(Integer voipBridgeVlan) {
            this.voipBridgeVlan = voipBridgeVlan;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ipType(Integer ipType) {
            this.ipType = ipType;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ipMask(String ipMask) {
            this.ipMask = ipMask;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ipGateway(String ipGateway) {
            this.ipGateway = ipGateway;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ipDns1(String ipDns1) {
            this.ipDns1 = ipDns1;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVOBuilder ipDns2(String ipDns2) {
            this.ipDns2 = ipDns2;
            return this;
        }

        @Generated
        public ApVoipVlanSettingOpenApiVO build() {
            return new ApVoipVlanSettingOpenApiVO(this.mode, this.lanNetworkId, this.voipBridgeVlan, this.ipType, this.ip, this.ipMask, this.ipGateway, this.ipDns1, this.ipDns2);
        }

        @Generated
        public String toString() {
            return "ApVoipVlanSettingOpenApiVO.ApVoipVlanSettingOpenApiVOBuilder(mode=" + this.mode + ", lanNetworkId=" + this.lanNetworkId + ", voipBridgeVlan=" + this.voipBridgeVlan + ", ipType=" + this.ipType + ", ip=" + this.ip + ", ipMask=" + this.ipMask + ", ipGateway=" + this.ipGateway + ", ipDns1=" + this.ipDns1 + ", ipDns2=" + this.ipDns2 + ")";
        }
    }
}

