/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApRadioSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ApRadioSettingopenApiVO {
    @Schema(name="radioEnable", description="Enable/Disable radio setting(if false, other params is not required)")
    private Boolean radioEnable;
    @Schema(name="channelRange", description="Custom optional channel freq collection.")
    private List<Integer> channelRange;
    @Schema(name="channelWidth", description="RADIO_20 = 2; RADIO_40 = 3; RADIO_40_20 = 4(corresponding 2G Auto); RADIO_80 = 5; RADIO_80_40_20 = 6(corresponding 5G Auto); RADIO_160= 7; RADIO_160_80_40_20 = 8; RADIO_240 = 9; RADIO_320 = 10")
    @Pattern(regexp="^([2-9]|10)$", message="Parameter [channelWidth] should be from 2 to 10.")
    private @Pattern(regexp="^([2-9]|10)$", message="Parameter [channelWidth] should be from 2 to 10.") String channelWidth;
    @Schema(name="channel", description="Channel Index; The channel index list supported by device can be obtained from interface : Get available channel list of ap; If select auto configuration need to enter 0.")
    @Pattern(regexp="^[0-9]+$", message="Parameter [channel] should be a number.")
    private @Pattern(regexp="^[0-9]+$", message="Parameter [channel] should be a number.") String channel;
    @Schema(name="txPower", description="TX Power")
    private Integer txPower;
    @Schema(name="txPowerLevel", description="It should be a value as follows: 0: Low; 1: Medium; 2: High; 3: Custom; 4: Auto")
    @Range(min=0L, max=4L, message="Parameter [txPowerLevel] should be from 0 to 4.")
    private @Range(min=0L, max=4L, message="Parameter [txPowerLevel] should be from 0 to 4.") Integer txPowerLevel;
    @Schema(name="channelLimitEnable", description="Enable channel limit(site level)")
    private Boolean channelLimitEnable;
    @Schema(name="freq", description="Frequency;The frequency list supported by device can be obtained from interface : Get available channel list of ap.The freq and channel fields should be corresponding, otherwise the channel will be corrected based on the freq field.")
    private Integer freq;
    @Schema(name="wirelessMode", description="Wireless mode config status of the device; -2 : Auto; 3 : 802.11b/g mixed(Only for 2.4G); 4 : 802.11b/g/n mixed(Only for 2.4G); 13 : 802.11b/g/n/ax mixed(Only for 2.4G); 17 : 802.11b/g/n/ax/be mixed(Only for 2.4G); 7 : 802.11a/n mixed(Only for 5G); 10 : 802.11a/n/ac mixed(Only for 5G); 16 : 802.11a/n/ac/ax mixed(Only for 5G); 18 : 802.11a/n/ac/ax/be mixed(Only for 5G); 11 : 802.11ax only(Only for 6G); 19 : 802.11ax/be mixed(Only for 6G).")
    @NumberSet(value={-2, 3, 4, 13, 17, 7, 10, 16, 18, 11, 19}, message="Invalid wireless mode.")
    private Integer wirelessMode;
    @Schema(name="nonPscEnable", description="APP 6G Radio Setting")
    private Boolean nonPscEnable;
    @Schema(name="autoSwitchOffWifi", description="Whether enable to auto switch off wifi")
    private Boolean autoSwitchOffWifi;
    @Schema(name="autoSwitchOffWifiInterval", description="The interval of auto switch off wifi")
    private Integer autoSwitchOffWifiInterval;

    public static ApRadioSettingVO toWebVO(ApRadioSettingopenApiVO vo) {
        if (vo == null) {
            return null;
        }
        ApRadioSettingVO res = new ApRadioSettingVO();
        res.setRadioEnable(vo.getRadioEnable());
        res.setChannelRange(vo.getChannelRange());
        res.setChannelWidth(vo.getChannelWidth());
        res.setChannel(vo.getChannel());
        res.setTxPower(vo.getTxPower());
        res.setTxPowerLevel(vo.getTxPowerLevel());
        res.setChannelLimitEnable(vo.getChannelLimitEnable());
        res.setFreq(vo.getFreq());
        res.setWirelessMode(vo.getWirelessMode());
        res.setAutoSwitchOffWifi(vo.getAutoSwitchOffWifi());
        res.setAutoSwitchOffWifiInterval(vo.getAutoSwitchOffWifiInterval());
        return res;
    }

    @Generated
    protected ApRadioSettingopenApiVO(ApRadioSettingopenApiVOBuilder<?, ?> b2) {
        this.radioEnable = b2.radioEnable;
        this.channelRange = b2.channelRange;
        this.channelWidth = b2.channelWidth;
        this.channel = b2.channel;
        this.txPower = b2.txPower;
        this.txPowerLevel = b2.txPowerLevel;
        this.channelLimitEnable = b2.channelLimitEnable;
        this.freq = b2.freq;
        this.wirelessMode = b2.wirelessMode;
        this.nonPscEnable = b2.nonPscEnable;
        this.autoSwitchOffWifi = b2.autoSwitchOffWifi;
        this.autoSwitchOffWifiInterval = b2.autoSwitchOffWifiInterval;
    }

    @Generated
    public static ApRadioSettingopenApiVOBuilder<?, ?> builder() {
        return new ApRadioSettingopenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getRadioEnable() {
        return this.radioEnable;
    }

    @Generated
    public List<Integer> getChannelRange() {
        return this.channelRange;
    }

    @Generated
    public String getChannelWidth() {
        return this.channelWidth;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public Integer getTxPower() {
        return this.txPower;
    }

    @Generated
    public Integer getTxPowerLevel() {
        return this.txPowerLevel;
    }

    @Generated
    public Boolean getChannelLimitEnable() {
        return this.channelLimitEnable;
    }

    @Generated
    public Integer getFreq() {
        return this.freq;
    }

    @Generated
    public Integer getWirelessMode() {
        return this.wirelessMode;
    }

    @Generated
    public Boolean getNonPscEnable() {
        return this.nonPscEnable;
    }

    @Generated
    public Boolean getAutoSwitchOffWifi() {
        return this.autoSwitchOffWifi;
    }

    @Generated
    public Integer getAutoSwitchOffWifiInterval() {
        return this.autoSwitchOffWifiInterval;
    }

    @Generated
    public void setRadioEnable(Boolean radioEnable) {
        this.radioEnable = radioEnable;
    }

    @Generated
    public void setChannelRange(List<Integer> channelRange) {
        this.channelRange = channelRange;
    }

    @Generated
    public void setChannelWidth(String channelWidth) {
        this.channelWidth = channelWidth;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setTxPower(Integer txPower) {
        this.txPower = txPower;
    }

    @Generated
    public void setTxPowerLevel(Integer txPowerLevel) {
        this.txPowerLevel = txPowerLevel;
    }

    @Generated
    public void setChannelLimitEnable(Boolean channelLimitEnable) {
        this.channelLimitEnable = channelLimitEnable;
    }

    @Generated
    public void setFreq(Integer freq) {
        this.freq = freq;
    }

    @Generated
    public void setWirelessMode(Integer wirelessMode) {
        this.wirelessMode = wirelessMode;
    }

    @Generated
    public void setNonPscEnable(Boolean nonPscEnable) {
        this.nonPscEnable = nonPscEnable;
    }

    @Generated
    public void setAutoSwitchOffWifi(Boolean autoSwitchOffWifi) {
        this.autoSwitchOffWifi = autoSwitchOffWifi;
    }

    @Generated
    public void setAutoSwitchOffWifiInterval(Integer autoSwitchOffWifiInterval) {
        this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
    }

    @Generated
    public ApRadioSettingopenApiVO() {
    }

    @Generated
    public ApRadioSettingopenApiVO(Boolean radioEnable, List<Integer> channelRange, String channelWidth, String channel, Integer txPower, Integer txPowerLevel, Boolean channelLimitEnable, Integer freq, Integer wirelessMode, Boolean nonPscEnable, Boolean autoSwitchOffWifi, Integer autoSwitchOffWifiInterval) {
        this.radioEnable = radioEnable;
        this.channelRange = channelRange;
        this.channelWidth = channelWidth;
        this.channel = channel;
        this.txPower = txPower;
        this.txPowerLevel = txPowerLevel;
        this.channelLimitEnable = channelLimitEnable;
        this.freq = freq;
        this.wirelessMode = wirelessMode;
        this.nonPscEnable = nonPscEnable;
        this.autoSwitchOffWifi = autoSwitchOffWifi;
        this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
    }

    @Generated
    public String toString() {
        return "ApRadioSettingopenApiVO(radioEnable=" + this.getRadioEnable() + ", channelRange=" + this.getChannelRange() + ", channelWidth=" + this.getChannelWidth() + ", channel=" + this.getChannel() + ", txPower=" + this.getTxPower() + ", txPowerLevel=" + this.getTxPowerLevel() + ", channelLimitEnable=" + this.getChannelLimitEnable() + ", freq=" + this.getFreq() + ", wirelessMode=" + this.getWirelessMode() + ", nonPscEnable=" + this.getNonPscEnable() + ", autoSwitchOffWifi=" + this.getAutoSwitchOffWifi() + ", autoSwitchOffWifiInterval=" + this.getAutoSwitchOffWifiInterval() + ")";
    }

    @Generated
    public static abstract class ApRadioSettingopenApiVOBuilder<C extends ApRadioSettingopenApiVO, B extends ApRadioSettingopenApiVOBuilder<C, B>> {
        @Generated
        private Boolean radioEnable;
        @Generated
        private List<Integer> channelRange;
        @Generated
        private String channelWidth;
        @Generated
        private String channel;
        @Generated
        private Integer txPower;
        @Generated
        private Integer txPowerLevel;
        @Generated
        private Boolean channelLimitEnable;
        @Generated
        private Integer freq;
        @Generated
        private Integer wirelessMode;
        @Generated
        private Boolean nonPscEnable;
        @Generated
        private Boolean autoSwitchOffWifi;
        @Generated
        private Integer autoSwitchOffWifiInterval;

        @Generated
        public B radioEnable(Boolean radioEnable) {
            this.radioEnable = radioEnable;
            return this.self();
        }

        @Generated
        public B channelRange(List<Integer> channelRange) {
            this.channelRange = channelRange;
            return this.self();
        }

        @Generated
        public B channelWidth(String channelWidth) {
            this.channelWidth = channelWidth;
            return this.self();
        }

        @Generated
        public B channel(String channel) {
            this.channel = channel;
            return this.self();
        }

        @Generated
        public B txPower(Integer txPower) {
            this.txPower = txPower;
            return this.self();
        }

        @Generated
        public B txPowerLevel(Integer txPowerLevel) {
            this.txPowerLevel = txPowerLevel;
            return this.self();
        }

        @Generated
        public B channelLimitEnable(Boolean channelLimitEnable) {
            this.channelLimitEnable = channelLimitEnable;
            return this.self();
        }

        @Generated
        public B freq(Integer freq) {
            this.freq = freq;
            return this.self();
        }

        @Generated
        public B wirelessMode(Integer wirelessMode) {
            this.wirelessMode = wirelessMode;
            return this.self();
        }

        @Generated
        public B nonPscEnable(Boolean nonPscEnable) {
            this.nonPscEnable = nonPscEnable;
            return this.self();
        }

        @Generated
        public B autoSwitchOffWifi(Boolean autoSwitchOffWifi) {
            this.autoSwitchOffWifi = autoSwitchOffWifi;
            return this.self();
        }

        @Generated
        public B autoSwitchOffWifiInterval(Integer autoSwitchOffWifiInterval) {
            this.autoSwitchOffWifiInterval = autoSwitchOffWifiInterval;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ApRadioSettingopenApiVO.ApRadioSettingopenApiVOBuilder(radioEnable=" + this.radioEnable + ", channelRange=" + this.channelRange + ", channelWidth=" + this.channelWidth + ", channel=" + this.channel + ", txPower=" + this.txPower + ", txPowerLevel=" + this.txPowerLevel + ", channelLimitEnable=" + this.channelLimitEnable + ", freq=" + this.freq + ", wirelessMode=" + this.wirelessMode + ", nonPscEnable=" + this.nonPscEnable + ", autoSwitchOffWifi=" + this.autoSwitchOffWifi + ", autoSwitchOffWifiInterval=" + this.autoSwitchOffWifiInterval + ")";
        }
    }

    @Generated
    private static final class ApRadioSettingopenApiVOBuilderImpl
    extends ApRadioSettingopenApiVOBuilder<ApRadioSettingopenApiVO, ApRadioSettingopenApiVOBuilderImpl> {
        @Generated
        private ApRadioSettingopenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected ApRadioSettingopenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ApRadioSettingopenApiVO build() {
            return new ApRadioSettingopenApiVO(this);
        }
    }
}

