/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApMvlanSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class ApMvlanSettingOpenApiVO {
    @NotNull
    @NumberSet(value={0, 1}, message="AP MvlanSetting parameter [mode] should be 0 or 1")
    @Schema(name="mode", description="Mode for the AP management VLAN configuration to take effect.[0:Default,1:Custom]")
    private Integer mode;
    @Schema(name="lanNetworkId", description="This field indicates the currently effective lanNetworkId.")
    private String lanNetworkId;
    @Range(min=1L, max=4094L, message="Parameter [bridgeVlan] should be from 1 to 4094.")
    @Schema(name="bridgeVlan", description="When mvlanNetworkId is bridge vlan, mvlanBridgeVlan has a value.")
    private @Range(min=1L, max=4094L, message="Parameter [bridgeVlan] should be from 1 to 4094.") Integer bridgeVlan;

    public static ApMvlanSettingVO toApMvlanSettingVO(ApMvlanSettingOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        ApMvlanSettingVO apMvlanSettingVO = new ApMvlanSettingVO();
        apMvlanSettingVO.setBridgeVlan(openApiVO.getBridgeVlan());
        apMvlanSettingVO.setMode(openApiVO.getMode());
        apMvlanSettingVO.setLanNetworkId(openApiVO.getLanNetworkId());
        return apMvlanSettingVO;
    }

    public static ApMvlanSettingOpenApiVO fromApMvlanSettingVO(ApMvlanSettingVO webVO) {
        if (webVO == null) {
            return null;
        }
        ApMvlanSettingOpenApiVO openApiVO = new ApMvlanSettingOpenApiVO();
        openApiVO.setBridgeVlan(webVO.getBridgeVlan());
        openApiVO.setMode(webVO.getMode());
        openApiVO.setLanNetworkId(webVO.getLanNetworkId());
        return openApiVO;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getLanNetworkId() {
        return this.lanNetworkId;
    }

    @Generated
    public Integer getBridgeVlan() {
        return this.bridgeVlan;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setLanNetworkId(String lanNetworkId) {
        this.lanNetworkId = lanNetworkId;
    }

    @Generated
    public void setBridgeVlan(Integer bridgeVlan) {
        this.bridgeVlan = bridgeVlan;
    }

    @Generated
    public String toString() {
        return "ApMvlanSettingOpenApiVO(mode=" + this.getMode() + ", lanNetworkId=" + this.getLanNetworkId() + ", bridgeVlan=" + this.getBridgeVlan() + ")";
    }

    @Generated
    public ApMvlanSettingOpenApiVO() {
    }

    @Generated
    public ApMvlanSettingOpenApiVO(Integer mode, String lanNetworkId, Integer bridgeVlan) {
        this.mode = mode;
        this.lanNetworkId = lanNetworkId;
        this.bridgeVlan = bridgeVlan;
    }
}

