/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.ApRssiLedSettingVO;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

@Schema(name="ApGeneralConfig")
public class ApGeneralConfigOpenApiVO {
    @Schema(name="name", description="Device name should contain 1 to 128 characters.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="ledSetting", description="Led setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings.")
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    @Schema(name="remoteReset", description="Whether the remote reset function is enabled.")
    private Boolean remoteReset;
    @Schema(name="wifiControlEnable", description="Whether the wifi Control function is enabled.")
    private Boolean wifiControlEnable;
    @Valid
    @Schema(name="rssiLedSettings", description="Rssi Led Setting.")
    private List<ApRssiLedSettingVO> rssiLedSettings;
    @Schema(name="tagIds", description="Tag IDs.")
    private List<String> tagIds;
    @Schema(name="gpsEnable", description="gps Enable only for ap which support gps function.")
    private Boolean gpsEnable;
    @Schema(name="location", description="Device location.")
    @Valid
    private DeviceLocationDetailVO location;
    @Schema(name="rememberDevice", description="Parameter [rememberDevice] should be a value as follows: 0:off; 1:on; 2:Use Site Settings.")
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    private Integer rememberDevice;
    @Schema(name="disableHwReset", description="When this value is [true], the device's hardware reset is invalid.(Only some specific devices support this feature)")
    private Boolean disableHwReset;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public Boolean getRemoteReset() {
        return this.remoteReset;
    }

    @Generated
    public Boolean getWifiControlEnable() {
        return this.wifiControlEnable;
    }

    @Generated
    public List<ApRssiLedSettingVO> getRssiLedSettings() {
        return this.rssiLedSettings;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Boolean getGpsEnable() {
        return this.gpsEnable;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public Boolean getDisableHwReset() {
        return this.disableHwReset;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setRemoteReset(Boolean remoteReset) {
        this.remoteReset = remoteReset;
    }

    @Generated
    public void setWifiControlEnable(Boolean wifiControlEnable) {
        this.wifiControlEnable = wifiControlEnable;
    }

    @Generated
    public void setRssiLedSettings(List<ApRssiLedSettingVO> rssiLedSettings) {
        this.rssiLedSettings = rssiLedSettings;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setGpsEnable(Boolean gpsEnable) {
        this.gpsEnable = gpsEnable;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public void setDisableHwReset(Boolean disableHwReset) {
        this.disableHwReset = disableHwReset;
    }

    @Generated
    public String toString() {
        return "ApGeneralConfigOpenApiVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", remoteReset=" + this.getRemoteReset() + ", wifiControlEnable=" + this.getWifiControlEnable() + ", rssiLedSettings=" + this.getRssiLedSettings() + ", tagIds=" + this.getTagIds() + ", gpsEnable=" + this.getGpsEnable() + ", location=" + this.getLocation() + ", rememberDevice=" + this.getRememberDevice() + ", disableHwReset=" + this.getDisableHwReset() + ")";
    }
}

