/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi.ap.apsetting;

import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanRadio2gVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanRadio5g2VO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanRadio5gVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanRadio6gVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanRadioVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.RFScanVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="ApRFScanResult")
public class APRFScanOpenApiV2VO {
    @Schema(name="channel2g", description="Channel 2g")
    private List<RFScanRadio2gVO> channel2g;
    @Schema(name="channel5g", description="Channel 5g")
    private List<RFScanRadio5gVO> channel5g;
    @Schema(name="channel5g2", description="Channel 5g2")
    private List<RFScanRadio5g2VO> channel5g2;
    @Schema(name="channel6g", description="Channel 6g")
    private List<RFScanRadio6gVO> channel6g;
    @Schema(name="currentChan2g", description="The 2G channel of AP, such as 1,6,11,13. It should be within the range of 1\u201313.")
    private String currentChan2g;
    @Schema(name="currentChan5g", description="The 5G channel of AP, such as 36,161. It should be within the range of 36\u2013161.")
    private String currentChan5g;
    @Schema(name="currentChan5g2", description="The 5G2 channel of AP,such as 36,161. It should be within the range of 36\u2013161.")
    private String currentChan5g2;
    @Schema(name="currentChan6g", description="The 6G channel of AP,such as 36,161. It should be within the range of 36\u2013161.")
    private String currentChan6g;
    @Schema(name="currentChanW2g", description="The 2g channel bandwidth of the AP. It should be a value as follows: 2:20MHz, 3: 40MHz")
    private Integer currentChanW2g;
    @Schema(name="currentChanW5g", description="The 5g channel bandwidth of the AP. It should be a value as follows: 2:20MHz, 3: 40MHz, 5: 80MHz2 menas 20MHz, 3 means 40MHz, 5 means 80MHz")
    private Integer currentChanW5g;
    @Schema(name="currentChanW5g2", description="The 5g2 channel bandwidth of the AP. It should be a value as follows: 2:20MHz, 3: 40MHz, 5: 80MHz")
    private Integer currentChanW5g2;
    @Schema(name="currentChanW6g", description="The 6g channel bandwidth of the AP. It should be a value as follows: 2:20MHz, 3: 40MHz, 5: 80MHz")
    private Integer currentChanW6g;
    @Schema(name="time", description="The scan time(13 bits), Unit: ms")
    private Long time;
    @Schema(name="time2g", description="The scan time(13 bits) of 2.4GHz band, Unit: ms")
    private Long time2g;
    @Schema(name="time5g", description="The scan time(13 bits) of 5GHz band, Unit: ms")
    private Long time5g;
    @Schema(name="time2g", description="The scan time(13 bits) of 5GHz-2 band, Unit: ms")
    private Long time5g2;
    @Schema(name="time6g", description="The scan time(13 bits) of 6GHz band, Unit: ms")
    private Long time6g;
    @Schema(name="status", description="Status should be a value as follows: 0: the scan result is displayed; 1: no scan result; 2: Scanning")
    private Integer status;
    @Schema(name="status2g", description="Status of 2.4GHz band should be a value as follows: 0: the scan result is displayed; 1: no scan result; 2: Scanning")
    private Integer status2g;
    @Schema(name="status5g", description="Status of 5GHz band should be a value as follows: 0: the scan result is displayed; 1: no scan result; 2: Scanning")
    private Integer status5g;
    @Schema(name="status5g2", description="Status of 5GHz-2 band should be a value as follows: 0: the scan result is displayed; 1: no scan result; 2: Scanning")
    private Integer status5g2;
    @Schema(name="status6g", description="Status of 6GHz band should be a value as follows: 0: the scan result is displayed; 1: no scan result; 2: Scanning")
    private Integer status6g;

    public static APRFScanOpenApiV2VO toOpenApiV2VO(RFScanVO rfScanVO) {
        if (Objects.isNull(rfScanVO)) {
            return null;
        }
        APRFScanOpenApiV2VO aprfScanOpenApiV2VO = new APRFScanOpenApiV2VO();
        aprfScanOpenApiV2VO.setChannel2g(CollectionUtils.isEmpty((Collection)rfScanVO.getChannel2g()) ? null : rfScanVO.getChannel2g().stream().map(RFScanRadioVO::toRadio2gVO).collect(Collectors.toList()));
        aprfScanOpenApiV2VO.setChannel5g(CollectionUtils.isEmpty((Collection)rfScanVO.getChannel5g()) ? null : rfScanVO.getChannel5g().stream().map(RFScanRadioVO::toRadio5gVO).collect(Collectors.toList()));
        aprfScanOpenApiV2VO.setChannel5g2(CollectionUtils.isEmpty((Collection)rfScanVO.getChannel5g2()) ? null : rfScanVO.getChannel5g2().stream().map(RFScanRadioVO::toRadio5g2VO).collect(Collectors.toList()));
        aprfScanOpenApiV2VO.setChannel6g(CollectionUtils.isEmpty((Collection)rfScanVO.getChannel6g()) ? null : rfScanVO.getChannel6g().stream().map(RFScanRadioVO::toRadio6gVO).collect(Collectors.toList()));
        aprfScanOpenApiV2VO.setCurrentChan2g(rfScanVO.getCurrentChan2g());
        aprfScanOpenApiV2VO.setCurrentChan5g(rfScanVO.getCurrentChan5g());
        aprfScanOpenApiV2VO.setCurrentChan5g2(rfScanVO.getCurrentChan5g2());
        aprfScanOpenApiV2VO.setCurrentChan6g(rfScanVO.getCurrentChan6g());
        aprfScanOpenApiV2VO.setCurrentChanW2g(rfScanVO.getCurrentChanW2g());
        aprfScanOpenApiV2VO.setCurrentChanW5g(rfScanVO.getCurrentChanW5g());
        aprfScanOpenApiV2VO.setCurrentChanW5g2(rfScanVO.getCurrentChanW5g2());
        aprfScanOpenApiV2VO.setCurrentChanW6g(rfScanVO.getCurrentChanW6g());
        aprfScanOpenApiV2VO.setTime(rfScanVO.getTime());
        aprfScanOpenApiV2VO.setTime2g(rfScanVO.getTime2g());
        aprfScanOpenApiV2VO.setTime5g(rfScanVO.getTime5g());
        aprfScanOpenApiV2VO.setTime5g2(rfScanVO.getTime5g2());
        aprfScanOpenApiV2VO.setTime6g(rfScanVO.getTime6g());
        aprfScanOpenApiV2VO.setStatus(rfScanVO.getStatus());
        aprfScanOpenApiV2VO.setStatus2g(rfScanVO.getStatus2g());
        aprfScanOpenApiV2VO.setStatus5g(rfScanVO.getStatus5g());
        aprfScanOpenApiV2VO.setStatus5g2(rfScanVO.getStatus5g2());
        aprfScanOpenApiV2VO.setStatus6g(rfScanVO.getStatus6g());
        return aprfScanOpenApiV2VO;
    }

    @Generated
    public List<RFScanRadio2gVO> getChannel2g() {
        return this.channel2g;
    }

    @Generated
    public List<RFScanRadio5gVO> getChannel5g() {
        return this.channel5g;
    }

    @Generated
    public List<RFScanRadio5g2VO> getChannel5g2() {
        return this.channel5g2;
    }

    @Generated
    public List<RFScanRadio6gVO> getChannel6g() {
        return this.channel6g;
    }

    @Generated
    public String getCurrentChan2g() {
        return this.currentChan2g;
    }

    @Generated
    public String getCurrentChan5g() {
        return this.currentChan5g;
    }

    @Generated
    public String getCurrentChan5g2() {
        return this.currentChan5g2;
    }

    @Generated
    public String getCurrentChan6g() {
        return this.currentChan6g;
    }

    @Generated
    public Integer getCurrentChanW2g() {
        return this.currentChanW2g;
    }

    @Generated
    public Integer getCurrentChanW5g() {
        return this.currentChanW5g;
    }

    @Generated
    public Integer getCurrentChanW5g2() {
        return this.currentChanW5g2;
    }

    @Generated
    public Integer getCurrentChanW6g() {
        return this.currentChanW6g;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Long getTime2g() {
        return this.time2g;
    }

    @Generated
    public Long getTime5g() {
        return this.time5g;
    }

    @Generated
    public Long getTime5g2() {
        return this.time5g2;
    }

    @Generated
    public Long getTime6g() {
        return this.time6g;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getStatus2g() {
        return this.status2g;
    }

    @Generated
    public Integer getStatus5g() {
        return this.status5g;
    }

    @Generated
    public Integer getStatus5g2() {
        return this.status5g2;
    }

    @Generated
    public Integer getStatus6g() {
        return this.status6g;
    }

    @Generated
    public void setChannel2g(List<RFScanRadio2gVO> channel2g) {
        this.channel2g = channel2g;
    }

    @Generated
    public void setChannel5g(List<RFScanRadio5gVO> channel5g) {
        this.channel5g = channel5g;
    }

    @Generated
    public void setChannel5g2(List<RFScanRadio5g2VO> channel5g2) {
        this.channel5g2 = channel5g2;
    }

    @Generated
    public void setChannel6g(List<RFScanRadio6gVO> channel6g) {
        this.channel6g = channel6g;
    }

    @Generated
    public void setCurrentChan2g(String currentChan2g) {
        this.currentChan2g = currentChan2g;
    }

    @Generated
    public void setCurrentChan5g(String currentChan5g) {
        this.currentChan5g = currentChan5g;
    }

    @Generated
    public void setCurrentChan5g2(String currentChan5g2) {
        this.currentChan5g2 = currentChan5g2;
    }

    @Generated
    public void setCurrentChan6g(String currentChan6g) {
        this.currentChan6g = currentChan6g;
    }

    @Generated
    public void setCurrentChanW2g(Integer currentChanW2g) {
        this.currentChanW2g = currentChanW2g;
    }

    @Generated
    public void setCurrentChanW5g(Integer currentChanW5g) {
        this.currentChanW5g = currentChanW5g;
    }

    @Generated
    public void setCurrentChanW5g2(Integer currentChanW5g2) {
        this.currentChanW5g2 = currentChanW5g2;
    }

    @Generated
    public void setCurrentChanW6g(Integer currentChanW6g) {
        this.currentChanW6g = currentChanW6g;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setTime2g(Long time2g) {
        this.time2g = time2g;
    }

    @Generated
    public void setTime5g(Long time5g) {
        this.time5g = time5g;
    }

    @Generated
    public void setTime5g2(Long time5g2) {
        this.time5g2 = time5g2;
    }

    @Generated
    public void setTime6g(Long time6g) {
        this.time6g = time6g;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setStatus2g(Integer status2g) {
        this.status2g = status2g;
    }

    @Generated
    public void setStatus5g(Integer status5g) {
        this.status5g = status5g;
    }

    @Generated
    public void setStatus5g2(Integer status5g2) {
        this.status5g2 = status5g2;
    }

    @Generated
    public void setStatus6g(Integer status6g) {
        this.status6g = status6g;
    }

    @Generated
    public String toString() {
        return "APRFScanOpenApiV2VO(channel2g=" + this.getChannel2g() + ", channel5g=" + this.getChannel5g() + ", channel5g2=" + this.getChannel5g2() + ", channel6g=" + this.getChannel6g() + ", currentChan2g=" + this.getCurrentChan2g() + ", currentChan5g=" + this.getCurrentChan5g() + ", currentChan5g2=" + this.getCurrentChan5g2() + ", currentChan6g=" + this.getCurrentChan6g() + ", currentChanW2g=" + this.getCurrentChanW2g() + ", currentChanW5g=" + this.getCurrentChanW5g() + ", currentChanW5g2=" + this.getCurrentChanW5g2() + ", currentChanW6g=" + this.getCurrentChanW6g() + ", time=" + this.getTime() + ", time2g=" + this.getTime2g() + ", time5g=" + this.getTime5g() + ", time5g2=" + this.getTime5g2() + ", time6g=" + this.getTime6g() + ", status=" + this.getStatus() + ", status2g=" + this.getStatus2g() + ", status5g=" + this.getStatus5g() + ", status5g2=" + this.getStatus5g2() + ", status6g=" + this.getStatus6g() + ")";
    }
}

