/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.validator.constraints.Range;

public class OpenApiQueryDeviceDataVO {
    @NotNull(message="page should not be null.")
    @Range(min=1L, message="page should not be less than 1.")
    private @NotNull(message="page should not be null.") @Range(min=1L, message="page should not be less than 1.") Integer page;
    @NotNull(message="pageSize should not be null.")
    @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.")
    private @NotNull(message="pageSize should not be null.") @Range(min=1L, max=1000L, message="pageSize should between 1 and 1000.") Integer pageSize;
    private LinkedHashMap<String, String> sorts;
    @a
    private String searchMacs;
    private String searchNames;
    private String searchModels;
    private String searchSns;
    @a(e=true)
    private Map<String, Object> filters;
    @Nullable
    private String searchField;

    public static QueryDataVO buildByOpenApiVO(OpenApiQueryDeviceDataVO openApiQueryDataVO) {
        QueryDataVO queryDataVO = new QueryDataVO();
        if (openApiQueryDataVO == null) {
            return queryDataVO;
        }
        queryDataVO.setCurrentPage(openApiQueryDataVO.getPage().intValue());
        queryDataVO.setCurrentPageSize(openApiQueryDataVO.getPageSize().intValue());
        queryDataVO.setFilters(openApiQueryDataVO.getFilters());
        queryDataVO.setSorts(openApiQueryDataVO.getSorts());
        queryDataVO.setSearchField(openApiQueryDataVO.getSearchField());
        HashMap<String, String> multiSearchMap = new HashMap<String, String>(4);
        if (!T.a((String)openApiQueryDataVO.getSearchMacs())) {
            multiSearchMap.put("mac", openApiQueryDataVO.getSearchMacs());
        }
        if (!T.a((String)openApiQueryDataVO.getSearchModels())) {
            multiSearchMap.put("model", openApiQueryDataVO.getSearchModels());
        }
        if (!T.a((String)openApiQueryDataVO.getSearchNames())) {
            multiSearchMap.put("name", openApiQueryDataVO.getSearchNames());
        }
        if (!T.a((String)openApiQueryDataVO.getSearchSns())) {
            multiSearchMap.put("sn", openApiQueryDataVO.getSearchSns());
        }
        queryDataVO.setMultiSearchMap(multiSearchMap);
        return queryDataVO;
    }

    public boolean noNeedPagingQuery() {
        return this.page == 0 && this.pageSize == 0;
    }

    @Nullable
    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(@Nullable String searchField) {
        this.searchField = searchField;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public LinkedHashMap<String, String> getSorts() {
        return this.sorts;
    }

    public void setSorts(LinkedHashMap<String, String> sorts) {
        this.sorts = sorts;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Map<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSearchMacs() {
        return this.searchMacs;
    }

    public void setSearchMacs(String searchMacs) {
        this.searchMacs = searchMacs;
    }

    public String getSearchNames() {
        return this.searchNames;
    }

    public void setSearchNames(String searchNames) {
        this.searchNames = searchNames;
    }

    public String getSearchModels() {
        return this.searchModels;
    }

    public void setSearchModels(String searchModels) {
        this.searchModels = searchModels;
    }

    public String getSearchSns() {
        return this.searchSns;
    }

    public void setSearchSns(String searchSns) {
        this.searchSns = searchSns;
    }
}

