/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.SwitchTypeEnum;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

public class GlobalKnownDeviceOpenApiVO {
    @Schema(name="mac", description="Device MAC")
    @a
    private String mac;
    @Schema(name="name", description="Device name")
    private String name;
    @Schema(name="type", description="Device type")
    private String type;
    @Schema(name="subtype", description="Switch subtype should be a value as follows: smart: Non-Agile Series Switch; es: Agile Series Switch.")
    private String subtype;
    @Schema(name="deviceSeriesType", description="Device series type. 0 means basic, 1 means pro.")
    private Integer deviceSeriesType;
    @Schema(name="model", description="Device model name")
    private String model;
    @Schema(name="ip", description="Device IP")
    private String ip;
    @Schema(name="ipv6", description="Device IPv6 list")
    private List<String> ipv6List;
    @Schema(name="uptime", description="Device uptime")
    private String uptime;
    @Schema(name="status", description="Device status should be a value as follows: 0: Disconnected; 1: Connected; 2: Pending; 3: Heartbeat Missed; 4: Isolated")
    private Integer status;
    @Schema(name="lastSeen", description="Device lastSeen")
    private Long lastSeen;
    @Schema(name="cpuUtil", description="Device cpuUtil")
    private Integer cpuUtil;
    @Schema(name="memUtil", description="Device memUtil")
    private Integer memUtil;
    @Schema(name="sn", description="Device serial number")
    private String sn;
    @Schema(name="licenseStatus", description="Device license status(Only for cloud base) should be a value as follows: 0: unActive; 1: Unbind; 2: Expired; 3: active")
    private Integer licenseStatus;
    @Schema(name="needActive", description="Device license status(Only for cloud base).If the value is true, the device is ready to be activated;If the value is false, the device cannot be activated or has already been activated.")
    private Boolean needActive;
    @Schema(name="siteName", description="The name of the site where the device is located")
    private String siteName;
    @Schema(name="tagName", description="Device tag name")
    private String tagName;

    public static GlobalKnownDeviceOpenApiVO buildByDeviceVO(DeviceVO deviceVO) {
        if (deviceVO == null) {
            return new GlobalKnownDeviceOpenApiVO();
        }
        GlobalKnownDeviceOpenApiVO vo = new GlobalKnownDeviceOpenApiVO();
        vo.setMac(deviceVO.getMac());
        vo.setName(deviceVO.getName());
        vo.setType(deviceVO.getType());
        vo.setModel(deviceVO.getShowModel());
        vo.setIp(deviceVO.getIp());
        vo.setIpv6List(deviceVO.getIpv6List());
        vo.setUptime(deviceVO.getUptime());
        vo.setStatus(deviceVO.getStatusCategory());
        vo.setLastSeen(deviceVO.getLastSeen());
        vo.setCpuUtil(deviceVO.getCpuUtil());
        vo.setMemUtil(deviceVO.getMemUtil());
        vo.setSn(deviceVO.getSn());
        vo.setLicenseStatus(deviceVO.getLicenseStatus());
        vo.setNeedActive(Boolean.FALSE.equals(deviceVO.getActive()));
        vo.setSiteName(deviceVO.getSiteName());
        vo.setTagName(deviceVO.getTagName());
        vo.setDeviceSeriesType(deviceVO.getDeviceSeriesType());
        if (DeviceTypeEnum.c.c(deviceVO.getType())) {
            if (deviceVO.getEs() == null || Boolean.FALSE.equals(deviceVO.getEs())) {
                vo.setSubtype(SwitchTypeEnum.a.a());
            } else {
                vo.setSubtype(SwitchTypeEnum.b.a());
            }
        }
        return vo;
    }

    @Generated
    public GlobalKnownDeviceOpenApiVO() {
    }

    @Generated
    public GlobalKnownDeviceOpenApiVO(String mac, String name, String type, String subtype, Integer deviceSeriesType, String model, String ip, List<String> ipv6List, String uptime, Integer status, Long lastSeen, Integer cpuUtil, Integer memUtil, String sn, Integer licenseStatus, Boolean needActive, String siteName, String tagName) {
        this.mac = mac;
        this.name = name;
        this.type = type;
        this.subtype = subtype;
        this.deviceSeriesType = deviceSeriesType;
        this.model = model;
        this.ip = ip;
        this.ipv6List = ipv6List;
        this.uptime = uptime;
        this.status = status;
        this.lastSeen = lastSeen;
        this.cpuUtil = cpuUtil;
        this.memUtil = memUtil;
        this.sn = sn;
        this.licenseStatus = licenseStatus;
        this.needActive = needActive;
        this.siteName = siteName;
        this.tagName = tagName;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSubtype() {
        return this.subtype;
    }

    @Generated
    public Integer getDeviceSeriesType() {
        return this.deviceSeriesType;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<String> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Long getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public Integer getCpuUtil() {
        return this.cpuUtil;
    }

    @Generated
    public Integer getMemUtil() {
        return this.memUtil;
    }

    @Generated
    public String getSn() {
        return this.sn;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public Boolean getNeedActive() {
        return this.needActive;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public String getTagName() {
        return this.tagName;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    @Generated
    public void setDeviceSeriesType(Integer deviceSeriesType) {
        this.deviceSeriesType = deviceSeriesType;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpv6List(List<String> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Generated
    public void setCpuUtil(Integer cpuUtil) {
        this.cpuUtil = cpuUtil;
    }

    @Generated
    public void setMemUtil(Integer memUtil) {
        this.memUtil = memUtil;
    }

    @Generated
    public void setSn(String sn) {
        this.sn = sn;
    }

    @Generated
    public void setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    @Generated
    public void setNeedActive(Boolean needActive) {
        this.needActive = needActive;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Generated
    public String toString() {
        return "GlobalKnownDeviceOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", type=" + this.getType() + ", subtype=" + this.getSubtype() + ", deviceSeriesType=" + this.getDeviceSeriesType() + ", model=" + this.getModel() + ", ip=" + this.getIp() + ", ipv6List=" + this.getIpv6List() + ", uptime=" + this.getUptime() + ", status=" + this.getStatus() + ", lastSeen=" + this.getLastSeen() + ", cpuUtil=" + this.getCpuUtil() + ", memUtil=" + this.getMemUtil() + ", sn=" + this.getSn() + ", licenseStatus=" + this.getLicenseStatus() + ", needActive=" + this.getNeedActive() + ", siteName=" + this.getSiteName() + ", tagName=" + this.getTagName() + ")";
    }
}

