/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.api.openapi;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.SwitchTypeEnum;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@Schema(name="DeviceInfo")
public class DeviceOpenApiVO {
    @Schema(name="mac", description="Device MAC")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @a
    private String mac;
    @Schema(name="name", description="Device name")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String name;
    @Schema(name="type", description="Device type")
    private String type;
    @Schema(name="subtype", description="Switch subtype should be a value as follows: smart: Non-Agile Series Switch; es: Agile Series Switch.")
    private String subtype;
    @Schema(name="deviceSeriesType", description="Device series type. 0 means basic, 1 means pro.")
    private Integer deviceSeriesType;
    @Schema(name="model", description="Device model name with version")
    private String model;
    @Schema(name="modelName", description="Device model name")
    private String modelName;
    @Schema(name="ip", description="Device IP")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @Schema(name="ipv6", description="Device IPv6 list")
    @PII(strategy=PIIMaskStrategy.HASH)
    private List<String> ipv6List;
    @Schema(name="uptime", description="Device uptime")
    private String uptime;
    @Schema(name="status", description="Device status should be a value as follows: 0: Disconnected; 1: Connected; 2: Pending; 3: Heartbeat Missed; 4: Isolated")
    private Integer status;
    @Schema(name="detailStatus", description="Status of device,status should be a value as follows: 0:Disconnected;1:Disconnected(Migrating);10:Provisioning;11:Configuring;12:Upgrading;13:Rebooting;14:Connected;15:Connected(Wireless);16:Connected(Migrating);17:Connected(Wireless,Migrating);20:Pending;21:Pending(Wireless);22:Adopting;23:Adopting(Wireless);24:Adopt Failed;25:Adopt Failed(Wireless);26:Managed By Others;27:Managed By Others(Wireless);30:Heartbeat Missed;31:Heartbeat Missed(Wireless);32:Heartbeat Missed(Migrating);33:Heartbeat Missed(Wireless,Migrating);40:Isolated;41:Isolated(Migrating);50:Slice Configuring")
    private Integer detailStatus;
    @Schema(name="modelVersion", description="Model version of device,for example:3.0")
    private String modelVersion;
    @Schema(name="lastSeen", description="Device lastSeen")
    private Long lastSeen;
    @Schema(name="cpuUtil", description="Device cpuUtil")
    private Integer cpuUtil;
    @Schema(name="memUtil", description="Device memUtil")
    private Integer memUtil;
    @Schema(name="sn", description="Device serial number")
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    private String sn;
    @Schema(name="licenseStatus", description="Device license status (Only for cloud base) should be a value as follows: 0: unActive; 1: Unbind; 2: Expired; 3: active")
    private Integer licenseStatus;
    @Schema(name="tagName", description="Device tag name")
    private String tagName;
    @Schema(name="uplinkDeviceMac", description="Uplink device mac")
    @a
    private String uplinkDeviceMac;
    @Schema(name="uplinkDeviceName", description="Uplink device name")
    private String uplinkDeviceName;
    @Schema(name="uplinkDevicePort", description="Uplink device port")
    private String uplinkDevicePort;
    @Schema(name="linkSpeed", description="Device uplink port linkSpeed, linkSpeed should be a value as follows: 0: Auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2500M; 5: 10G; 6: 5G; 7: 25G, 8: 100G.")
    private Integer linkSpeed;
    @Schema(name="duplex", description="Device uplink port duplex mode, duplex should be a value as follows: 0: Auto; 1: Half; 2: Full.")
    private Integer duplex;
    @Schema(name="switchConsistent", description="Whether the device can be adopted by the site.")
    private Boolean switchConsistent;
    @Schema(name="publicIp", description="Device public IP")
    private String publicIp;
    @Schema(name="firmwareVersion", description="The device firmware version.")
    private String firmwareVersion;
    @Schema(name="compatible", description="The compatible type of device.")
    private Integer compatible;
    @Schema(name="active", description="Indicates whether the device is activated.")
    private Boolean active;
    @Schema(name="inWhiteList", description="Whether the device is in white list.")
    private Boolean inWhiteList;

    public static DeviceOpenApiVO buildByDeviceVO(DeviceVO deviceVO) {
        if (deviceVO == null) {
            return new DeviceOpenApiVO();
        }
        DeviceOpenApiVO vo = new DeviceOpenApiVO();
        vo.setMac(deviceVO.getMac());
        vo.setName(deviceVO.getName());
        vo.setType(deviceVO.getType());
        vo.setModel(deviceVO.getShowModel());
        vo.setModelName(deviceVO.getModel());
        vo.setIp(deviceVO.getIp());
        vo.setUptime(deviceVO.getUptime());
        vo.setStatus(deviceVO.getStatusCategory());
        vo.setDetailStatus(deviceVO.getStatus());
        vo.setModelVersion(deviceVO.getModelVersion());
        vo.setLastSeen(deviceVO.getLastSeen());
        vo.setCpuUtil(deviceVO.getCpuUtil());
        vo.setMemUtil(deviceVO.getMemUtil());
        vo.setSn(deviceVO.getSn());
        vo.setLicenseStatus(deviceVO.getLicenseStatus());
        vo.setTagName(deviceVO.getTagName());
        vo.setDeviceSeriesType(deviceVO.getDeviceSeriesType());
        vo.setUplinkDeviceMac(deviceVO.getUplinkDeviceMac());
        vo.setUplinkDeviceName(deviceVO.getUplinkDeviceName());
        vo.setUplinkDevicePort(deviceVO.getUplinkDevicePort());
        vo.setLinkSpeed(deviceVO.getLinkSpeed());
        vo.setDuplex(deviceVO.getDuplex());
        vo.setSwitchConsistent(deviceVO.getSwitchConsistent());
        vo.setPublicIp(deviceVO.getPublicIp());
        vo.setFirmwareVersion(deviceVO.getFirmwareVersion());
        vo.setCompatible(deviceVO.getCompatible());
        vo.setActive(deviceVO.getActive());
        vo.setInWhiteList(deviceVO.getInWhitelist());
        if (DeviceTypeEnum.c.c(deviceVO.getType())) {
            if (deviceVO.getEs() == null || Boolean.FALSE.equals(deviceVO.getEs())) {
                vo.setSubtype(SwitchTypeEnum.a.a());
            } else {
                vo.setSubtype(SwitchTypeEnum.b.a());
            }
        }
        return vo;
    }

    @Generated
    public DeviceOpenApiVO() {
    }

    @Generated
    public DeviceOpenApiVO(String mac, String name, String type, String subtype, Integer deviceSeriesType, String model, String modelName, String ip, List<String> ipv6List, String uptime, Integer status, Integer detailStatus, String modelVersion, Long lastSeen, Integer cpuUtil, Integer memUtil, String sn, Integer licenseStatus, String tagName, String uplinkDeviceMac, String uplinkDeviceName, String uplinkDevicePort, Integer linkSpeed, Integer duplex, Boolean switchConsistent, String publicIp, String firmwareVersion, Integer compatible, Boolean active, Boolean inWhiteList) {
        this.mac = mac;
        this.name = name;
        this.type = type;
        this.subtype = subtype;
        this.deviceSeriesType = deviceSeriesType;
        this.model = model;
        this.modelName = modelName;
        this.ip = ip;
        this.ipv6List = ipv6List;
        this.uptime = uptime;
        this.status = status;
        this.detailStatus = detailStatus;
        this.modelVersion = modelVersion;
        this.lastSeen = lastSeen;
        this.cpuUtil = cpuUtil;
        this.memUtil = memUtil;
        this.sn = sn;
        this.licenseStatus = licenseStatus;
        this.tagName = tagName;
        this.uplinkDeviceMac = uplinkDeviceMac;
        this.uplinkDeviceName = uplinkDeviceName;
        this.uplinkDevicePort = uplinkDevicePort;
        this.linkSpeed = linkSpeed;
        this.duplex = duplex;
        this.switchConsistent = switchConsistent;
        this.publicIp = publicIp;
        this.firmwareVersion = firmwareVersion;
        this.compatible = compatible;
        this.active = active;
        this.inWhiteList = inWhiteList;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSubtype() {
        return this.subtype;
    }

    @Generated
    public Integer getDeviceSeriesType() {
        return this.deviceSeriesType;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public List<String> getIpv6List() {
        return this.ipv6List;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getDetailStatus() {
        return this.detailStatus;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public Long getLastSeen() {
        return this.lastSeen;
    }

    @Generated
    public Integer getCpuUtil() {
        return this.cpuUtil;
    }

    @Generated
    public Integer getMemUtil() {
        return this.memUtil;
    }

    @Generated
    public String getSn() {
        return this.sn;
    }

    @Generated
    public Integer getLicenseStatus() {
        return this.licenseStatus;
    }

    @Generated
    public String getTagName() {
        return this.tagName;
    }

    @Generated
    public String getUplinkDeviceMac() {
        return this.uplinkDeviceMac;
    }

    @Generated
    public String getUplinkDeviceName() {
        return this.uplinkDeviceName;
    }

    @Generated
    public String getUplinkDevicePort() {
        return this.uplinkDevicePort;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Boolean getSwitchConsistent() {
        return this.switchConsistent;
    }

    @Generated
    public String getPublicIp() {
        return this.publicIp;
    }

    @Generated
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Generated
    public Integer getCompatible() {
        return this.compatible;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Boolean getInWhiteList() {
        return this.inWhiteList;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    @Generated
    public void setDeviceSeriesType(Integer deviceSeriesType) {
        this.deviceSeriesType = deviceSeriesType;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpv6List(List<String> ipv6List) {
        this.ipv6List = ipv6List;
    }

    @Generated
    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setDetailStatus(Integer detailStatus) {
        this.detailStatus = detailStatus;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    @Generated
    public void setCpuUtil(Integer cpuUtil) {
        this.cpuUtil = cpuUtil;
    }

    @Generated
    public void setMemUtil(Integer memUtil) {
        this.memUtil = memUtil;
    }

    @Generated
    public void setSn(String sn) {
        this.sn = sn;
    }

    @Generated
    public void setLicenseStatus(Integer licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    @Generated
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    @Generated
    public void setUplinkDeviceMac(String uplinkDeviceMac) {
        this.uplinkDeviceMac = uplinkDeviceMac;
    }

    @Generated
    public void setUplinkDeviceName(String uplinkDeviceName) {
        this.uplinkDeviceName = uplinkDeviceName;
    }

    @Generated
    public void setUplinkDevicePort(String uplinkDevicePort) {
        this.uplinkDevicePort = uplinkDevicePort;
    }

    @Generated
    public void setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setSwitchConsistent(Boolean switchConsistent) {
        this.switchConsistent = switchConsistent;
    }

    @Generated
    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    @Generated
    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Generated
    public void setCompatible(Integer compatible) {
        this.compatible = compatible;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setInWhiteList(Boolean inWhiteList) {
        this.inWhiteList = inWhiteList;
    }

    @Generated
    public String toString() {
        return "DeviceOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", type=" + this.getType() + ", subtype=" + this.getSubtype() + ", deviceSeriesType=" + this.getDeviceSeriesType() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", ip=" + this.getIp() + ", ipv6List=" + this.getIpv6List() + ", uptime=" + this.getUptime() + ", status=" + this.getStatus() + ", detailStatus=" + this.getDetailStatus() + ", modelVersion=" + this.getModelVersion() + ", lastSeen=" + this.getLastSeen() + ", cpuUtil=" + this.getCpuUtil() + ", memUtil=" + this.getMemUtil() + ", sn=" + this.getSn() + ", licenseStatus=" + this.getLicenseStatus() + ", tagName=" + this.getTagName() + ", uplinkDeviceMac=" + this.getUplinkDeviceMac() + ", uplinkDeviceName=" + this.getUplinkDeviceName() + ", uplinkDevicePort=" + this.getUplinkDevicePort() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", switchConsistent=" + this.getSwitchConsistent() + ", publicIp=" + this.getPublicIp() + ", firmwareVersion=" + this.getFirmwareVersion() + ", compatible=" + this.getCompatible() + ", active=" + this.getActive() + ", inWhiteList=" + this.getInWhiteList() + ")";
    }
}

