/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@Schema(name="PortInfo")
public class PortInfoVO {
    @Schema(name="port", description="Port ID")
    @NotNull(message="Parameter [port] should not be null")
    private @NotNull(message="Parameter [port] should not be null") Integer port;
    @Schema(name="name", description="Port name")
    @NotNull(message="Parameter name should not be null")
    @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @NotNull(message="Parameter name should not be null") @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="profileId", description="Profile ID")
    @NotNull(message="Parameter [profileId] should not be null")
    private @NotNull(message="Parameter [profileId] should not be null") String profileId;
    @Schema(name="profileName", description="Profile Name")
    @NotNull(message="Parameter [profileName] should not be null")
    private @NotNull(message="Parameter [profileName] should not be null") String profileName;
    @Schema(name="profileOverrideEnable", description="Profile Override Enable")
    @NotNull(message="Parameter [profileOverrideEnable] should not be null")
    private @NotNull(message="Parameter [profileOverrideEnable] should not be null") Boolean profileOverrideEnable;
    @Schema(name="poeMode", description="PoE mode should be a value as follows: 1: on(802.3at/af); 0: off.")
    @NotNull(message="Parameter poeMode should not be null")
    @NumberSet(value={0, 1}, message="PortSetting parameter [poeMode] should be 0 or 1")
    private @NotNull(message="Parameter poeMode should not be null") Integer poeMode;
    @Schema(name="lagPort", description="Whether this port exists in a LAG")
    @NotNull(message="Parameter [lagPort] should not be null")
    private @NotNull(message="Parameter [lagPort] should not be null") Boolean lagPort;
    @Schema(name="status", description="Status should be a value as follows: 0: off; 1: on, only when lagPort is false")
    @NotNull(message="Parameter status should not be null")
    @NumberSet(value={0, 1}, message="PortSetting parameter [status] should be 0 or 1")
    private @NotNull(message="Parameter status should not be null") Integer status;

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProfileId() {
        return this.profileId;
    }

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public Boolean getProfileOverrideEnable() {
        return this.profileOverrideEnable;
    }

    @Generated
    public Integer getPoeMode() {
        return this.poeMode;
    }

    @Generated
    public Boolean getLagPort() {
        return this.lagPort;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    @Generated
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Generated
    public void setProfileOverrideEnable(Boolean profileOverrideEnable) {
        this.profileOverrideEnable = profileOverrideEnable;
    }

    @Generated
    public void setPoeMode(Integer poeMode) {
        this.poeMode = poeMode;
    }

    @Generated
    public void setLagPort(Boolean lagPort) {
        this.lagPort = lagPort;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public String toString() {
        return "PortInfoVO(port=" + this.getPort() + ", name=" + this.getName() + ", profileId=" + this.getProfileId() + ", profileName=" + this.getProfileName() + ", profileOverrideEnable=" + this.getProfileOverrideEnable() + ", poeMode=" + this.getPoeMode() + ", lagPort=" + this.getLagPort() + ", status=" + this.getStatus() + ")";
    }
}

