/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswVrfVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class OswVrfOpenApiVO {
    @Schema(name="id", description="VRF ID")
    private String id;
    @NotNull
    @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.")
    @Schema(name="vrf", description="VRF Name")
    private @NotNull @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.") String vrf;
    @NotNull
    @Schema(name="ipv4Enable", description="Indicates whether ipv4 is enabled")
    private Boolean ipv4Enable;
    @NotNull
    @Schema(name="ipv6Enable", description="Indicates whether ipv6 is enabled")
    private Boolean ipv6Enable;
    @Schema(name="isDefault", description="Indicates whether vrf is default vrf")
    private Boolean isDefault;
    @Schema(name="resource", description="Resource")
    private Integer resource;

    public static OswVrfOpenApiVO buildByWebVO(OswVrfVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OswVrfOpenApiVO vrfOpenApiVO = new OswVrfOpenApiVO();
        vrfOpenApiVO.setId(webVO.getId());
        vrfOpenApiVO.setVrf(webVO.getVrf());
        vrfOpenApiVO.setIpv4Enable(webVO.getIpv4Enable());
        vrfOpenApiVO.setIpv6Enable(webVO.getIpv6Enable());
        vrfOpenApiVO.setIsDefault(webVO.getIsDefault());
        vrfOpenApiVO.setResource(webVO.getResource());
        return vrfOpenApiVO;
    }

    public static OswVrfVO toWebVO(OswVrfOpenApiVO vrfOpenApiVO) {
        if (Objects.isNull(vrfOpenApiVO)) {
            return null;
        }
        OswVrfVO vrfVO = new OswVrfVO();
        vrfVO.setId(vrfOpenApiVO.getId());
        vrfVO.setVrf(vrfOpenApiVO.getVrf());
        vrfVO.setIpv4Enable(vrfOpenApiVO.getIpv4Enable());
        vrfVO.setIpv6Enable(vrfOpenApiVO.getIpv6Enable());
        vrfVO.setIsDefault(vrfOpenApiVO.getIsDefault());
        vrfVO.setResource(vrfOpenApiVO.getResource());
        return vrfVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getVrf() {
        return this.vrf;
    }

    @Generated
    public Boolean getIpv4Enable() {
        return this.ipv4Enable;
    }

    @Generated
    public Boolean getIpv6Enable() {
        return this.ipv6Enable;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Integer getResource() {
        return this.resource;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setVrf(String vrf) {
        this.vrf = vrf;
    }

    @Generated
    public void setIpv4Enable(Boolean ipv4Enable) {
        this.ipv4Enable = ipv4Enable;
    }

    @Generated
    public void setIpv6Enable(Boolean ipv6Enable) {
        this.ipv6Enable = ipv6Enable;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setResource(Integer resource) {
        this.resource = resource;
    }

    @Generated
    public String toString() {
        return "OswVrfOpenApiVO(id=" + this.getId() + ", vrf=" + this.getVrf() + ", ipv4Enable=" + this.getIpv4Enable() + ", ipv6Enable=" + this.getIpv6Enable() + ", isDefault=" + this.getIsDefault() + ", resource=" + this.getResource() + ")";
    }

    @Generated
    public OswVrfOpenApiVO() {
    }

    @Generated
    public OswVrfOpenApiVO(String id, String vrf, Boolean ipv4Enable, Boolean ipv6Enable, Boolean isDefault, Integer resource) {
        this.id = id;
        this.vrf = vrf;
        this.ipv4Enable = ipv4Enable;
        this.ipv6Enable = ipv6Enable;
        this.isDefault = isDefault;
        this.resource = resource;
    }
}

