/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswVrfVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class OswVrfConfigOpenApiVO {
    @NotNull
    @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.")
    @Schema(name="vrf", description="VRF Name")
    private @NotNull @Pattern(regexp="^(?!(\\.|\\.\\.)$)[a-zA-Z0-9.\\-_@+]{1,15}$", message="Parameter [vrf] is invalid.") String vrf;
    @NotNull
    @Schema(name="ipv4Enable", description="Indicates whether ipv4 is enabled")
    private Boolean ipv4Enable;
    @NotNull
    @Schema(name="ipv6Enable", description="Indicates whether ipv6 is enabled")
    private Boolean ipv6Enable;

    public static OswVrfConfigOpenApiVO buildByWebVO(OswVrfVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OswVrfConfigOpenApiVO vrfConfigOpenApiVO = new OswVrfConfigOpenApiVO();
        vrfConfigOpenApiVO.setVrf(webVO.getVrf());
        vrfConfigOpenApiVO.setIpv4Enable(webVO.getIpv4Enable());
        vrfConfigOpenApiVO.setIpv6Enable(webVO.getIpv6Enable());
        return vrfConfigOpenApiVO;
    }

    public static OswVrfVO toWebVO(OswVrfConfigOpenApiVO vrfConfigOpenApiVO) {
        if (Objects.isNull(vrfConfigOpenApiVO)) {
            return null;
        }
        OswVrfVO vrfVO = new OswVrfVO();
        vrfVO.setVrf(vrfConfigOpenApiVO.getVrf());
        vrfVO.setIpv4Enable(vrfConfigOpenApiVO.getIpv4Enable());
        vrfVO.setIpv6Enable(vrfConfigOpenApiVO.getIpv6Enable());
        return vrfVO;
    }

    @Generated
    public String getVrf() {
        return this.vrf;
    }

    @Generated
    public Boolean getIpv4Enable() {
        return this.ipv4Enable;
    }

    @Generated
    public Boolean getIpv6Enable() {
        return this.ipv6Enable;
    }

    @Generated
    public void setVrf(String vrf) {
        this.vrf = vrf;
    }

    @Generated
    public void setIpv4Enable(Boolean ipv4Enable) {
        this.ipv4Enable = ipv4Enable;
    }

    @Generated
    public void setIpv6Enable(Boolean ipv6Enable) {
        this.ipv6Enable = ipv6Enable;
    }

    @Generated
    public String toString() {
        return "OswVrfConfigOpenApiVO(vrf=" + this.getVrf() + ", ipv4Enable=" + this.getIpv4Enable() + ", ipv6Enable=" + this.getIpv6Enable() + ")";
    }

    @Generated
    public OswVrfConfigOpenApiVO() {
    }

    @Generated
    public OswVrfConfigOpenApiVO(String vrf, Boolean ipv4Enable, Boolean ipv6Enable) {
        this.vrf = vrf;
        this.ipv4Enable = ipv4Enable;
        this.ipv6Enable = ipv6Enable;
    }
}

