/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStormCtrlVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswStormCtrlOpenApiVO")
public class OswStormCtrlOpenApiVO {
    @NotNull(message="StormCtrl parameter [unknownUnicastEnable] should not be null")
    @Schema(name="unknownUnicastEnable", description="Unknown-Unicast enable status")
    private @NotNull(message="StormCtrl parameter [unknownUnicastEnable] should not be null") Boolean unknownUnicastEnable;
    @Schema(name="unknownUnicast", description="Unknown-Unicast")
    private Integer unknownUnicast;
    @NotNull(message="StormCtrl parameter [multicastEnable] should not be null")
    @Schema(name="multicastEnable", description="Multicast enable status")
    private @NotNull(message="StormCtrl parameter [multicastEnable] should not be null") Boolean multicastEnable;
    @Schema(name="multicast", description="Multicast")
    private Integer multicast;
    @NotNull(message="StormCtrl parameter [broadcastEnable] should not be null")
    @Schema(name="broadcastEnable", description="Broadcast enable status")
    private @NotNull(message="StormCtrl parameter [broadcastEnable] should not be null") Boolean broadcastEnable;
    @Schema(name="broadcast", description="Broadcast")
    private Integer broadcast;
    @NotNull(message="StormCtrl parameter [action] should not be null")
    @NumberSet(value={0, 1}, message="StormCtrl parameter [action] should be 0 or 1")
    @Schema(name="action", description="Action should be a value as follows: 0: drop(default), 1: shutdown")
    private @NotNull(message="StormCtrl parameter [action] should not be null") Integer action;
    @Range(min=1L, max=3600L, message="StormCtrl parameter [recoverTime] should between 1 and 3600s")
    @Schema(name="recoverTime", description="Recover Time should be within the range of 1-3600, default 3600")
    private @Range(min=1L, max=3600L, message="StormCtrl parameter [recoverTime] should between 1 and 3600s") Integer recoverTime;

    public static OswStormCtrlVO toOswStormCtrlVO(OswStormCtrlOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        OswStormCtrlVO oswStormCtrlVO = new OswStormCtrlVO();
        oswStormCtrlVO.setRateMode(Integer.valueOf(1));
        oswStormCtrlVO.setUnknownUnicastEnable(openApiVO.getUnknownUnicastEnable());
        oswStormCtrlVO.setUnknownUnicast(openApiVO.getUnknownUnicast());
        oswStormCtrlVO.setMulticastEnable(openApiVO.getMulticastEnable());
        oswStormCtrlVO.setMulticast(openApiVO.getMulticast());
        oswStormCtrlVO.setBroadcastEnable(openApiVO.getBroadcastEnable());
        oswStormCtrlVO.setBroadcast(openApiVO.getBroadcast());
        oswStormCtrlVO.setAction(openApiVO.getAction());
        oswStormCtrlVO.setRecoverTime(openApiVO.getRecoverTime());
        return oswStormCtrlVO;
    }

    @Generated
    protected OswStormCtrlOpenApiVO(OswStormCtrlOpenApiVOBuilder<?, ?> b2) {
        this.unknownUnicastEnable = b2.unknownUnicastEnable;
        this.unknownUnicast = b2.unknownUnicast;
        this.multicastEnable = b2.multicastEnable;
        this.multicast = b2.multicast;
        this.broadcastEnable = b2.broadcastEnable;
        this.broadcast = b2.broadcast;
        this.action = b2.action;
        this.recoverTime = b2.recoverTime;
    }

    @Generated
    public static OswStormCtrlOpenApiVOBuilder<?, ?> builder() {
        return new OswStormCtrlOpenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getUnknownUnicastEnable() {
        return this.unknownUnicastEnable;
    }

    @Generated
    public Integer getUnknownUnicast() {
        return this.unknownUnicast;
    }

    @Generated
    public Boolean getMulticastEnable() {
        return this.multicastEnable;
    }

    @Generated
    public Integer getMulticast() {
        return this.multicast;
    }

    @Generated
    public Boolean getBroadcastEnable() {
        return this.broadcastEnable;
    }

    @Generated
    public Integer getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public Integer getAction() {
        return this.action;
    }

    @Generated
    public Integer getRecoverTime() {
        return this.recoverTime;
    }

    @Generated
    public void setUnknownUnicastEnable(Boolean unknownUnicastEnable) {
        this.unknownUnicastEnable = unknownUnicastEnable;
    }

    @Generated
    public void setUnknownUnicast(Integer unknownUnicast) {
        this.unknownUnicast = unknownUnicast;
    }

    @Generated
    public void setMulticastEnable(Boolean multicastEnable) {
        this.multicastEnable = multicastEnable;
    }

    @Generated
    public void setMulticast(Integer multicast) {
        this.multicast = multicast;
    }

    @Generated
    public void setBroadcastEnable(Boolean broadcastEnable) {
        this.broadcastEnable = broadcastEnable;
    }

    @Generated
    public void setBroadcast(Integer broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setAction(Integer action) {
        this.action = action;
    }

    @Generated
    public void setRecoverTime(Integer recoverTime) {
        this.recoverTime = recoverTime;
    }

    @Generated
    public String toString() {
        return "OswStormCtrlOpenApiVO(unknownUnicastEnable=" + this.getUnknownUnicastEnable() + ", unknownUnicast=" + this.getUnknownUnicast() + ", multicastEnable=" + this.getMulticastEnable() + ", multicast=" + this.getMulticast() + ", broadcastEnable=" + this.getBroadcastEnable() + ", broadcast=" + this.getBroadcast() + ", action=" + this.getAction() + ", recoverTime=" + this.getRecoverTime() + ")";
    }

    @Generated
    public OswStormCtrlOpenApiVO(Boolean unknownUnicastEnable, Integer unknownUnicast, Boolean multicastEnable, Integer multicast, Boolean broadcastEnable, Integer broadcast, Integer action, Integer recoverTime) {
        this.unknownUnicastEnable = unknownUnicastEnable;
        this.unknownUnicast = unknownUnicast;
        this.multicastEnable = multicastEnable;
        this.multicast = multicast;
        this.broadcastEnable = broadcastEnable;
        this.broadcast = broadcast;
        this.action = action;
        this.recoverTime = recoverTime;
    }

    @Generated
    public OswStormCtrlOpenApiVO() {
    }

    @Generated
    public static abstract class OswStormCtrlOpenApiVOBuilder<C extends OswStormCtrlOpenApiVO, B extends OswStormCtrlOpenApiVOBuilder<C, B>> {
        @Generated
        private Boolean unknownUnicastEnable;
        @Generated
        private Integer unknownUnicast;
        @Generated
        private Boolean multicastEnable;
        @Generated
        private Integer multicast;
        @Generated
        private Boolean broadcastEnable;
        @Generated
        private Integer broadcast;
        @Generated
        private Integer action;
        @Generated
        private Integer recoverTime;

        @Generated
        public B unknownUnicastEnable(Boolean unknownUnicastEnable) {
            this.unknownUnicastEnable = unknownUnicastEnable;
            return this.self();
        }

        @Generated
        public B unknownUnicast(Integer unknownUnicast) {
            this.unknownUnicast = unknownUnicast;
            return this.self();
        }

        @Generated
        public B multicastEnable(Boolean multicastEnable) {
            this.multicastEnable = multicastEnable;
            return this.self();
        }

        @Generated
        public B multicast(Integer multicast) {
            this.multicast = multicast;
            return this.self();
        }

        @Generated
        public B broadcastEnable(Boolean broadcastEnable) {
            this.broadcastEnable = broadcastEnable;
            return this.self();
        }

        @Generated
        public B broadcast(Integer broadcast) {
            this.broadcast = broadcast;
            return this.self();
        }

        @Generated
        public B action(Integer action) {
            this.action = action;
            return this.self();
        }

        @Generated
        public B recoverTime(Integer recoverTime) {
            this.recoverTime = recoverTime;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OswStormCtrlOpenApiVO.OswStormCtrlOpenApiVOBuilder(unknownUnicastEnable=" + this.unknownUnicastEnable + ", unknownUnicast=" + this.unknownUnicast + ", multicastEnable=" + this.multicastEnable + ", multicast=" + this.multicast + ", broadcastEnable=" + this.broadcastEnable + ", broadcast=" + this.broadcast + ", action=" + this.action + ", recoverTime=" + this.recoverTime + ")";
        }
    }

    @Generated
    private static final class OswStormCtrlOpenApiVOBuilderImpl
    extends OswStormCtrlOpenApiVOBuilder<OswStormCtrlOpenApiVO, OswStormCtrlOpenApiVOBuilderImpl> {
        @Generated
        private OswStormCtrlOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStormCtrlOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStormCtrlOpenApiVO build() {
            return new OswStormCtrlOpenApiVO(this);
        }
    }
}

