/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStaticRoutingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="OswStaticRoutingConfigOpenApiVO")
public class OswStaticRoutingConfigOpenApiVO {
    @Schema(name="ipVersion", description="The IP Version of class rule should be a value as follows: 0: IPv4; 1: IPv6.")
    @NumberSet(value={0, 1}, message="Parameter [ipVersion] should be 0 or 1.")
    @NotNull(message="Parameter [ipVersion] must not be null.")
    private @NotNull(message="Parameter [ipVersion] must not be null.") Integer ipVersion;
    @NotNull(message="Parameter [status] must not be null.")
    @Schema(name="status", description="StaticRouting status")
    private @NotNull(message="Parameter [status] must not be null.") Boolean status;
    @NotNull(message="Parameter [destinations] must not be null.")
    @Schema(name="destinations", description="IP address/SubNet, up to 16 entries are allowed for the destinations list.")
    private @NotNull(message="Parameter [destinations] must not be null.") List<String> destinations;
    @NotNull(message="Parameter [nextHopIp] must not be null.")
    @Schema(name="nextHopIp", description="NextHopIp")
    private @NotNull(message="Parameter [nextHopIp] must not be null.") String nextHopIp;
    @NotNull(message="Parameter [distance] must not be null.")
    @Range(min=1L, max=255L, message="Value of distance is from 1 to 255.")
    @Schema(name="distance", description="Distance should be within the range of 1\u2013255.")
    private @NotNull(message="Parameter [distance] must not be null.") @Range(min=1L, max=255L, message="Value of distance is from 1 to 255.") Integer distance;

    public static OswStaticRoutingVO buildWebVO(OswStaticRoutingConfigOpenApiVO openApiVO) {
        OswStaticRoutingVO vo = new OswStaticRoutingVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setDestinations(openApiVO.getDestinations());
        vo.setDistance(openApiVO.getDistance());
        vo.setStatus(openApiVO.getStatus());
        vo.setNextHopIp(openApiVO.getNextHopIp());
        vo.setIpVersion(openApiVO.getIpVersion());
        return vo;
    }

    public OperationResponse checkValidation() {
        if (CollectionUtils.isEmpty(this.getDestinations())) {
            return new OperationResponse(b.d, "Parameter [destinations] must not be empty.", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    protected OswStaticRoutingConfigOpenApiVO(OswStaticRoutingConfigOpenApiVOBuilder<?, ?> b2) {
        this.ipVersion = b2.ipVersion;
        this.status = b2.status;
        this.destinations = b2.destinations;
        this.nextHopIp = b2.nextHopIp;
        this.distance = b2.distance;
    }

    @Generated
    public static OswStaticRoutingConfigOpenApiVOBuilder<?, ?> builder() {
        return new OswStaticRoutingConfigOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getIpVersion() {
        return this.ipVersion;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public List<String> getDestinations() {
        return this.destinations;
    }

    @Generated
    public String getNextHopIp() {
        return this.nextHopIp;
    }

    @Generated
    public Integer getDistance() {
        return this.distance;
    }

    @Generated
    public void setIpVersion(Integer ipVersion) {
        this.ipVersion = ipVersion;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setDestinations(List<String> destinations) {
        this.destinations = destinations;
    }

    @Generated
    public void setNextHopIp(String nextHopIp) {
        this.nextHopIp = nextHopIp;
    }

    @Generated
    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    @Generated
    public String toString() {
        return "OswStaticRoutingConfigOpenApiVO(ipVersion=" + this.getIpVersion() + ", status=" + this.getStatus() + ", destinations=" + this.getDestinations() + ", nextHopIp=" + this.getNextHopIp() + ", distance=" + this.getDistance() + ")";
    }

    @Generated
    public OswStaticRoutingConfigOpenApiVO(Integer ipVersion, Boolean status, List<String> destinations, String nextHopIp, Integer distance) {
        this.ipVersion = ipVersion;
        this.status = status;
        this.destinations = destinations;
        this.nextHopIp = nextHopIp;
        this.distance = distance;
    }

    @Generated
    public OswStaticRoutingConfigOpenApiVO() {
    }

    @Generated
    public static abstract class OswStaticRoutingConfigOpenApiVOBuilder<C extends OswStaticRoutingConfigOpenApiVO, B extends OswStaticRoutingConfigOpenApiVOBuilder<C, B>> {
        @Generated
        private Integer ipVersion;
        @Generated
        private Boolean status;
        @Generated
        private List<String> destinations;
        @Generated
        private String nextHopIp;
        @Generated
        private Integer distance;

        @Generated
        public B ipVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B destinations(List<String> destinations) {
            this.destinations = destinations;
            return this.self();
        }

        @Generated
        public B nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this.self();
        }

        @Generated
        public B distance(Integer distance) {
            this.distance = distance;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OswStaticRoutingConfigOpenApiVO.OswStaticRoutingConfigOpenApiVOBuilder(ipVersion=" + this.ipVersion + ", status=" + this.status + ", destinations=" + this.destinations + ", nextHopIp=" + this.nextHopIp + ", distance=" + this.distance + ")";
        }
    }

    @Generated
    private static final class OswStaticRoutingConfigOpenApiVOBuilderImpl
    extends OswStaticRoutingConfigOpenApiVOBuilder<OswStaticRoutingConfigOpenApiVO, OswStaticRoutingConfigOpenApiVOBuilderImpl> {
        @Generated
        private OswStaticRoutingConfigOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStaticRoutingConfigOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStaticRoutingConfigOpenApiVO build() {
            return new OswStaticRoutingConfigOpenApiVO(this);
        }
    }
}

