/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.home.quickaction.dto.RestartPoeDeviceVO;
import com.tplink.smb.omada.manager.home.quickaction.dto.RestartPoeResultVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="OswPoeResultOpenApiVO")
public class OswPoeRecoverResultOpenApiVO {
    @Schema(name="process", description="PoE recovery progress.")
    private Integer process;
    @Schema(name="deviceResult", description="PoE recovery result returned by devices.")
    private PoeRecoverDeviceOpenApiVO deviceResult;

    public static OswPoeRecoverResultOpenApiVO trans(RestartPoeResultVO restartPoeResultVO) {
        if (CollectionUtils.isEmpty((Collection)restartPoeResultVO.getDevices())) {
            return new OswPoeRecoverResultOpenApiVO();
        }
        RestartPoeDeviceVO deviceVO = (RestartPoeDeviceVO)restartPoeResultVO.getDevices().get(0);
        OswPoeRecoverResultOpenApiVO oswPoeRecoverResultOpenApiVO = new OswPoeRecoverResultOpenApiVO();
        oswPoeRecoverResultOpenApiVO.setProcess(restartPoeResultVO.getProcess());
        oswPoeRecoverResultOpenApiVO.setDeviceResult(PoeRecoverDeviceOpenApiVO.builder().mac(deviceVO.getMac()).status(deviceVO.getStatus()).successPorts(deviceVO.getSuccessPorts()).failPorts(deviceVO.getFailPortReason()).selectPorts(deviceVO.getSelectPorts()).build());
        return oswPoeRecoverResultOpenApiVO;
    }

    @Generated
    public Integer getProcess() {
        return this.process;
    }

    @Generated
    public PoeRecoverDeviceOpenApiVO getDeviceResult() {
        return this.deviceResult;
    }

    @Generated
    public void setProcess(Integer process) {
        this.process = process;
    }

    @Generated
    public void setDeviceResult(PoeRecoverDeviceOpenApiVO deviceResult) {
        this.deviceResult = deviceResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OswPoeRecoverResultOpenApiVO)) {
            return false;
        }
        OswPoeRecoverResultOpenApiVO other = (OswPoeRecoverResultOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$process = this.getProcess();
        Integer other$process = other.getProcess();
        if (this$process == null ? other$process != null : !((Object)this$process).equals(other$process)) {
            return false;
        }
        PoeRecoverDeviceOpenApiVO this$deviceResult = this.getDeviceResult();
        PoeRecoverDeviceOpenApiVO other$deviceResult = other.getDeviceResult();
        return !(this$deviceResult == null ? other$deviceResult != null : !((Object)this$deviceResult).equals(other$deviceResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswPoeRecoverResultOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
        PoeRecoverDeviceOpenApiVO $deviceResult = this.getDeviceResult();
        result = result * 59 + ($deviceResult == null ? 43 : ((Object)$deviceResult).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswPoeRecoverResultOpenApiVO(process=" + this.getProcess() + ", deviceResult=" + this.getDeviceResult() + ")";
    }

    @Generated
    public OswPoeRecoverResultOpenApiVO() {
    }

    @Generated
    public OswPoeRecoverResultOpenApiVO(Integer process, PoeRecoverDeviceOpenApiVO deviceResult) {
        this.process = process;
        this.deviceResult = deviceResult;
    }

    public static class PoeRecoverDeviceOpenApiVO {
        @Schema(name="mac", description="Device MAC address.")
        @a
        private String mac;
        @Schema(name="status", description="Device status: 0 - success, 1 - failed.")
        private Integer status;
        @Schema(name="successPorts", description="List of ports that PoE recovery succeeded.")
        private List<String> successPorts;
        @Schema(name="failPorts", description="List of ports that PoE recovery failed.")
        private Map<String, String> failPorts;
        @Schema(name="selectPorts", description="The selected ports for poe recover.")
        private List<String> selectPorts;

        @Generated
        public static PoeRecoverDeviceOpenApiVOBuilder builder() {
            return new PoeRecoverDeviceOpenApiVOBuilder();
        }

        @Generated
        public String getMac() {
            return this.mac;
        }

        @Generated
        public Integer getStatus() {
            return this.status;
        }

        @Generated
        public List<String> getSuccessPorts() {
            return this.successPorts;
        }

        @Generated
        public Map<String, String> getFailPorts() {
            return this.failPorts;
        }

        @Generated
        public List<String> getSelectPorts() {
            return this.selectPorts;
        }

        @Generated
        public void setMac(String mac) {
            this.mac = mac;
        }

        @Generated
        public void setStatus(Integer status) {
            this.status = status;
        }

        @Generated
        public void setSuccessPorts(List<String> successPorts) {
            this.successPorts = successPorts;
        }

        @Generated
        public void setFailPorts(Map<String, String> failPorts) {
            this.failPorts = failPorts;
        }

        @Generated
        public void setSelectPorts(List<String> selectPorts) {
            this.selectPorts = selectPorts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PoeRecoverDeviceOpenApiVO)) {
                return false;
            }
            PoeRecoverDeviceOpenApiVO other = (PoeRecoverDeviceOpenApiVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
                return false;
            }
            List<String> this$successPorts = this.getSuccessPorts();
            List<String> other$successPorts = other.getSuccessPorts();
            if (this$successPorts == null ? other$successPorts != null : !((Object)this$successPorts).equals(other$successPorts)) {
                return false;
            }
            Map<String, String> this$failPorts = this.getFailPorts();
            Map<String, String> other$failPorts = other.getFailPorts();
            if (this$failPorts == null ? other$failPorts != null : !((Object)this$failPorts).equals(other$failPorts)) {
                return false;
            }
            List<String> this$selectPorts = this.getSelectPorts();
            List<String> other$selectPorts = other.getSelectPorts();
            return !(this$selectPorts == null ? other$selectPorts != null : !((Object)this$selectPorts).equals(other$selectPorts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PoeRecoverDeviceOpenApiVO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            List<String> $successPorts = this.getSuccessPorts();
            result = result * 59 + ($successPorts == null ? 43 : ((Object)$successPorts).hashCode());
            Map<String, String> $failPorts = this.getFailPorts();
            result = result * 59 + ($failPorts == null ? 43 : ((Object)$failPorts).hashCode());
            List<String> $selectPorts = this.getSelectPorts();
            result = result * 59 + ($selectPorts == null ? 43 : ((Object)$selectPorts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OswPoeRecoverResultOpenApiVO.PoeRecoverDeviceOpenApiVO(mac=" + this.getMac() + ", status=" + this.getStatus() + ", successPorts=" + this.getSuccessPorts() + ", failPorts=" + this.getFailPorts() + ", selectPorts=" + this.getSelectPorts() + ")";
        }

        @Generated
        public PoeRecoverDeviceOpenApiVO() {
        }

        @Generated
        public PoeRecoverDeviceOpenApiVO(String mac, Integer status, List<String> successPorts, Map<String, String> failPorts, List<String> selectPorts) {
            this.mac = mac;
            this.status = status;
            this.successPorts = successPorts;
            this.failPorts = failPorts;
            this.selectPorts = selectPorts;
        }

        @Generated
        public static class PoeRecoverDeviceOpenApiVOBuilder {
            @Generated
            private String mac;
            @Generated
            private Integer status;
            @Generated
            private List<String> successPorts;
            @Generated
            private Map<String, String> failPorts;
            @Generated
            private List<String> selectPorts;

            @Generated
            PoeRecoverDeviceOpenApiVOBuilder() {
            }

            @Generated
            public PoeRecoverDeviceOpenApiVOBuilder mac(String mac) {
                this.mac = mac;
                return this;
            }

            @Generated
            public PoeRecoverDeviceOpenApiVOBuilder status(Integer status) {
                this.status = status;
                return this;
            }

            @Generated
            public PoeRecoverDeviceOpenApiVOBuilder successPorts(List<String> successPorts) {
                this.successPorts = successPorts;
                return this;
            }

            @Generated
            public PoeRecoverDeviceOpenApiVOBuilder failPorts(Map<String, String> failPorts) {
                this.failPorts = failPorts;
                return this;
            }

            @Generated
            public PoeRecoverDeviceOpenApiVOBuilder selectPorts(List<String> selectPorts) {
                this.selectPorts = selectPorts;
                return this;
            }

            @Generated
            public PoeRecoverDeviceOpenApiVO build() {
                return new PoeRecoverDeviceOpenApiVO(this.mac, this.status, this.successPorts, this.failPorts, this.selectPorts);
            }

            @Generated
            public String toString() {
                return "OswPoeRecoverResultOpenApiVO.PoeRecoverDeviceOpenApiVO.PoeRecoverDeviceOpenApiVOBuilder(mac=" + this.mac + ", status=" + this.status + ", successPorts=" + this.successPorts + ", failPorts=" + this.failPorts + ", selectPorts=" + this.selectPorts + ")";
            }
        }
    }
}

