/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.ecsp.common.util.StringUtils;
import com.tplink.smb.omada.common.constant.r;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OswDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpRelayOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpServerOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpServerRangeOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswIpSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswIpv6SettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswNetworkBaseOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDhcpRelayVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDhcpServerVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswIpSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswIpv6SettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswNetworkVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswNetworkOpenApi")
public class OswNetworkOpenApiVO
extends OswNetworkBaseOpenApiVO {
    @Schema(name="mvlan", description="Indicate the vlan is management vlan or not.")
    @NotNull(message="Mvlan must not be null")
    private @NotNull(message="Mvlan must not be null") Boolean mvlan;
    @Schema(name="name", description="Switch network name.")
    private String name;
    @Valid
    @Schema(name="ip", description="Network IP setting.")
    private OswIpSettingOpenApiVO ip;
    @Schema(name="ipv6Enable", description="Enable IPV6 or not.")
    private Boolean ipv6Enable;
    @Valid
    @Schema(name="ipv6", description="Network IPV6 setting.")
    private OswIpv6SettingOpenApiVO ipv6;
    @NotNull(message="Parameter [mode] should not be null.")
    @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.")
    @Schema(name="mode", description="DHCP mode. 0: None, mode 1: DHCP Server, mode 2: DHCP Relay")
    private @NotNull(message="Parameter [mode] should not be null.") @Range(min=0L, max=2L, message="Value of mode is from 0 to 2.") Integer mode;
    @Valid
    @Schema(name="dhcpServer", description="Network DHCP server settings.")
    private OswDhcpServerOpenApiVO dhcpServer;
    @Valid
    @Schema(name="dhcpRelay", description="Network DHCP relay settings.")
    private OswDhcpRelayOpenApiVO dhcpRelay;
    @Schema(description="VRF ID")
    private String vrfId;

    public static OswNetworkOpenApiVO buildFromVO(OswNetworkVO vo) {
        OswNetworkOpenApiVO openApiVO = new OswNetworkOpenApiVO();
        if (vo == null) {
            return openApiVO;
        }
        openApiVO.setId(vo.getId());
        openApiVO.setMvlan(Boolean.TRUE.equals(vo.getMvlan()));
        openApiVO.setName(vo.getName());
        openApiVO.setVlan(vo.getVlan());
        openApiVO.setStatus(vo.getStatus() == 0 ? Boolean.FALSE : Boolean.TRUE);
        openApiVO.setIp(OswNetworkOpenApiVO.buildOswIpSettingOpenApiVO(vo.getIp()));
        openApiVO.setIpv6Enable(vo.getIpv6Enable());
        openApiVO.setIpv6(OswNetworkOpenApiVO.buildOswIpV6SettingOpenApiVO(vo.getIpv6()));
        openApiVO.setMode(vo.getMode());
        openApiVO.setDhcpServer(OswNetworkOpenApiVO.buildOswDhcpServerOpenApiVO(vo.getDhcpServer()));
        openApiVO.setDhcpRelay(OswNetworkOpenApiVO.buildOswDhcpRelayOpenApiVO(vo.getDhcpRelay()));
        openApiVO.setVrfId(vo.getVrfId());
        return openApiVO;
    }

    public static OswDhcpRelayOpenApiVO buildOswDhcpRelayOpenApiVO(OswDhcpRelayVO dhcpRelay) {
        OswDhcpRelayOpenApiVO openApiVO = new OswDhcpRelayOpenApiVO();
        if (dhcpRelay == null) {
            return null;
        }
        openApiVO.setAddr(dhcpRelay.getAddr());
        openApiVO.setVrfId(dhcpRelay.getVrfId());
        return openApiVO;
    }

    public static OswDhcpServerOpenApiVO buildOswDhcpServerOpenApiVO(OswDhcpServerVO dhcpServer) {
        OswDhcpServerOpenApiVO openApiVO = new OswDhcpServerOpenApiVO();
        if (dhcpServer == null) {
            return null;
        }
        openApiVO.setIp(dhcpServer.getIp());
        openApiVO.setNetmask(dhcpServer.getNetmask());
        openApiVO.setRange(Optional.ofNullable(dhcpServer.getRange()).map(dhcpRangeVOs -> dhcpRangeVOs.stream().map(OswDhcpServerRangeOpenApiVO::buildByWebVO).toList()).orElse(null));
        openApiVO.setPriDns(dhcpServer.getPriDns());
        openApiVO.setSndDns(dhcpServer.getSndDns());
        openApiVO.setLeasetime(dhcpServer.getLeasetime());
        openApiVO.setGateway(dhcpServer.getGateway());
        openApiVO.setOption138(dhcpServer.getOption138());
        openApiVO.setOptions(Optional.ofNullable(dhcpServer.getOptions()).map(dhcpOptionVOS -> dhcpOptionVOS.stream().map(OswDhcpOptionOpenApiVO::buildByWebVO).toList()).orElse(null));
        openApiVO.setVrfId(dhcpServer.getVrfId());
        return openApiVO;
    }

    private static OswIpv6SettingOpenApiVO buildOswIpV6SettingOpenApiVO(@Valid OswIpv6SettingVO ipv6) {
        OswIpv6SettingOpenApiVO openApiVO = new OswIpv6SettingOpenApiVO();
        if (ipv6 == null) {
            return openApiVO;
        }
        openApiVO.setMode(ipv6.getMode());
        openApiVO.setDnsMode(ipv6.getDnsMode());
        openApiVO.setPriDns(ipv6.getPriDns());
        openApiVO.setSndDns(ipv6.getSndDns());
        openApiVO.setIpv6Addr(ipv6.getIpv6Addr());
        openApiVO.setPrefixLen(ipv6.getPrefixLen());
        return openApiVO;
    }

    private static OswIpSettingOpenApiVO buildOswIpSettingOpenApiVO(OswIpSettingVO ip) {
        OswIpSettingOpenApiVO openApiVO = new OswIpSettingOpenApiVO();
        if (ip == null) {
            return openApiVO;
        }
        openApiVO.setMode(ip.getMode());
        openApiVO.setIp(ip.getIp());
        openApiVO.setGateway(ip.getGateway());
        openApiVO.setNetmask(ip.getNetmask());
        openApiVO.setPreDns(ip.getPreDns());
        openApiVO.setSecDns(ip.getSecDns());
        openApiVO.setFallback(ip.getFallback());
        openApiVO.setFallbackIp(ip.getFallbackIp());
        openApiVO.setFallbackMask(ip.getFallbackMask());
        openApiVO.setFallbackGate(ip.getFallbackGate());
        openApiVO.setOption12(ip.getOption12());
        openApiVO.setUseFixedAddr(ip.getUseFixedAddr());
        openApiVO.setNetId(ip.getNetId());
        openApiVO.setDhcpIp(ip.getDhcpIp());
        openApiVO.setServerType(ip.getServerType());
        openApiVO.setServerMac(ip.getServerMac());
        openApiVO.setServerStackId(ip.getServerStackId());
        openApiVO.setConfirmConflict(ip.getConfirmConflict());
        return openApiVO;
    }

    public boolean validate() {
        OswIpSettingOpenApiVO oswIpSettingVO = this.getIp();
        if (oswIpSettingVO == null || oswIpSettingVO.getMode() == r.a.d && (StringUtils.isEmpty((String)oswIpSettingVO.getIp()) || StringUtils.isEmpty((String)oswIpSettingVO.getNetmask()))) {
            return false;
        }
        if (this.getMode() == 1 && this.getDhcpServer() == null || this.getMode() == 2 && this.getDhcpRelay() == null) {
            return false;
        }
        if (this.getMode() == 1) {
            return this.getDhcpServer().getLeasetime() != null;
        }
        return true;
    }

    public static OswNetworkVO buildWebVO(OswNetworkOpenApiVO vo) {
        OswNetworkVO oswNetworkVO = new OswNetworkVO();
        if (vo == null) {
            return oswNetworkVO;
        }
        oswNetworkVO.setId(vo.getId());
        oswNetworkVO.setMvlan(Boolean.valueOf(Boolean.TRUE.equals(vo.getMvlan())));
        oswNetworkVO.setName(vo.getName());
        oswNetworkVO.setVlan(vo.getVlan());
        oswNetworkVO.setStatus(Integer.valueOf(Boolean.TRUE.equals(vo.getStatus()) ? 1 : 0));
        oswNetworkVO.setIp(OswNetworkOpenApiVO.buildOswIpSettingWebVO(vo.getIp()));
        oswNetworkVO.setIpv6Enable(vo.getIpv6Enable());
        oswNetworkVO.setIpv6(OswNetworkOpenApiVO.buildOswIpV6SettingWebVO(vo.getIpv6()));
        oswNetworkVO.setMode(vo.getMode());
        oswNetworkVO.setDhcpServer(OswNetworkOpenApiVO.buildOswDhcpServerWebVO(vo.getDhcpServer()));
        oswNetworkVO.setDhcpRelay(OswNetworkOpenApiVO.buildOswDhcpRelayWebVO(vo.getDhcpRelay()));
        return oswNetworkVO;
    }

    public static OswDhcpRelayVO buildOswDhcpRelayWebVO(OswDhcpRelayOpenApiVO openApiVO) {
        if (openApiVO == null) {
            return null;
        }
        OswDhcpRelayVO dhcpRelayVO = new OswDhcpRelayVO();
        dhcpRelayVO.setAddr(openApiVO.getAddr());
        dhcpRelayVO.setVrfId(openApiVO.getVrfId());
        return dhcpRelayVO;
    }

    public static OswDhcpServerVO buildOswDhcpServerWebVO(OswDhcpServerOpenApiVO openApiVO) {
        OswDhcpServerVO dhcpServerVO = new OswDhcpServerVO();
        if (openApiVO == null) {
            return null;
        }
        dhcpServerVO.setIp(openApiVO.getIp());
        dhcpServerVO.setNetmask(openApiVO.getNetmask());
        dhcpServerVO.setRange((List)Optional.ofNullable(openApiVO.getRange()).map(oswDhcpServerRangeOpenApiVOS -> oswDhcpServerRangeOpenApiVOS.stream().map(OswDhcpServerRangeOpenApiVO::buildWebVO).toList()).orElse(null));
        dhcpServerVO.setPriDns(openApiVO.getPriDns());
        dhcpServerVO.setSndDns(openApiVO.getSndDns());
        dhcpServerVO.setLeasetime(openApiVO.getLeasetime());
        dhcpServerVO.setGateway(openApiVO.getGateway());
        dhcpServerVO.setOption138(openApiVO.getOption138());
        dhcpServerVO.setOptions((List)Optional.ofNullable(openApiVO.getOptions()).map(oswDhcpOptionOpenApiVOs -> oswDhcpOptionOpenApiVOs.stream().map(OswDhcpOptionOpenApiVO::buildWebVO).toList()).orElse(null));
        dhcpServerVO.setVrfId(openApiVO.getVrfId());
        return dhcpServerVO;
    }

    private static OswIpv6SettingVO buildOswIpV6SettingWebVO(@Valid OswIpv6SettingOpenApiVO openApiVO) {
        OswIpv6SettingVO ipv6SettingVO = new OswIpv6SettingVO();
        if (openApiVO == null) {
            return null;
        }
        ipv6SettingVO.setMode(openApiVO.getMode());
        ipv6SettingVO.setDnsMode(openApiVO.getDnsMode());
        ipv6SettingVO.setPriDns(openApiVO.getPriDns());
        ipv6SettingVO.setSndDns(openApiVO.getSndDns());
        ipv6SettingVO.setIpv6Addr(openApiVO.getIpv6Addr());
        ipv6SettingVO.setPrefixLen(openApiVO.getPrefixLen());
        return ipv6SettingVO;
    }

    private static OswIpSettingVO buildOswIpSettingWebVO(OswIpSettingOpenApiVO openApiVO) {
        OswIpSettingVO ipSettingVO = new OswIpSettingVO();
        if (openApiVO == null) {
            return ipSettingVO;
        }
        ipSettingVO.setMode(openApiVO.getMode());
        ipSettingVO.setIp(openApiVO.getIp());
        ipSettingVO.setGateway(openApiVO.getGateway());
        ipSettingVO.setNetmask(openApiVO.getNetmask());
        ipSettingVO.setPreDns(openApiVO.getPreDns());
        ipSettingVO.setSecDns(openApiVO.getSecDns());
        ipSettingVO.setFallback(openApiVO.getFallback());
        ipSettingVO.setFallbackIp(openApiVO.getFallbackIp());
        ipSettingVO.setFallbackMask(openApiVO.getFallbackMask());
        ipSettingVO.setFallbackGate(openApiVO.getFallbackGate());
        ipSettingVO.setOption12(openApiVO.getOption12());
        ipSettingVO.setUseFixedAddr(openApiVO.getUseFixedAddr());
        ipSettingVO.setNetId(openApiVO.getNetId());
        ipSettingVO.setDhcpIp(openApiVO.getDhcpIp());
        ipSettingVO.setServerType(openApiVO.getServerType());
        ipSettingVO.setServerMac(openApiVO.getServerMac());
        ipSettingVO.setServerStackId(openApiVO.getServerStackId());
        ipSettingVO.setConfirmConflict(openApiVO.getConfirmConflict());
        return ipSettingVO;
    }

    @Generated
    protected OswNetworkOpenApiVO(OswNetworkOpenApiVOBuilder<?, ?> b2) {
        super(b2);
        this.mvlan = b2.mvlan;
        this.name = b2.name;
        this.ip = b2.ip;
        this.ipv6Enable = b2.ipv6Enable;
        this.ipv6 = b2.ipv6;
        this.mode = b2.mode;
        this.dhcpServer = b2.dhcpServer;
        this.dhcpRelay = b2.dhcpRelay;
        this.vrfId = b2.vrfId;
    }

    @Generated
    public static OswNetworkOpenApiVOBuilder<?, ?> builder() {
        return new OswNetworkOpenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getMvlan() {
        return this.mvlan;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public OswIpSettingOpenApiVO getIp() {
        return this.ip;
    }

    @Generated
    public Boolean getIpv6Enable() {
        return this.ipv6Enable;
    }

    @Generated
    public OswIpv6SettingOpenApiVO getIpv6() {
        return this.ipv6;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public OswDhcpServerOpenApiVO getDhcpServer() {
        return this.dhcpServer;
    }

    @Generated
    public OswDhcpRelayOpenApiVO getDhcpRelay() {
        return this.dhcpRelay;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public void setMvlan(Boolean mvlan) {
        this.mvlan = mvlan;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setIp(OswIpSettingOpenApiVO ip) {
        this.ip = ip;
    }

    @Generated
    public void setIpv6Enable(Boolean ipv6Enable) {
        this.ipv6Enable = ipv6Enable;
    }

    @Generated
    public void setIpv6(OswIpv6SettingOpenApiVO ipv6) {
        this.ipv6 = ipv6;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setDhcpServer(OswDhcpServerOpenApiVO dhcpServer) {
        this.dhcpServer = dhcpServer;
    }

    @Generated
    public void setDhcpRelay(OswDhcpRelayOpenApiVO dhcpRelay) {
        this.dhcpRelay = dhcpRelay;
    }

    @Generated
    public void setVrfId(String vrfId) {
        this.vrfId = vrfId;
    }

    @Override
    @Generated
    public String toString() {
        return "OswNetworkOpenApiVO(mvlan=" + this.getMvlan() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", ipv6Enable=" + this.getIpv6Enable() + ", ipv6=" + this.getIpv6() + ", mode=" + this.getMode() + ", dhcpServer=" + this.getDhcpServer() + ", dhcpRelay=" + this.getDhcpRelay() + ", vrfId=" + this.getVrfId() + ")";
    }

    @Generated
    public OswNetworkOpenApiVO(Boolean mvlan, String name, OswIpSettingOpenApiVO ip, Boolean ipv6Enable, OswIpv6SettingOpenApiVO ipv6, Integer mode, OswDhcpServerOpenApiVO dhcpServer, OswDhcpRelayOpenApiVO dhcpRelay, String vrfId) {
        this.mvlan = mvlan;
        this.name = name;
        this.ip = ip;
        this.ipv6Enable = ipv6Enable;
        this.ipv6 = ipv6;
        this.mode = mode;
        this.dhcpServer = dhcpServer;
        this.dhcpRelay = dhcpRelay;
        this.vrfId = vrfId;
    }

    @Generated
    public OswNetworkOpenApiVO() {
    }

    @Generated
    public static abstract class OswNetworkOpenApiVOBuilder<C extends OswNetworkOpenApiVO, B extends OswNetworkOpenApiVOBuilder<C, B>>
    extends OswNetworkBaseOpenApiVO.OswNetworkBaseOpenApiVOBuilder<C, B> {
        @Generated
        private Boolean mvlan;
        @Generated
        private String name;
        @Generated
        private OswIpSettingOpenApiVO ip;
        @Generated
        private Boolean ipv6Enable;
        @Generated
        private OswIpv6SettingOpenApiVO ipv6;
        @Generated
        private Integer mode;
        @Generated
        private OswDhcpServerOpenApiVO dhcpServer;
        @Generated
        private OswDhcpRelayOpenApiVO dhcpRelay;
        @Generated
        private String vrfId;

        @Generated
        public B mvlan(Boolean mvlan) {
            this.mvlan = mvlan;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B ip(OswIpSettingOpenApiVO ip) {
            this.ip = ip;
            return (B)this.self();
        }

        @Generated
        public B ipv6Enable(Boolean ipv6Enable) {
            this.ipv6Enable = ipv6Enable;
            return (B)this.self();
        }

        @Generated
        public B ipv6(OswIpv6SettingOpenApiVO ipv6) {
            this.ipv6 = ipv6;
            return (B)this.self();
        }

        @Generated
        public B mode(Integer mode) {
            this.mode = mode;
            return (B)this.self();
        }

        @Generated
        public B dhcpServer(OswDhcpServerOpenApiVO dhcpServer) {
            this.dhcpServer = dhcpServer;
            return (B)this.self();
        }

        @Generated
        public B dhcpRelay(OswDhcpRelayOpenApiVO dhcpRelay) {
            this.dhcpRelay = dhcpRelay;
            return (B)this.self();
        }

        @Generated
        public B vrfId(String vrfId) {
            this.vrfId = vrfId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OswNetworkOpenApiVO.OswNetworkOpenApiVOBuilder(super=" + super.toString() + ", mvlan=" + this.mvlan + ", name=" + this.name + ", ip=" + this.ip + ", ipv6Enable=" + this.ipv6Enable + ", ipv6=" + this.ipv6 + ", mode=" + this.mode + ", dhcpServer=" + this.dhcpServer + ", dhcpRelay=" + this.dhcpRelay + ", vrfId=" + this.vrfId + ")";
        }
    }

    @Generated
    private static final class OswNetworkOpenApiVOBuilderImpl
    extends OswNetworkOpenApiVOBuilder<OswNetworkOpenApiVO, OswNetworkOpenApiVOBuilderImpl> {
        @Generated
        private OswNetworkOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswNetworkOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswNetworkOpenApiVO build() {
            return new OswNetworkOpenApiVO(this);
        }
    }
}

