/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.stack.api.web.dto.StackNetworkVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswNetworkBaseOpenApi")
public class OswNetworkBaseOpenApiVO {
    @Schema(name="id", description="Network ID")
    @NotNull(message="Network ID must not be null")
    private @NotNull(message="Network ID must not be null") String id;
    @Schema(name="vlan", description="VLAN ID.")
    @NotNull(message="Vlan must not be null")
    @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.")
    private @NotNull(message="Vlan must not be null") @Range(min=1L, max=4090L, message="Value of vlan is from 1 to 4090.") Integer vlan;
    @Schema(name="status", description="Enable status of the network vlan.")
    private Boolean status;

    public static final StackNetworkVO buildWebVO(OswNetworkBaseOpenApiVO openApiVO) {
        StackNetworkVO vo = new StackNetworkVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setId(openApiVO.getId());
        vo.setVlan(openApiVO.getVlan());
        vo.setStatus(Integer.valueOf(Boolean.TRUE.equals(openApiVO.getStatus()) ? 1 : 0));
        return vo;
    }

    @Generated
    protected OswNetworkBaseOpenApiVO(OswNetworkBaseOpenApiVOBuilder<?, ?> b2) {
        this.id = b2.id;
        this.vlan = b2.vlan;
        this.status = b2.status;
    }

    @Generated
    public static OswNetworkBaseOpenApiVOBuilder<?, ?> builder() {
        return new OswNetworkBaseOpenApiVOBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getVlan() {
        return this.vlan;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setVlan(Integer vlan) {
        this.vlan = vlan;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public String toString() {
        return "OswNetworkBaseOpenApiVO(id=" + this.getId() + ", vlan=" + this.getVlan() + ", status=" + this.getStatus() + ")";
    }

    @Generated
    public OswNetworkBaseOpenApiVO(String id, Integer vlan, Boolean status) {
        this.id = id;
        this.vlan = vlan;
        this.status = status;
    }

    @Generated
    public OswNetworkBaseOpenApiVO() {
    }

    @Generated
    public static abstract class OswNetworkBaseOpenApiVOBuilder<C extends OswNetworkBaseOpenApiVO, B extends OswNetworkBaseOpenApiVOBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private Integer vlan;
        @Generated
        private Boolean status;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B vlan(Integer vlan) {
            this.vlan = vlan;
            return this.self();
        }

        @Generated
        public B status(Boolean status) {
            this.status = status;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OswNetworkBaseOpenApiVO.OswNetworkBaseOpenApiVOBuilder(id=" + this.id + ", vlan=" + this.vlan + ", status=" + this.status + ")";
        }
    }

    @Generated
    private static final class OswNetworkBaseOpenApiVOBuilderImpl
    extends OswNetworkBaseOpenApiVOBuilder<OswNetworkBaseOpenApiVO, OswNetworkBaseOpenApiVOBuilderImpl> {
        @Generated
        private OswNetworkBaseOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswNetworkBaseOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswNetworkBaseOpenApiVO build() {
            return new OswNetworkBaseOpenApiVO(this);
        }
    }
}

