/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.device.manage.message.config.osw.OswStpMstpConfig;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswConfigVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="SwitchLoopbackControl")
public class OswLoopbackControlOpenApiVO {
    @Schema(name="loopbackDetectEnable", description="LoopbackDetectEnable")
    private Boolean loopbackDetectEnable;
    @Schema(name="stp", description="STP should be a value as follows: 0: OFF 1: STP 2: RSTP 3: MSTP ")
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [stp] should be 0 or 1 or 2 or 3")
    private Integer stp;
    @Schema(name="priority", description="Parameter [priority] should be an integer from 0 to 61440 and divisible by 4096.")
    @NumberSet(value={0, 4096, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, 61440}, message="Parameter [priority] should be an integer from 0 to 61440 and divisible by 4096.")
    private Integer priority;
    @Schema(name="helloTime", description="helloTime should be between 1 and 10.")
    @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.")
    private @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.") Integer helloTime;
    @Schema(name="maxAge", description="maxAge should be between 6 and 40.")
    @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.")
    private @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.") Integer maxAge;
    @Schema(name="forwardDelay", description="forwardDelay should be between 4 and 30.")
    @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.")
    private @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.") Integer forwardDelay;
    @Schema(name="txHoldCount", description="txHoldCount should be between 1 and 20.")
    @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.")
    private @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.") Integer txHoldCount;
    @Schema(name="maxHops", description="maxHops should be between 1 and 40.")
    @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.")
    private @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.") Integer maxHops;
    @Schema(name="mstp", description="STP MSTP Config")
    @Valid
    private OswStpMstpConfig mstp;

    public OswConfigVO buildOswConfigVO() {
        OswConfigVO oswConfigVO = new OswConfigVO();
        oswConfigVO.setLoopbackDetectEnable(this.loopbackDetectEnable);
        oswConfigVO.setStp(this.stp);
        oswConfigVO.setPriority(this.priority);
        oswConfigVO.setHelloTime(this.helloTime);
        oswConfigVO.setMaxAge(this.maxAge);
        oswConfigVO.setForwardDelay(this.forwardDelay);
        oswConfigVO.setTxHoldCount(this.txHoldCount);
        oswConfigVO.setMaxHops(this.maxHops);
        return oswConfigVO;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Integer getStp() {
        return this.stp;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getHelloTime() {
        return this.helloTime;
    }

    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public Integer getForwardDelay() {
        return this.forwardDelay;
    }

    @Generated
    public Integer getTxHoldCount() {
        return this.txHoldCount;
    }

    @Generated
    public Integer getMaxHops() {
        return this.maxHops;
    }

    @Generated
    public OswStpMstpConfig getMstp() {
        return this.mstp;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setStp(Integer stp) {
        this.stp = stp;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setHelloTime(Integer helloTime) {
        this.helloTime = helloTime;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setForwardDelay(Integer forwardDelay) {
        this.forwardDelay = forwardDelay;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setTxHoldCount(Integer txHoldCount) {
        this.txHoldCount = txHoldCount;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setMaxHops(Integer maxHops) {
        this.maxHops = maxHops;
        return this;
    }

    @Generated
    public OswLoopbackControlOpenApiVO setMstp(OswStpMstpConfig mstp) {
        this.mstp = mstp;
        return this;
    }

    @Generated
    public String toString() {
        return "OswLoopbackControlOpenApiVO(loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", stp=" + this.getStp() + ", priority=" + this.getPriority() + ", helloTime=" + this.getHelloTime() + ", maxAge=" + this.getMaxAge() + ", forwardDelay=" + this.getForwardDelay() + ", txHoldCount=" + this.getTxHoldCount() + ", maxHops=" + this.getMaxHops() + ", mstp=" + this.getMstp() + ")";
    }
}

