/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.a.a;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswIpSettingOpenApiVO")
public class OswIpSettingOpenApiVO {
    @NotNull(message="iP setting parameter [mode] should not be null.")
    @Range(min=0L, max=1L, message="Value of ip setting mode is from 0 to 1.")
    @Schema(name="mode", description="IP Setting mode. Static:0, DHCP:1")
    private @NotNull(message="iP setting parameter [mode] should not be null.") @Range(min=0L, max=1L, message="Value of ip setting mode is from 0 to 1.") Integer mode;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="ip", description="Static IP for mode 0, like 192.168.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid IP address.") String ip;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Gateway IP address.")
    @Schema(name="gateway", description="Gateway, like 192.168.137.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Gateway IP address.") String gateway;
    @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid IP Mask.")
    @Schema(name="netmask", description="IP Mask, like 255.255.255.0")
    private @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid IP Mask.") String netmask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server IP address.")
    @Schema(name="preDns", description="Primary DNS Server, like 127.0.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Primary DNS Server IP address.") String preDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Second DNS Server IP address.")
    @Schema(name="secDns", description="Second DNS Server, link 127.0.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid Second DNS Server IP address.") String secDns;
    @Schema(name="fallback", description="The switch of fallback ip for mode 1.")
    private Boolean fallback;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid fallback IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="fallbackIp", description="Fallback ip for dhcp mode when fallback is enabled.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid fallback IP address.") String fallbackIp;
    @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid fallback IP mask.")
    @Schema(name="fallbackMask", description="Fallback mask for dhcp mode when fallback is enabled.")
    private @Pattern(regexp="(254|252|248|240|224|192|128|0).0.0.0|255.(254|252|248|240|224|192|128|0).0.0|255.255.(254|252|248|240|224|192|128|0).0|255.255.255.(254|252|248|240|224|192|128|0)", message="Invalid fallback IP mask.") String fallbackMask;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid fallback Gate.")
    @Schema(name="fallbackGate", description="Fallback gateway for dhcp mode when fallback is enabled.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid fallback Gate.") String fallbackGate;
    @Schema(name="option12", description="option12")
    private String option12;
    @Schema(name="useFixedAddr", description="The switch of Address reservation for dhcp mode.")
    private Boolean useFixedAddr;
    @Schema(name="netId", description="The LAN Network for Address reservation when useFixedAddr is enabled. Obtain the id from \"Get LAN network list\"")
    private String netId;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid dhcp IP address.")
    @PII(strategy=PIIMaskStrategy.HASH)
    @Schema(name="dhcpIp", description="The IP for Address reservation when useFixedAddr is enabled.")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Invalid dhcp IP address.") String dhcpIp;
    @Schema(name="serverType", description="The Type of DHCP Server for Address reservation when useFixedAddr is enabled.")
    private String serverType;
    @Schema(name="serverMac", description="The Mac of DHCP Server for Address reservation when useFixedAddr is enabled.")
    @a
    private String serverMac;
    @Schema(name="serverStackId", description="The Stack ID of DHCP Server for Address reservation when useFixedAddr is enabled.")
    private String serverStackId;
    @Schema(name="confirmConflict", description="Enable IP-MAC Conflict Detection or not.")
    private Boolean confirmConflict;

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public String getPreDns() {
        return this.preDns;
    }

    @Generated
    public String getSecDns() {
        return this.secDns;
    }

    @Generated
    public Boolean getFallback() {
        return this.fallback;
    }

    @Generated
    public String getFallbackIp() {
        return this.fallbackIp;
    }

    @Generated
    public String getFallbackMask() {
        return this.fallbackMask;
    }

    @Generated
    public String getFallbackGate() {
        return this.fallbackGate;
    }

    @Generated
    public String getOption12() {
        return this.option12;
    }

    @Generated
    public Boolean getUseFixedAddr() {
        return this.useFixedAddr;
    }

    @Generated
    public String getNetId() {
        return this.netId;
    }

    @Generated
    public String getDhcpIp() {
        return this.dhcpIp;
    }

    @Generated
    public String getServerType() {
        return this.serverType;
    }

    @Generated
    public String getServerMac() {
        return this.serverMac;
    }

    @Generated
    public String getServerStackId() {
        return this.serverStackId;
    }

    @Generated
    public Boolean getConfirmConflict() {
        return this.confirmConflict;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setPreDns(String preDns) {
        this.preDns = preDns;
    }

    @Generated
    public void setSecDns(String secDns) {
        this.secDns = secDns;
    }

    @Generated
    public void setFallback(Boolean fallback) {
        this.fallback = fallback;
    }

    @Generated
    public void setFallbackIp(String fallbackIp) {
        this.fallbackIp = fallbackIp;
    }

    @Generated
    public void setFallbackMask(String fallbackMask) {
        this.fallbackMask = fallbackMask;
    }

    @Generated
    public void setFallbackGate(String fallbackGate) {
        this.fallbackGate = fallbackGate;
    }

    @Generated
    public void setOption12(String option12) {
        this.option12 = option12;
    }

    @Generated
    public void setUseFixedAddr(Boolean useFixedAddr) {
        this.useFixedAddr = useFixedAddr;
    }

    @Generated
    public void setNetId(String netId) {
        this.netId = netId;
    }

    @Generated
    public void setDhcpIp(String dhcpIp) {
        this.dhcpIp = dhcpIp;
    }

    @Generated
    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Generated
    public void setServerMac(String serverMac) {
        this.serverMac = serverMac;
    }

    @Generated
    public void setServerStackId(String serverStackId) {
        this.serverStackId = serverStackId;
    }

    @Generated
    public void setConfirmConflict(Boolean confirmConflict) {
        this.confirmConflict = confirmConflict;
    }

    @Generated
    public String toString() {
        return "OswIpSettingOpenApiVO(mode=" + this.getMode() + ", ip=" + this.getIp() + ", gateway=" + this.getGateway() + ", netmask=" + this.getNetmask() + ", preDns=" + this.getPreDns() + ", secDns=" + this.getSecDns() + ", fallback=" + this.getFallback() + ", fallbackIp=" + this.getFallbackIp() + ", fallbackMask=" + this.getFallbackMask() + ", fallbackGate=" + this.getFallbackGate() + ", option12=" + this.getOption12() + ", useFixedAddr=" + this.getUseFixedAddr() + ", netId=" + this.getNetId() + ", dhcpIp=" + this.getDhcpIp() + ", serverType=" + this.getServerType() + ", serverMac=" + this.getServerMac() + ", serverStackId=" + this.getServerStackId() + ", confirmConflict=" + this.getConfirmConflict() + ")";
    }

    @Generated
    public OswIpSettingOpenApiVO(Integer mode, String ip, String gateway, String netmask, String preDns, String secDns, Boolean fallback, String fallbackIp, String fallbackMask, String fallbackGate, String option12, Boolean useFixedAddr, String netId, String dhcpIp, String serverType, String serverMac, String serverStackId, Boolean confirmConflict) {
        this.mode = mode;
        this.ip = ip;
        this.gateway = gateway;
        this.netmask = netmask;
        this.preDns = preDns;
        this.secDns = secDns;
        this.fallback = fallback;
        this.fallbackIp = fallbackIp;
        this.fallbackMask = fallbackMask;
        this.fallbackGate = fallbackGate;
        this.option12 = option12;
        this.useFixedAddr = useFixedAddr;
        this.netId = netId;
        this.dhcpIp = dhcpIp;
        this.serverType = serverType;
        this.serverMac = serverMac;
        this.serverStackId = serverStackId;
        this.confirmConflict = confirmConflict;
    }

    @Generated
    public OswIpSettingOpenApiVO() {
    }
}

