/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.sdm.OswSdmTemplateVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="SwitchGeneralConfig", description="After the device is added to the stack group, the interface can only modify the device name.")
public class OswGeneralConfigOpenApiVO {
    @Schema(name="name", description="Device name should contain 1 to 128 characters.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="ledSetting", description="Led setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings")
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    @Schema(name="tagIds", description="Tag IDs")
    private List<String> tagIds;
    @Schema(name="location", description="Device location")
    @Valid
    private DeviceLocationDetailVO location;
    @Schema(name="jumbo", description="It should be within the range of 1518\u20139216 Bytes.")
    @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.")
    private @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.") Integer jumbo;
    @Schema(name="lagHashAlg", description="It should be a value as follows: 0: SRC MAC; 1: DST MAC; 2: SRC MAC + DST MAC; 3: SRC IP; 4: DST IP; 5: SRC IP + DST IP")
    @NumberSet(value={0, 1, 2, 3, 4, 5}, message="Controller does't support this value.")
    private Integer lagHashAlg;
    @Schema(name="sdm", description="Sdm template")
    @Valid
    private OswSdmTemplateVO sdm;

    public static OswGeneralConfigOpenApiVO buildFromOswDetailVO(OswDetailVO vo) {
        OswGeneralConfigOpenApiVO res = new OswGeneralConfigOpenApiVO();
        if (vo == null) {
            return res;
        }
        res.setName(vo.getName());
        res.setLedSetting(vo.getLedSetting());
        res.setTagIds(vo.getTagIds());
        res.setLocation(vo.getLocation());
        res.setJumbo(vo.getJumbo());
        res.setLagHashAlg(vo.getLagHashAlg());
        res.setSdm(OswGeneralConfigOpenApiVO.buildSdmOpenApiVO(vo.getSdm()));
        return res;
    }

    private static OswSdmTemplateVO buildSdmOpenApiVO(OswSdmTemplateVO vo) {
        if (vo == null || CollectionUtils.isEmpty((Collection)vo.getTemplates())) {
            return vo;
        }
        Integer ouiBasedVlanCategory = 2;
        vo.getTemplates().forEach(oswSdmBriefVO -> {
            if (CollectionUtils.isEmpty((Collection)oswSdmBriefVO.getApps())) {
                return;
            }
            oswSdmBriefVO.getApps().removeIf(appVO -> Objects.equals(ouiBasedVlanCategory, appVO.getCategory()));
        });
        return vo;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Generated
    public Integer getJumbo() {
        return this.jumbo;
    }

    @Generated
    public Integer getLagHashAlg() {
        return this.lagHashAlg;
    }

    @Generated
    public OswSdmTemplateVO getSdm() {
        return this.sdm;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setJumbo(Integer jumbo) {
        this.jumbo = jumbo;
    }

    @Generated
    public void setLagHashAlg(Integer lagHashAlg) {
        this.lagHashAlg = lagHashAlg;
    }

    @Generated
    public void setSdm(OswSdmTemplateVO sdm) {
        this.sdm = sdm;
    }

    @Generated
    public String toString() {
        return "OswGeneralConfigOpenApiVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", tagIds=" + this.getTagIds() + ", location=" + this.getLocation() + ", jumbo=" + this.getJumbo() + ", lagHashAlg=" + this.getLagHashAlg() + ", sdm=" + this.getSdm() + ")";
    }
}

