/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.site.sitesetting.OswDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswDhcpServerRangeOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswDhcpServerOpenApiVO")
public class OswDhcpServerOpenApiVO {
    @NotNull(message="Parameter [ip] should not be null.")
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] should be a valid IP address.")
    @Schema(name="ip", description="DHCP Server IP, like 192.168.0.1.")
    private @NotNull(message="Parameter [ip] should not be null.") @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [ip] should be a valid IP address.") String ip;
    @NotNull(message="Parameter [netmask] should not be null.")
    @Range(min=1L, max=30L, message="Parameter [netmask] should not within the range of 1-30")
    @Schema(name="netmask", description="Parameter [netmask] should not within the range of 1-30")
    private @NotNull(message="Parameter [netmask] should not be null.") @Range(min=1L, max=30L, message="Parameter [netmask] should not within the range of 1-30") String netmask;
    @Valid
    @Schema(name="ipRangePool", description="The list of DHCP Range")
    private List<OswDhcpServerRangeOpenApiVO> range;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [priDns] should be a valid DNS address.")
    @Schema(name="priDns", description="Primary DNS, like 192.0.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [priDns] should be a valid DNS address.") String priDns;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [sndDns] should be a valid DNS address.")
    @Schema(name="sndDns", description="Second DNS, like 8.8.8.8")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [sndDns] should be a valid DNS address.") String sndDns;
    @NotNull(message="Parameter [leasetime] should not be null.")
    @Range(min=2L, max=2880L, message="Lease time should be within the range of 2\u20132880")
    @Schema(name="leasetime", description="Lease time should be within the range of 2\u20132880")
    private @NotNull(message="Parameter [leasetime] should not be null.") @Range(min=2L, max=2880L, message="Lease time should be within the range of 2\u20132880") Integer leasetime;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [gateway] should be a valid IP address.")
    @Schema(name="gateway", description="Gateway IP, like 192.168.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [gateway] should be a valid IP address.") String gateway;
    @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [option138] should be a valid IP address.")
    @Schema(name="option138", description="option138 ip, like 192.168.0.1")
    private @Pattern(regexp="\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Parameter [option138] should be a valid IP address.") String option138;
    @Size(max=256)
    @Valid
    @Schema(name="options", description="Custom DHCP options.")
    private @Size(max=256) @Valid List<OswDhcpOptionOpenApiVO> options;
    @Schema(description="VRF ID")
    private String vrfId;

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getNetmask() {
        return this.netmask;
    }

    @Generated
    public List<OswDhcpServerRangeOpenApiVO> getRange() {
        return this.range;
    }

    @Generated
    public String getPriDns() {
        return this.priDns;
    }

    @Generated
    public String getSndDns() {
        return this.sndDns;
    }

    @Generated
    public Integer getLeasetime() {
        return this.leasetime;
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public String getOption138() {
        return this.option138;
    }

    @Generated
    public List<OswDhcpOptionOpenApiVO> getOptions() {
        return this.options;
    }

    @Generated
    public String getVrfId() {
        return this.vrfId;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    @Generated
    public void setRange(List<OswDhcpServerRangeOpenApiVO> range) {
        this.range = range;
    }

    @Generated
    public void setPriDns(String priDns) {
        this.priDns = priDns;
    }

    @Generated
    public void setSndDns(String sndDns) {
        this.sndDns = sndDns;
    }

    @Generated
    public void setLeasetime(Integer leasetime) {
        this.leasetime = leasetime;
    }

    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @Generated
    public void setOption138(String option138) {
        this.option138 = option138;
    }

    @Generated
    public void setOptions(List<OswDhcpOptionOpenApiVO> options) {
        this.options = options;
    }

    @Generated
    public void setVrfId(String vrfId) {
        this.vrfId = vrfId;
    }

    @Generated
    public String toString() {
        return "OswDhcpServerOpenApiVO(ip=" + this.getIp() + ", netmask=" + this.getNetmask() + ", range=" + this.getRange() + ", priDns=" + this.getPriDns() + ", sndDns=" + this.getSndDns() + ", leasetime=" + this.getLeasetime() + ", gateway=" + this.getGateway() + ", option138=" + this.getOption138() + ", options=" + this.getOptions() + ", vrfId=" + this.getVrfId() + ")";
    }

    @Generated
    public OswDhcpServerOpenApiVO(String ip, String netmask, List<OswDhcpServerRangeOpenApiVO> range, String priDns, String sndDns, Integer leasetime, String gateway, String option138, List<OswDhcpOptionOpenApiVO> options, String vrfId) {
        this.ip = ip;
        this.netmask = netmask;
        this.range = range;
        this.priDns = priDns;
        this.sndDns = sndDns;
        this.leasetime = leasetime;
        this.gateway = gateway;
        this.option138 = option138;
        this.options = options;
        this.vrfId = vrfId;
    }

    @Generated
    public OswDhcpServerOpenApiVO() {
    }
}

