/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.device.api.web.osw.dto.DDMInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="OswDDMInfoOpenApiVO")
public class OswDDMInfoOpenApiVO {
    @Schema(name="port", description="Switch portId.")
    private Integer port;
    @Schema(name="standardPort", description="Switch stack portId(unit/slot/port).")
    private String standardPort;
    @Schema(name="rxPower", description="The received optical power of the optical module.")
    private Double rxPower;
    @Schema(name="biasCurrent", description="The biasCurrent of the optical module.")
    private Double biasCurrent;
    @Schema(name="dataReady", description="Whether the DDM data is valid.")
    private Integer dataReady;
    @Schema(name="voltage", description="The voltage of the optical module.")
    private Double voltage;
    @Schema(name="transmitFault", description="The transmission fault of the optical module.")
    private Integer transmitFault;
    @Schema(name="txPower", description="The transmitted optical power of the optical module.")
    private Double txPower;
    @Schema(name="lossOfSignal", description="The Loss Of Signal(LOS) of the optical module.")
    private Integer lossOfSignal;
    @Schema(name="temperature", description="The temperature of the optical module.")
    private Double temperature;

    public static List<OswDDMInfoOpenApiVO> getPortListFromVO(DDMInfoVO vo) {
        if (vo == null || CollectionUtils.isEmpty((Collection)vo.getPorts())) {
            return Collections.emptyList();
        }
        ArrayList<OswDDMInfoOpenApiVO> portDDMInfoOpenApiVOs = new ArrayList<OswDDMInfoOpenApiVO>();
        vo.getPorts().forEach(portDDMInfoVO -> {
            OswDDMInfoOpenApiVO portDDMInfoDTO = new OswDDMInfoOpenApiVO();
            portDDMInfoDTO.setPort(portDDMInfoVO.getPort());
            portDDMInfoDTO.setStandardPort(portDDMInfoVO.getStandardPort());
            portDDMInfoDTO.setRxPower(Optional.ofNullable(portDDMInfoVO.getRx()).map(DDMInfoVO.RxPowerInfoVO::getRxAc).orElse(null));
            portDDMInfoDTO.setBiasCurrent(Optional.ofNullable(portDDMInfoVO.getBc()).map(DDMInfoVO.BiasCurrentInfoVO::getBcAc).orElse(null));
            portDDMInfoDTO.setDataReady(portDDMInfoVO.getRd());
            portDDMInfoDTO.setVoltage(Optional.ofNullable(portDDMInfoVO.getVol()).map(DDMInfoVO.VoltageInfoVO::getVolAc).orElse(null));
            portDDMInfoDTO.setTransmitFault(portDDMInfoVO.getTxFault());
            portDDMInfoDTO.setTxPower(Optional.ofNullable(portDDMInfoVO.getTx()).map(DDMInfoVO.TxPowerInfoVO::getTxAc).orElse(null));
            portDDMInfoDTO.setLossOfSignal(portDDMInfoVO.getRxLos());
            portDDMInfoDTO.setTemperature(Optional.ofNullable(portDDMInfoVO.getTem()).map(DDMInfoVO.TemperatureInfoVO::getTemAc).orElse(null));
            portDDMInfoOpenApiVOs.add(portDDMInfoDTO);
        });
        return portDDMInfoOpenApiVOs;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getStandardPort() {
        return this.standardPort;
    }

    @Generated
    public Double getRxPower() {
        return this.rxPower;
    }

    @Generated
    public Double getBiasCurrent() {
        return this.biasCurrent;
    }

    @Generated
    public Integer getDataReady() {
        return this.dataReady;
    }

    @Generated
    public Double getVoltage() {
        return this.voltage;
    }

    @Generated
    public Integer getTransmitFault() {
        return this.transmitFault;
    }

    @Generated
    public Double getTxPower() {
        return this.txPower;
    }

    @Generated
    public Integer getLossOfSignal() {
        return this.lossOfSignal;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setStandardPort(String standardPort) {
        this.standardPort = standardPort;
    }

    @Generated
    public void setRxPower(Double rxPower) {
        this.rxPower = rxPower;
    }

    @Generated
    public void setBiasCurrent(Double biasCurrent) {
        this.biasCurrent = biasCurrent;
    }

    @Generated
    public void setDataReady(Integer dataReady) {
        this.dataReady = dataReady;
    }

    @Generated
    public void setVoltage(Double voltage) {
        this.voltage = voltage;
    }

    @Generated
    public void setTransmitFault(Integer transmitFault) {
        this.transmitFault = transmitFault;
    }

    @Generated
    public void setTxPower(Double txPower) {
        this.txPower = txPower;
    }

    @Generated
    public void setLossOfSignal(Integer lossOfSignal) {
        this.lossOfSignal = lossOfSignal;
    }

    @Generated
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OswDDMInfoOpenApiVO)) {
            return false;
        }
        OswDDMInfoOpenApiVO other = (OswDDMInfoOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Double this$rxPower = this.getRxPower();
        Double other$rxPower = other.getRxPower();
        if (this$rxPower == null ? other$rxPower != null : !((Object)this$rxPower).equals(other$rxPower)) {
            return false;
        }
        Double this$biasCurrent = this.getBiasCurrent();
        Double other$biasCurrent = other.getBiasCurrent();
        if (this$biasCurrent == null ? other$biasCurrent != null : !((Object)this$biasCurrent).equals(other$biasCurrent)) {
            return false;
        }
        Integer this$dataReady = this.getDataReady();
        Integer other$dataReady = other.getDataReady();
        if (this$dataReady == null ? other$dataReady != null : !((Object)this$dataReady).equals(other$dataReady)) {
            return false;
        }
        Double this$voltage = this.getVoltage();
        Double other$voltage = other.getVoltage();
        if (this$voltage == null ? other$voltage != null : !((Object)this$voltage).equals(other$voltage)) {
            return false;
        }
        Integer this$transmitFault = this.getTransmitFault();
        Integer other$transmitFault = other.getTransmitFault();
        if (this$transmitFault == null ? other$transmitFault != null : !((Object)this$transmitFault).equals(other$transmitFault)) {
            return false;
        }
        Double this$txPower = this.getTxPower();
        Double other$txPower = other.getTxPower();
        if (this$txPower == null ? other$txPower != null : !((Object)this$txPower).equals(other$txPower)) {
            return false;
        }
        Integer this$lossOfSignal = this.getLossOfSignal();
        Integer other$lossOfSignal = other.getLossOfSignal();
        if (this$lossOfSignal == null ? other$lossOfSignal != null : !((Object)this$lossOfSignal).equals(other$lossOfSignal)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        String this$standardPort = this.getStandardPort();
        String other$standardPort = other.getStandardPort();
        return !(this$standardPort == null ? other$standardPort != null : !this$standardPort.equals(other$standardPort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswDDMInfoOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Double $rxPower = this.getRxPower();
        result = result * 59 + ($rxPower == null ? 43 : ((Object)$rxPower).hashCode());
        Double $biasCurrent = this.getBiasCurrent();
        result = result * 59 + ($biasCurrent == null ? 43 : ((Object)$biasCurrent).hashCode());
        Integer $dataReady = this.getDataReady();
        result = result * 59 + ($dataReady == null ? 43 : ((Object)$dataReady).hashCode());
        Double $voltage = this.getVoltage();
        result = result * 59 + ($voltage == null ? 43 : ((Object)$voltage).hashCode());
        Integer $transmitFault = this.getTransmitFault();
        result = result * 59 + ($transmitFault == null ? 43 : ((Object)$transmitFault).hashCode());
        Double $txPower = this.getTxPower();
        result = result * 59 + ($txPower == null ? 43 : ((Object)$txPower).hashCode());
        Integer $lossOfSignal = this.getLossOfSignal();
        result = result * 59 + ($lossOfSignal == null ? 43 : ((Object)$lossOfSignal).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        String $standardPort = this.getStandardPort();
        result = result * 59 + ($standardPort == null ? 43 : $standardPort.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswDDMInfoOpenApiVO(port=" + this.getPort() + ", standardPort=" + this.getStandardPort() + ", rxPower=" + this.getRxPower() + ", biasCurrent=" + this.getBiasCurrent() + ", dataReady=" + this.getDataReady() + ", voltage=" + this.getVoltage() + ", transmitFault=" + this.getTransmitFault() + ", txPower=" + this.getTxPower() + ", lossOfSignal=" + this.getLossOfSignal() + ", temperature=" + this.getTemperature() + ")";
    }

    @Generated
    public OswDDMInfoOpenApiVO() {
    }

    @Generated
    public OswDDMInfoOpenApiVO(Integer port, String standardPort, Double rxPower, Double biasCurrent, Integer dataReady, Double voltage, Integer transmitFault, Double txPower, Integer lossOfSignal, Double temperature) {
        this.port = port;
        this.standardPort = standardPort;
        this.rxPower = rxPower;
        this.biasCurrent = biasCurrent;
        this.dataReady = dataReady;
        this.voltage = voltage;
        this.transmitFault = transmitFault;
        this.txPower = txPower;
        this.lossOfSignal = lossOfSignal;
        this.temperature = temperature;
    }
}

