/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswBriefPortInfoOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswCableTestLogVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Schema(name="OswCableTestLogOpenApiVO")
public class OswCableTestLogOpenApiVO {
    @Schema(name="type", description="Log type. It should be a value as follows: 0:start test. 1: test done. 2:test interrupts 3:time out")
    private Integer type;
    @Schema(name="timeStamp", description="Timestamp of the log")
    private Long timestamp;
    @Schema(name="testPortList", description="All test port. Used for type 0")
    private List<OswBriefPortInfoOpenApiVO> testPortList;
    @Schema(name="completePortList", description="Ports that have been tested completely. Used for type 1,2,3")
    private List<OswBriefPortInfoOpenApiVO> completePortList;
    @Schema(name="cancelPortList", description="Ports that were not detected due to cancel. Used for type 2")
    private List<OswBriefPortInfoOpenApiVO> cancelPortList;
    @Schema(name="timeoutPortList", description="Timeout ports. Used for type 3")
    private List<OswBriefPortInfoOpenApiVO> timeoutPortList;

    public static OswCableTestLogOpenApiVO buildByWebVO(OswCableTestLogVO vo) {
        OswCableTestLogOpenApiVO openApiVO = new OswCableTestLogOpenApiVO();
        if (vo == null) {
            return openApiVO;
        }
        openApiVO.setType(vo.getType());
        openApiVO.setTimestamp(vo.getTimestamp());
        Optional.ofNullable(vo.getTestPortList()).ifPresent(testPortList -> openApiVO.setTestPortList(OswBriefPortInfoOpenApiVO.buildListByPortList(testPortList)));
        Optional.ofNullable(vo.getCompletePortList()).ifPresent(testPortList -> openApiVO.setCompletePortList(OswBriefPortInfoOpenApiVO.buildListByPortList(testPortList)));
        Optional.ofNullable(vo.getCancelPortList()).ifPresent(testPortList -> openApiVO.setCancelPortList(OswBriefPortInfoOpenApiVO.buildListByPortList(testPortList)));
        Optional.ofNullable(vo.getTimeoutPortList()).ifPresent(testPortList -> openApiVO.setTimeoutPortList(OswBriefPortInfoOpenApiVO.buildListByPortList(testPortList)));
        return openApiVO;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public List<OswBriefPortInfoOpenApiVO> getTestPortList() {
        return this.testPortList;
    }

    @Generated
    public List<OswBriefPortInfoOpenApiVO> getCompletePortList() {
        return this.completePortList;
    }

    @Generated
    public List<OswBriefPortInfoOpenApiVO> getCancelPortList() {
        return this.cancelPortList;
    }

    @Generated
    public List<OswBriefPortInfoOpenApiVO> getTimeoutPortList() {
        return this.timeoutPortList;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setTestPortList(List<OswBriefPortInfoOpenApiVO> testPortList) {
        this.testPortList = testPortList;
    }

    @Generated
    public void setCompletePortList(List<OswBriefPortInfoOpenApiVO> completePortList) {
        this.completePortList = completePortList;
    }

    @Generated
    public void setCancelPortList(List<OswBriefPortInfoOpenApiVO> cancelPortList) {
        this.cancelPortList = cancelPortList;
    }

    @Generated
    public void setTimeoutPortList(List<OswBriefPortInfoOpenApiVO> timeoutPortList) {
        this.timeoutPortList = timeoutPortList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OswCableTestLogOpenApiVO)) {
            return false;
        }
        OswCableTestLogOpenApiVO other = (OswCableTestLogOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        List<OswBriefPortInfoOpenApiVO> this$testPortList = this.getTestPortList();
        List<OswBriefPortInfoOpenApiVO> other$testPortList = other.getTestPortList();
        if (this$testPortList == null ? other$testPortList != null : !((Object)this$testPortList).equals(other$testPortList)) {
            return false;
        }
        List<OswBriefPortInfoOpenApiVO> this$completePortList = this.getCompletePortList();
        List<OswBriefPortInfoOpenApiVO> other$completePortList = other.getCompletePortList();
        if (this$completePortList == null ? other$completePortList != null : !((Object)this$completePortList).equals(other$completePortList)) {
            return false;
        }
        List<OswBriefPortInfoOpenApiVO> this$cancelPortList = this.getCancelPortList();
        List<OswBriefPortInfoOpenApiVO> other$cancelPortList = other.getCancelPortList();
        if (this$cancelPortList == null ? other$cancelPortList != null : !((Object)this$cancelPortList).equals(other$cancelPortList)) {
            return false;
        }
        List<OswBriefPortInfoOpenApiVO> this$timeoutPortList = this.getTimeoutPortList();
        List<OswBriefPortInfoOpenApiVO> other$timeoutPortList = other.getTimeoutPortList();
        return !(this$timeoutPortList == null ? other$timeoutPortList != null : !((Object)this$timeoutPortList).equals(other$timeoutPortList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswCableTestLogOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        List<OswBriefPortInfoOpenApiVO> $testPortList = this.getTestPortList();
        result = result * 59 + ($testPortList == null ? 43 : ((Object)$testPortList).hashCode());
        List<OswBriefPortInfoOpenApiVO> $completePortList = this.getCompletePortList();
        result = result * 59 + ($completePortList == null ? 43 : ((Object)$completePortList).hashCode());
        List<OswBriefPortInfoOpenApiVO> $cancelPortList = this.getCancelPortList();
        result = result * 59 + ($cancelPortList == null ? 43 : ((Object)$cancelPortList).hashCode());
        List<OswBriefPortInfoOpenApiVO> $timeoutPortList = this.getTimeoutPortList();
        result = result * 59 + ($timeoutPortList == null ? 43 : ((Object)$timeoutPortList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswCableTestLogOpenApiVO(type=" + this.getType() + ", timestamp=" + this.getTimestamp() + ", testPortList=" + this.getTestPortList() + ", completePortList=" + this.getCompletePortList() + ", cancelPortList=" + this.getCancelPortList() + ", timeoutPortList=" + this.getTimeoutPortList() + ")";
    }

    @Generated
    public OswCableTestLogOpenApiVO() {
    }

    @Generated
    public OswCableTestLogOpenApiVO(Integer type, Long timestamp, List<OswBriefPortInfoOpenApiVO> testPortList, List<OswBriefPortInfoOpenApiVO> completePortList, List<OswBriefPortInfoOpenApiVO> cancelPortList, List<OswBriefPortInfoOpenApiVO> timeoutPortList) {
        this.type = type;
        this.timestamp = timestamp;
        this.testPortList = testPortList;
        this.completePortList = completePortList;
        this.cancelPortList = cancelPortList;
        this.timeoutPortList = timeoutPortList;
    }
}

