/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;

@Schema(name="EasyManagedSwitchGeneralConfig")
public class ESGeneralConfigOpenApiVO {
    @Schema(name="name", description="Device name should contain 1 to 32 characters.")
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,30}[^ ]$", message="Parameter [name] should be 1 ~ 32 characters")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,30}[^ ]$", message="Parameter [name] should be 1 ~ 32 characters") String name;
    @Schema(name="ledSetting", description="LED setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings")
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    private Integer ledSetting;
    @Schema(name="tagIds", description="Tag IDs")
    private List<String> tagIds;
    @Schema(name="jumboEnable", description="Parameter [jumboEnable] should be true or false.")
    private Boolean jumboEnable;
    @Schema(name="location", description="Device location")
    @Valid
    private DeviceLocationDetailVO location;
    @Schema(name="remember", description="Parameter [remember] should be true or false.")
    private Boolean remember;
    @Schema(name="powerAlertEnable", description="Power alert status.")
    private Boolean powerAlertEnable;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Boolean getJumboEnable() {
        return this.jumboEnable;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Generated
    public Boolean getRemember() {
        return this.remember;
    }

    @Generated
    public Boolean getPowerAlertEnable() {
        return this.powerAlertEnable;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setJumboEnable(Boolean jumboEnable) {
        this.jumboEnable = jumboEnable;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    @Generated
    public void setPowerAlertEnable(Boolean powerAlertEnable) {
        this.powerAlertEnable = powerAlertEnable;
    }

    @Generated
    public String toString() {
        return "ESGeneralConfigOpenApiVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", tagIds=" + this.getTagIds() + ", jumboEnable=" + this.getJumboEnable() + ", location=" + this.getLocation() + ", remember=" + this.getRemember() + ", powerAlertEnable=" + this.getPowerAlertEnable() + ")";
    }
}

