/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.stack.vo;

import com.tplink.smb.omada.common.cache.a.a.a;
import com.tplink.smb.omada.common.cache.a.a.c;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackMemberVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OswStackConfigOpenApiVO {
    @NotNull(message="Stack name should not be null.")
    @a(a="name", d=true)
    @c(b="name")
    @Schema(name="name", description="Stack Name")
    private @NotNull(message="Stack name should not be null.") String name;
    @Valid
    @NotEmpty(message="Stack member list should not be null or empty")
    @Schema(name="member", description="Stack member list")
    private @Valid @NotEmpty(message="Stack member list should not be null or empty") List<OswStackMemberVO> member;

    @Nonnull
    public String acquireMasterMac() {
        return Optional.ofNullable(this.member).map(stackmembers -> stackmembers.stream().filter(stackMember -> com.tplink.smb.omada.manager.stack.api.internal.dto.a.a.a(stackMember.getMemberStatus())).map(OswStackMemberVO::getMac).findFirst().orElse("")).orElse("");
    }

    public static OswStackVO toWebVO(OswStackConfigOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        OswStackVO webVO = new OswStackVO();
        webVO.setName(openApiVO.getName());
        webVO.setMember(CollectionUtils.isEmpty(openApiVO.getMember()) ? new ArrayList() : openApiVO.getMember());
        webVO.setMacDelay(null);
        return webVO;
    }

    public static OswStackConfigOpenApiVO buildByWebVO(OswStackVO webVO) {
        if (Objects.isNull(webVO)) {
            return null;
        }
        OswStackConfigOpenApiVO openApiVO = new OswStackConfigOpenApiVO();
        openApiVO.setName(webVO.getName());
        openApiVO.setMember(CollectionUtils.isEmpty((Collection)webVO.getMember()) ? new ArrayList() : webVO.getMember());
        return openApiVO;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<OswStackMemberVO> getMember() {
        return this.member;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMember(List<OswStackMemberVO> member) {
        this.member = member;
    }

    @Generated
    public OswStackConfigOpenApiVO() {
    }

    @Generated
    public OswStackConfigOpenApiVO(String name, List<OswStackMemberVO> member) {
        this.name = name;
        this.member = member;
    }
}

