/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.stack;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.switchsetting.OswStormCtrlOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswBandCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswLagBasicVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortDhcpL2RelayVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortStackSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.StackPortSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswPortSettingOpenApiVO")
public class OswStackPortSettingOpenApiVO {
    @Schema(name="mac", description="The device mac to which the port belongs")
    @a
    private String mac;
    @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters")
    @Schema(name="name", description="Port name")
    private @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="profileId", description="Lan Profile ID")
    private String profileId;
    @NotNull(message="Parameter [profileOverrideEnable] must not be null.")
    @Schema(name="profileOverrideEnable", description="Indicates whether to enable Profile Override")
    private @NotNull(message="Parameter [profileOverrideEnable] must not be null.") Boolean profileOverrideEnable;
    @Pattern(regexp="switching|mirroring|aggregating", message="PortSetting parameter [operation] should be \"switching\" or \"mirroring\" or \" \"aggregating")
    @Schema(name="operation", description="Operation should be a value as follows: SWITCHING; MIRRORING; AGGREGATING")
    private @Pattern(regexp="switching|mirroring|aggregating", message="PortSetting parameter [operation] should be \"switching\" or \"mirroring\" or \" \"aggregating") String operation;
    @Schema(name="mirroredPorts", description="Monitored Port")
    private Set<Integer> mirroredPorts;
    @Schema(name="mirroredLags", description="Monitored LAG")
    private Set<Integer> mirroredLags;
    @Valid
    @Schema(name="lagSetting", description="Basic configuration of the LAG to which the current port belongs")
    private OswLagBasicVO lagSetting;
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, message="PortSetting parameter [linkSpeed] should be [0, 1, 2, 3, 4, 5,6,7,8,9]")
    @Schema(name="linkSpeed", description="LinkSpeed should be a value as follows: 0: Auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2500M; 5: 10G; 6: 5G; 7: 25G; 8: 100G; 9: 40G.")
    private Integer linkSpeed;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [duplex] should be 0 or 1 or 2")
    @Schema(name="duplex", description="Duplex should be a value as follows: 0: Auto; 1: Half; 2: Full")
    private Integer duplex;
    @Schema(name="dot1x", description="Dot1x should be a value as follows: 0: Force unauthorized; 1: Force authorized; 2: Auto")
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [dot1x] should be 0 or 1 or 2")
    private Integer dot1x;
    @NumberSet(value={0, 1}, message="PortSetting parameter [poe] should be 0 or 1")
    @Schema(name="poe", description="PoE switch should be a value as follows: 0: Off; 1: 802.3at/af")
    private Integer poe;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [bandWidthCtrlType] should be 0, 1, 2")
    @Schema(name="bandWidthCtrlType", description="BandWidthCtrlType should be a value as follows: 0: Off; 1: Rate Limit; 2: Storming Control")
    private Integer bandWidthCtrlType;
    @Valid
    @Schema(name="bandCtrl", description="Speed Limit")
    private OswBandCtrlVO bandCtrl;
    @Valid
    @Schema(name="stormCtrl", description="Storm Control")
    private OswStormCtrlOpenApiVO stormCtrl;
    @Schema(name="lldpMedEnable", description="LLDP-MED enable status")
    private Boolean lldpMedEnable;
    @Schema(name="topoNotifyEnable", description="TopoNotify enable status")
    private Boolean topoNotifyEnable;
    @Schema(name="spanningTreeEnable", description="SpanningTree enable status")
    private Boolean spanningTreeEnable;
    @Valid
    @Schema(name="spanningTreeSetting", description="SpanningTree Setting")
    private SpanningTreeSettingVO spanningTreeSetting;
    @Schema(name="loopbackDetectEnable", description="LoopbackDetect enable status")
    private Boolean loopbackDetectEnable;
    @Schema(name="loopbackDetectVlanBasedEnable", description="LoopbackDetectVLANBased enable status")
    private Boolean loopbackDetectVlanBasedEnable;
    @Schema(name="igmpFastLeaveEnable", description="Indicates whether igmp fast leave is enabled")
    private Boolean igmpFastLeaveEnable;
    @Schema(name="mldFastLeaveEnable", description="Indicates whether mld fast leave is enabled")
    private Boolean mldFastLeaveEnable;
    @Schema(name="portIsolationEnable", description="Port-isolation enable status")
    private Boolean portIsolationEnable;
    @Schema(name="eeeEnable", description="EEE enable status")
    private Boolean eeeEnable;
    @Schema(name="flowControlEnable", description="FlowControl enable status")
    private Boolean flowControlEnable;
    @Schema(name="fastLeaveEnable", description="Indicates whether igmpSnooping fastLeave is enabled")
    private Boolean fastLeaveEnable;
    @Valid
    @Schema(name="dhcpL2RelaySettings", description="Dhcp L2 Relay Setting")
    private OswPortDhcpL2RelayVO dhcpL2RelaySettings;
    @Valid
    @Schema(name="stackSetting", description="Port Stack Setting")
    private OswPortStackSettingVO stackSetting;
    @Range(min=0L, max=7L, message="Switch qos parameter [dot1pPriority] should between 0 and 7")
    @Schema(name="dot1pPriority", description="Dot1p Priority")
    private @Range(min=0L, max=7L, message="Switch qos parameter [dot1pPriority] should between 0 and 7") Integer dot1pPriority;
    @Schema(name="trustMode", description="TrustMode should be a value as follows: 0: Untrusted; 1: Trust 802.1p; 2: Trust DSCP")
    @NumberSet(value={0, 1, 2}, message="Switch qos parameter [trustMode] should between 0 and 2")
    private Integer trustMode;

    public static StackPortSettingVO buildWebVO(OswStackPortSettingOpenApiVO openApiVO) {
        StackPortSettingVO vo = new StackPortSettingVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setMac(openApiVO.getMac());
        vo.setStackSetting(openApiVO.getStackSetting());
        vo.setName(openApiVO.getName());
        vo.setProfileId(openApiVO.getProfileId());
        vo.setProfileOverrideEnable(openApiVO.getProfileOverrideEnable());
        vo.setOperation(openApiVO.getOperation());
        vo.setPoe(openApiVO.getPoe());
        vo.setDot1x(openApiVO.getDot1x());
        vo.setLinkSpeed(openApiVO.getLinkSpeed());
        vo.setDuplex(openApiVO.getDuplex());
        vo.setPortIsolationEnable(openApiVO.getPortIsolationEnable());
        vo.setSpanningTreeEnable(openApiVO.getSpanningTreeEnable());
        vo.setSpanningTreeSetting(openApiVO.getSpanningTreeSetting());
        vo.setLoopbackDetectEnable(openApiVO.getLoopbackDetectEnable());
        vo.setLoopbackDetectVlanBasedEnable(openApiVO.getLoopbackDetectVlanBasedEnable());
        vo.setIgmpFastLeaveEnable(openApiVO.getIgmpFastLeaveEnable());
        vo.setMldFastLeaveEnable(openApiVO.getMldFastLeaveEnable());
        vo.setTopoNotifyEnable(openApiVO.getTopoNotifyEnable());
        vo.setBandWidthCtrlType(openApiVO.getBandWidthCtrlType());
        vo.setLldpMedEnable(openApiVO.getLldpMedEnable());
        vo.setStormCtrl(OswStormCtrlOpenApiVO.toOswStormCtrlVO(openApiVO.getStormCtrl()));
        vo.setBandCtrl(openApiVO.getBandCtrl());
        vo.setEeeEnable(openApiVO.getEeeEnable());
        vo.setFlowControlEnable(openApiVO.getFlowControlEnable());
        vo.setFastLeaveEnable(openApiVO.getFastLeaveEnable());
        vo.setDhcpL2RelaySettings(openApiVO.getDhcpL2RelaySettings());
        vo.setDot1pPriority(openApiVO.getDot1pPriority());
        vo.setTrustMode(openApiVO.getTrustMode());
        vo.setMirroredPorts(openApiVO.getMirroredPorts());
        vo.setMirroredLags(openApiVO.getMirroredLags());
        vo.setLagSetting(openApiVO.getLagSetting());
        return vo;
    }

    public OperationResponse checkValidation() {
        OperationResponse bandCtrlCheck = this.bandCtrlValid();
        if (!bandCtrlCheck.success()) {
            return bandCtrlCheck;
        }
        OperationResponse stpCheck = this.stpValid();
        if (!stpCheck.success()) {
            return stpCheck;
        }
        OperationResponse stromCtrlCheck = this.stormCtrlValid();
        if (!stromCtrlCheck.success()) {
            return stromCtrlCheck;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse stormCtrlValid() {
        if (this.getStormCtrl() == null) {
            return OperationResponse.SUCCESS;
        }
        OswStormCtrlOpenApiVO stormCtrlOpenApiVO = this.getStormCtrl();
        if (Objects.equals(stormCtrlOpenApiVO.getAction(), 1) && stormCtrlOpenApiVO.getRecoverTime() == null) {
            return new OperationResponse(b.d, "StormCtrl parameter [recoverTime] should not be null", null);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse stpValid() {
        Integer priority;
        if (this.getSpanningTreeSetting() == null) {
            return OperationResponse.SUCCESS;
        }
        SpanningTreeSettingVO spanningTreeSetting = this.getSpanningTreeSetting();
        if (spanningTreeSetting.getPriority() != null && (priority = spanningTreeSetting.getPriority()) % 16 != 0) {
            return new OperationResponse(b.d, "Priority should be a multiple of 16", null);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse bandCtrlValid() {
        if (this.getBandCtrl() == null) {
            return OperationResponse.SUCCESS;
        }
        OswBandCtrlVO bandCtrl = this.getBandCtrl();
        if (Boolean.TRUE.equals(bandCtrl.getEgressEnable()) && bandCtrl.getEgressUnit() == null) {
            return new OperationResponse(b.d, "bandCtrl parameter [egressUnit] should not be null", null);
        }
        if (Boolean.TRUE.equals(bandCtrl.getIngressEnable()) && bandCtrl.getIngressUnit() == null) {
            return new OperationResponse(b.d, "bandCtrl parameter [ingressUnit] should not be null", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    protected OswStackPortSettingOpenApiVO(OswStackPortSettingOpenApiVOBuilder<?, ?> b2) {
        this.mac = b2.mac;
        this.name = b2.name;
        this.profileId = b2.profileId;
        this.profileOverrideEnable = b2.profileOverrideEnable;
        this.operation = b2.operation;
        this.mirroredPorts = b2.mirroredPorts;
        this.mirroredLags = b2.mirroredLags;
        this.lagSetting = b2.lagSetting;
        this.linkSpeed = b2.linkSpeed;
        this.duplex = b2.duplex;
        this.dot1x = b2.dot1x;
        this.poe = b2.poe;
        this.bandWidthCtrlType = b2.bandWidthCtrlType;
        this.bandCtrl = b2.bandCtrl;
        this.stormCtrl = b2.stormCtrl;
        this.lldpMedEnable = b2.lldpMedEnable;
        this.topoNotifyEnable = b2.topoNotifyEnable;
        this.spanningTreeEnable = b2.spanningTreeEnable;
        this.spanningTreeSetting = b2.spanningTreeSetting;
        this.loopbackDetectEnable = b2.loopbackDetectEnable;
        this.loopbackDetectVlanBasedEnable = b2.loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = b2.igmpFastLeaveEnable;
        this.mldFastLeaveEnable = b2.mldFastLeaveEnable;
        this.portIsolationEnable = b2.portIsolationEnable;
        this.eeeEnable = b2.eeeEnable;
        this.flowControlEnable = b2.flowControlEnable;
        this.fastLeaveEnable = b2.fastLeaveEnable;
        this.dhcpL2RelaySettings = b2.dhcpL2RelaySettings;
        this.stackSetting = b2.stackSetting;
        this.dot1pPriority = b2.dot1pPriority;
        this.trustMode = b2.trustMode;
    }

    @Generated
    public static OswStackPortSettingOpenApiVOBuilder<?, ?> builder() {
        return new OswStackPortSettingOpenApiVOBuilderImpl();
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProfileId() {
        return this.profileId;
    }

    @Generated
    public Boolean getProfileOverrideEnable() {
        return this.profileOverrideEnable;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public Set<Integer> getMirroredPorts() {
        return this.mirroredPorts;
    }

    @Generated
    public Set<Integer> getMirroredLags() {
        return this.mirroredLags;
    }

    @Generated
    public OswLagBasicVO getLagSetting() {
        return this.lagSetting;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public OswBandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public OswStormCtrlOpenApiVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Boolean getTopoNotifyEnable() {
        return this.topoNotifyEnable;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public OswPortDhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Generated
    public OswPortStackSettingVO getStackSetting() {
        return this.stackSetting;
    }

    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    @Generated
    public void setProfileOverrideEnable(Boolean profileOverrideEnable) {
        this.profileOverrideEnable = profileOverrideEnable;
    }

    @Generated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Generated
    public void setMirroredPorts(Set<Integer> mirroredPorts) {
        this.mirroredPorts = mirroredPorts;
    }

    @Generated
    public void setMirroredLags(Set<Integer> mirroredLags) {
        this.mirroredLags = mirroredLags;
    }

    @Generated
    public void setLagSetting(OswLagBasicVO lagSetting) {
        this.lagSetting = lagSetting;
    }

    @Generated
    public void setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
    }

    @Generated
    public void setPoe(Integer poe) {
        this.poe = poe;
    }

    @Generated
    public void setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
    }

    @Generated
    public void setBandCtrl(OswBandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
    }

    @Generated
    public void setStormCtrl(OswStormCtrlOpenApiVO stormCtrl) {
        this.stormCtrl = stormCtrl;
    }

    @Generated
    public void setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
    }

    @Generated
    public void setTopoNotifyEnable(Boolean topoNotifyEnable) {
        this.topoNotifyEnable = topoNotifyEnable;
    }

    @Generated
    public void setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
    }

    @Generated
    public void setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
    }

    @Generated
    public void setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
    }

    @Generated
    public void setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
    }

    @Generated
    public void setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
    }

    @Generated
    public void setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
    }

    @Generated
    public void setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
    }

    @Generated
    public void setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
    }

    @Generated
    public void setDhcpL2RelaySettings(OswPortDhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
    }

    @Generated
    public void setStackSetting(OswPortStackSettingVO stackSetting) {
        this.stackSetting = stackSetting;
    }

    @Generated
    public void setDot1pPriority(Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
    }

    @Generated
    public void setTrustMode(Integer trustMode) {
        this.trustMode = trustMode;
    }

    @Generated
    public String toString() {
        return "OswStackPortSettingOpenApiVO(mac=" + this.getMac() + ", name=" + this.getName() + ", profileId=" + this.getProfileId() + ", profileOverrideEnable=" + this.getProfileOverrideEnable() + ", operation=" + this.getOperation() + ", mirroredPorts=" + this.getMirroredPorts() + ", mirroredLags=" + this.getMirroredLags() + ", lagSetting=" + this.getLagSetting() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", dot1x=" + this.getDot1x() + ", poe=" + this.getPoe() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", bandCtrl=" + this.getBandCtrl() + ", stormCtrl=" + this.getStormCtrl() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", topoNotifyEnable=" + this.getTopoNotifyEnable() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", stackSetting=" + this.getStackSetting() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ")";
    }

    @Generated
    public OswStackPortSettingOpenApiVO(String mac, String name, String profileId, Boolean profileOverrideEnable, String operation, Set<Integer> mirroredPorts, Set<Integer> mirroredLags, OswLagBasicVO lagSetting, Integer linkSpeed, Integer duplex, Integer dot1x, Integer poe, Integer bandWidthCtrlType, OswBandCtrlVO bandCtrl, OswStormCtrlOpenApiVO stormCtrl, Boolean lldpMedEnable, Boolean topoNotifyEnable, Boolean spanningTreeEnable, SpanningTreeSettingVO spanningTreeSetting, Boolean loopbackDetectEnable, Boolean loopbackDetectVlanBasedEnable, Boolean igmpFastLeaveEnable, Boolean mldFastLeaveEnable, Boolean portIsolationEnable, Boolean eeeEnable, Boolean flowControlEnable, Boolean fastLeaveEnable, OswPortDhcpL2RelayVO dhcpL2RelaySettings, OswPortStackSettingVO stackSetting, Integer dot1pPriority, Integer trustMode) {
        this.mac = mac;
        this.name = name;
        this.profileId = profileId;
        this.profileOverrideEnable = profileOverrideEnable;
        this.operation = operation;
        this.mirroredPorts = mirroredPorts;
        this.mirroredLags = mirroredLags;
        this.lagSetting = lagSetting;
        this.linkSpeed = linkSpeed;
        this.duplex = duplex;
        this.dot1x = dot1x;
        this.poe = poe;
        this.bandWidthCtrlType = bandWidthCtrlType;
        this.bandCtrl = bandCtrl;
        this.stormCtrl = stormCtrl;
        this.lldpMedEnable = lldpMedEnable;
        this.topoNotifyEnable = topoNotifyEnable;
        this.spanningTreeEnable = spanningTreeEnable;
        this.spanningTreeSetting = spanningTreeSetting;
        this.loopbackDetectEnable = loopbackDetectEnable;
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        this.portIsolationEnable = portIsolationEnable;
        this.eeeEnable = eeeEnable;
        this.flowControlEnable = flowControlEnable;
        this.fastLeaveEnable = fastLeaveEnable;
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        this.stackSetting = stackSetting;
        this.dot1pPriority = dot1pPriority;
        this.trustMode = trustMode;
    }

    @Generated
    public OswStackPortSettingOpenApiVO() {
    }

    @Generated
    public static abstract class OswStackPortSettingOpenApiVOBuilder<C extends OswStackPortSettingOpenApiVO, B extends OswStackPortSettingOpenApiVOBuilder<C, B>> {
        @Generated
        private String mac;
        @Generated
        private String name;
        @Generated
        private String profileId;
        @Generated
        private Boolean profileOverrideEnable;
        @Generated
        private String operation;
        @Generated
        private Set<Integer> mirroredPorts;
        @Generated
        private Set<Integer> mirroredLags;
        @Generated
        private OswLagBasicVO lagSetting;
        @Generated
        private Integer linkSpeed;
        @Generated
        private Integer duplex;
        @Generated
        private Integer dot1x;
        @Generated
        private Integer poe;
        @Generated
        private Integer bandWidthCtrlType;
        @Generated
        private OswBandCtrlVO bandCtrl;
        @Generated
        private OswStormCtrlOpenApiVO stormCtrl;
        @Generated
        private Boolean lldpMedEnable;
        @Generated
        private Boolean topoNotifyEnable;
        @Generated
        private Boolean spanningTreeEnable;
        @Generated
        private SpanningTreeSettingVO spanningTreeSetting;
        @Generated
        private Boolean loopbackDetectEnable;
        @Generated
        private Boolean loopbackDetectVlanBasedEnable;
        @Generated
        private Boolean igmpFastLeaveEnable;
        @Generated
        private Boolean mldFastLeaveEnable;
        @Generated
        private Boolean portIsolationEnable;
        @Generated
        private Boolean eeeEnable;
        @Generated
        private Boolean flowControlEnable;
        @Generated
        private Boolean fastLeaveEnable;
        @Generated
        private OswPortDhcpL2RelayVO dhcpL2RelaySettings;
        @Generated
        private OswPortStackSettingVO stackSetting;
        @Generated
        private Integer dot1pPriority;
        @Generated
        private Integer trustMode;

        @Generated
        public B mac(String mac) {
            this.mac = mac;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B profileId(String profileId) {
            this.profileId = profileId;
            return this.self();
        }

        @Generated
        public B profileOverrideEnable(Boolean profileOverrideEnable) {
            this.profileOverrideEnable = profileOverrideEnable;
            return this.self();
        }

        @Generated
        public B operation(String operation) {
            this.operation = operation;
            return this.self();
        }

        @Generated
        public B mirroredPorts(Set<Integer> mirroredPorts) {
            this.mirroredPorts = mirroredPorts;
            return this.self();
        }

        @Generated
        public B mirroredLags(Set<Integer> mirroredLags) {
            this.mirroredLags = mirroredLags;
            return this.self();
        }

        @Generated
        public B lagSetting(OswLagBasicVO lagSetting) {
            this.lagSetting = lagSetting;
            return this.self();
        }

        @Generated
        public B linkSpeed(Integer linkSpeed) {
            this.linkSpeed = linkSpeed;
            return this.self();
        }

        @Generated
        public B duplex(Integer duplex) {
            this.duplex = duplex;
            return this.self();
        }

        @Generated
        public B dot1x(Integer dot1x) {
            this.dot1x = dot1x;
            return this.self();
        }

        @Generated
        public B poe(Integer poe) {
            this.poe = poe;
            return this.self();
        }

        @Generated
        public B bandWidthCtrlType(Integer bandWidthCtrlType) {
            this.bandWidthCtrlType = bandWidthCtrlType;
            return this.self();
        }

        @Generated
        public B bandCtrl(OswBandCtrlVO bandCtrl) {
            this.bandCtrl = bandCtrl;
            return this.self();
        }

        @Generated
        public B stormCtrl(OswStormCtrlOpenApiVO stormCtrl) {
            this.stormCtrl = stormCtrl;
            return this.self();
        }

        @Generated
        public B lldpMedEnable(Boolean lldpMedEnable) {
            this.lldpMedEnable = lldpMedEnable;
            return this.self();
        }

        @Generated
        public B topoNotifyEnable(Boolean topoNotifyEnable) {
            this.topoNotifyEnable = topoNotifyEnable;
            return this.self();
        }

        @Generated
        public B spanningTreeEnable(Boolean spanningTreeEnable) {
            this.spanningTreeEnable = spanningTreeEnable;
            return this.self();
        }

        @Generated
        public B spanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
            this.spanningTreeSetting = spanningTreeSetting;
            return this.self();
        }

        @Generated
        public B loopbackDetectEnable(Boolean loopbackDetectEnable) {
            this.loopbackDetectEnable = loopbackDetectEnable;
            return this.self();
        }

        @Generated
        public B loopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
            this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
            return this.self();
        }

        @Generated
        public B igmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
            this.igmpFastLeaveEnable = igmpFastLeaveEnable;
            return this.self();
        }

        @Generated
        public B mldFastLeaveEnable(Boolean mldFastLeaveEnable) {
            this.mldFastLeaveEnable = mldFastLeaveEnable;
            return this.self();
        }

        @Generated
        public B portIsolationEnable(Boolean portIsolationEnable) {
            this.portIsolationEnable = portIsolationEnable;
            return this.self();
        }

        @Generated
        public B eeeEnable(Boolean eeeEnable) {
            this.eeeEnable = eeeEnable;
            return this.self();
        }

        @Generated
        public B flowControlEnable(Boolean flowControlEnable) {
            this.flowControlEnable = flowControlEnable;
            return this.self();
        }

        @Generated
        public B fastLeaveEnable(Boolean fastLeaveEnable) {
            this.fastLeaveEnable = fastLeaveEnable;
            return this.self();
        }

        @Generated
        public B dhcpL2RelaySettings(OswPortDhcpL2RelayVO dhcpL2RelaySettings) {
            this.dhcpL2RelaySettings = dhcpL2RelaySettings;
            return this.self();
        }

        @Generated
        public B stackSetting(OswPortStackSettingVO stackSetting) {
            this.stackSetting = stackSetting;
            return this.self();
        }

        @Generated
        public B dot1pPriority(Integer dot1pPriority) {
            this.dot1pPriority = dot1pPriority;
            return this.self();
        }

        @Generated
        public B trustMode(Integer trustMode) {
            this.trustMode = trustMode;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OswStackPortSettingOpenApiVO.OswStackPortSettingOpenApiVOBuilder(mac=" + this.mac + ", name=" + this.name + ", profileId=" + this.profileId + ", profileOverrideEnable=" + this.profileOverrideEnable + ", operation=" + this.operation + ", mirroredPorts=" + this.mirroredPorts + ", mirroredLags=" + this.mirroredLags + ", lagSetting=" + this.lagSetting + ", linkSpeed=" + this.linkSpeed + ", duplex=" + this.duplex + ", dot1x=" + this.dot1x + ", poe=" + this.poe + ", bandWidthCtrlType=" + this.bandWidthCtrlType + ", bandCtrl=" + this.bandCtrl + ", stormCtrl=" + this.stormCtrl + ", lldpMedEnable=" + this.lldpMedEnable + ", topoNotifyEnable=" + this.topoNotifyEnable + ", spanningTreeEnable=" + this.spanningTreeEnable + ", spanningTreeSetting=" + this.spanningTreeSetting + ", loopbackDetectEnable=" + this.loopbackDetectEnable + ", loopbackDetectVlanBasedEnable=" + this.loopbackDetectVlanBasedEnable + ", igmpFastLeaveEnable=" + this.igmpFastLeaveEnable + ", mldFastLeaveEnable=" + this.mldFastLeaveEnable + ", portIsolationEnable=" + this.portIsolationEnable + ", eeeEnable=" + this.eeeEnable + ", flowControlEnable=" + this.flowControlEnable + ", fastLeaveEnable=" + this.fastLeaveEnable + ", dhcpL2RelaySettings=" + this.dhcpL2RelaySettings + ", stackSetting=" + this.stackSetting + ", dot1pPriority=" + this.dot1pPriority + ", trustMode=" + this.trustMode + ")";
        }
    }

    @Generated
    private static final class OswStackPortSettingOpenApiVOBuilderImpl
    extends OswStackPortSettingOpenApiVOBuilder<OswStackPortSettingOpenApiVO, OswStackPortSettingOpenApiVOBuilderImpl> {
        @Generated
        private OswStackPortSettingOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStackPortSettingOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStackPortSettingOpenApiVO build() {
            return new OswStackPortSettingOpenApiVO(this);
        }
    }
}

