/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.stack;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.api.openapi.stack.OswStackLagOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswBandCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStandPortVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.StackLagSettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;

@Schema(name="OswStackMemberLagOpenApiVO")
public class OswStackMemberLagOpenApiVO
extends OswStackLagOpenApiVO {
    @Schema(name="standardPorts", description="LAG Standard ports")
    private Collection<OswStandPortVO> standardPorts;

    public static StackLagSettingVO buildWebVO(OswStackMemberLagOpenApiVO openApiVO) {
        StackLagSettingVO vo = new StackLagSettingVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setStandardPorts(openApiVO.getStandardPorts());
        vo.setName(openApiVO.getName());
        vo.setProfileId(openApiVO.getProfileId());
        vo.setProfileOverrideEnable(openApiVO.getProfileOverrideEnable());
        vo.setLinkSpeed(openApiVO.getLinkSpeed());
        vo.setDuplex(openApiVO.getDuplex());
        vo.setPortIsolationEnable(openApiVO.getPortIsolationEnable());
        vo.setSpanningTreeEnable(openApiVO.getSpanningTreeEnable());
        vo.setSpanningTreeSetting(openApiVO.getSpanningTreeSetting());
        vo.setLoopbackDetectEnable(openApiVO.getSpanningTreeEnable());
        vo.setLoopbackDetectVlanBasedEnable(openApiVO.getLoopbackDetectVlanBasedEnable());
        vo.setIgmpFastLeaveEnable(openApiVO.getIgmpFastLeaveEnable());
        vo.setMldFastLeaveEnable(openApiVO.getMldFastLeaveEnable());
        vo.setBandWidthCtrlType(openApiVO.getBandWidthCtrlType());
        vo.setStormCtrl(openApiVO.getStormCtrl());
        vo.setBandCtrl(openApiVO.getBandCtrl());
        vo.setEeeEnable(openApiVO.getEeeEnable());
        vo.setFlowControlEnable(openApiVO.getFlowControlEnable());
        vo.setFastLeaveEnable(openApiVO.getFastLeaveEnable());
        vo.setDhcpL2RelaySettings(openApiVO.getDhcpL2RelaySettings());
        vo.setDot1pPriority(openApiVO.getDot1pPriority());
        vo.setTrustMode(openApiVO.getTrustMode());
        return vo;
    }

    public OperationResponse checkValidation() {
        OperationResponse bandCtrlCheck = this.bandCtrlValid();
        if (!bandCtrlCheck.success()) {
            return bandCtrlCheck;
        }
        OperationResponse stpCheck = this.stpValid();
        if (!stpCheck.success()) {
            return stpCheck;
        }
        OperationResponse stromCtrlCheck = this.stormCtrlValid();
        if (!stromCtrlCheck.success()) {
            return stromCtrlCheck;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse stormCtrlValid() {
        if (this.getStormCtrl() == null) {
            return OperationResponse.SUCCESS;
        }
        OswStormCtrlVO stormCtrl = this.getStormCtrl();
        if (Objects.equals(stormCtrl.getAction(), 1) && stormCtrl.getRecoverTime() == null) {
            return new OperationResponse(b.d, "StormCtrl parameter [recoverTime] should not be null", null);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse stpValid() {
        Integer priority;
        if (this.getSpanningTreeSetting() == null) {
            return OperationResponse.SUCCESS;
        }
        SpanningTreeSettingVO spanningTreeSetting = this.getSpanningTreeSetting();
        if (spanningTreeSetting.getPriority() != null && (priority = spanningTreeSetting.getPriority()) % 16 != 0) {
            return new OperationResponse(b.d, "Priority should be a multiple of 16", null);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse bandCtrlValid() {
        if (this.getBandCtrl() == null) {
            return OperationResponse.SUCCESS;
        }
        OswBandCtrlVO bandCtrl = this.getBandCtrl();
        if (Boolean.TRUE.equals(bandCtrl.getEgressEnable()) && bandCtrl.getEgressUnit() == null) {
            return new OperationResponse(b.d, "bandCtrl parameter [egressUnit] should not be null", null);
        }
        if (Boolean.TRUE.equals(bandCtrl.getIngressEnable()) && bandCtrl.getIngressUnit() == null) {
            return new OperationResponse(b.d, "bandCtrl parameter [ingressUnit] should not be null", null);
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    protected OswStackMemberLagOpenApiVO(OswStackMemberLagOpenApiVOBuilder<?, ?> b2) {
        super(b2);
        this.standardPorts = b2.standardPorts;
    }

    @Generated
    public static OswStackMemberLagOpenApiVOBuilder<?, ?> builder() {
        return new OswStackMemberLagOpenApiVOBuilderImpl();
    }

    @Generated
    public Collection<OswStandPortVO> getStandardPorts() {
        return this.standardPorts;
    }

    @Generated
    public void setStandardPorts(Collection<OswStandPortVO> standardPorts) {
        this.standardPorts = standardPorts;
    }

    @Override
    @Generated
    public String toString() {
        return "OswStackMemberLagOpenApiVO(standardPorts=" + this.getStandardPorts() + ")";
    }

    @Generated
    public OswStackMemberLagOpenApiVO(Collection<OswStandPortVO> standardPorts) {
        this.standardPorts = standardPorts;
    }

    @Generated
    public OswStackMemberLagOpenApiVO() {
    }

    @Generated
    public static abstract class OswStackMemberLagOpenApiVOBuilder<C extends OswStackMemberLagOpenApiVO, B extends OswStackMemberLagOpenApiVOBuilder<C, B>>
    extends OswStackLagOpenApiVO.OswStackLagOpenApiVOBuilder<C, B> {
        @Generated
        private Collection<OswStandPortVO> standardPorts;

        @Generated
        public B standardPorts(Collection<OswStandPortVO> standardPorts) {
            this.standardPorts = standardPorts;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OswStackMemberLagOpenApiVO.OswStackMemberLagOpenApiVOBuilder(super=" + super.toString() + ", standardPorts=" + this.standardPorts + ")";
        }
    }

    @Generated
    private static final class OswStackMemberLagOpenApiVOBuilderImpl
    extends OswStackMemberLagOpenApiVOBuilder<OswStackMemberLagOpenApiVO, OswStackMemberLagOpenApiVOBuilderImpl> {
        @Generated
        private OswStackMemberLagOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStackMemberLagOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStackMemberLagOpenApiVO build() {
            return new OswStackMemberLagOpenApiVO(this);
        }
    }
}

