/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.stack;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.device.manage.message.config.osw.OswStpMstpConfig;
import com.tplink.smb.omada.manager.device.api.web.device.dto.DeviceLocationDetailVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswQosConfigVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswSnmpVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="OswStackDetailConfigOpenApiVO")
public class OswStackDetailConfigOpenApiVO {
    @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters")
    @Schema(name="name", description="Stack Name")
    private @Pattern(regexp="^[^ \\+\\-\\@\\=]$|^[^ \\+\\-\\@\\=].{0,126}[^ ]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @NumberSet(value={0, 1, 2}, message="Parameter [ledSetting] should be 0 or 1 or 2")
    @Schema(name="ledSetting", description="LED setting should be a value as follows: 0:off; 1:on; 2:Use Site Settings")
    private Integer ledSetting;
    @Schema(name="mvlanNetworkId", description="Management VLAN network ID")
    private String mvlanNetworkId;
    @Schema(name="mvlanBridgeVlan", description="Only valid when mvlanNetworkId is bridge vlan")
    private Integer mvlanBridgeVlan;
    @Schema(name="loopbackDetectEnable", description="LoopbackDetect enable status")
    private Boolean loopbackDetectEnable;
    @NumberSet(value={0, 1, 2, 3}, message="Parameter [stp] should be 0 or 1 or 2 or 3")
    @Schema(name="stp", description="Spanning Tree Protocol should be a value as follows: 1: STP; 2: RSTP; 3: MSTP; 0: OFF")
    private Integer stp;
    @Valid
    @Schema(name="snmp", description="Snmp setting")
    private OswSnmpVO snmp;
    @NumberSet(value={0, 4096, 8192, 12288, 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, 61440}, message="Parameter [priority] should be an integer from 0 to 61440 and divisible by 4096.")
    @Schema(name="priority", description="STP priority should be an integer from 0 to 61440 and divisible by 4096")
    private Integer priority;
    @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.")
    @Schema(name="helloTime", description="STP helloTime should be should be within the range of 1-10")
    private @Range(min=1L, max=10L, message="helloTime should be between 1 and 10.") Integer helloTime;
    @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.")
    @Schema(name="maxAge", description="STP maxAge should be should be within the range of 6-40")
    private @Range(min=6L, max=40L, message="maxAge should be between 6 and 40.") Integer maxAge;
    @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.")
    @Schema(name="forwardDelay", description="STP should be should be within the range of 4-30")
    private @Range(min=4L, max=30L, message="forwardDelay should be between 4 and 30.") Integer forwardDelay;
    @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.")
    @Schema(name="txHoldCount", description="STP txHoldCount should be should be within the range of 1-20")
    private @Range(min=1L, max=20L, message="txHoldCount should be between 1 and 20.") Integer txHoldCount;
    @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.")
    @Schema(name="maxHops", description="STP maxHops should be should be within the range of 1-40")
    private @Range(min=1L, max=40L, message="maxHops should be between 1 and 40.") Integer maxHops;
    @Valid
    @Schema(name="mstp", description="STP MSTP mode settging")
    private OswStpMstpConfig mstp;
    @Schema(name="tagIds", description="Tag ID List")
    private List<String> tagIds;
    @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.")
    @Schema(name="jumbo", description="Jumbo should be should be within the range of 1518-9216")
    private @Range(min=1518L, max=9216L, message="Jumbo should be between 1518 and 9216.") Integer jumbo;
    @NumberSet(value={0, 1, 2, 3, 4, 5}, message="lagHashAlg should be between 0 and 5.")
    @Schema(name="lagHashAlg", description="It should be a value as follows: 0: SRC MAC; 1: DST MAC; 2: SRC MAC + DST MAC; 3: SRC IP; 4: DST IP; 5: SRC IP + DST IP")
    private Integer lagHashAlg;
    @Valid
    @Schema(name="location", description="Device location")
    private DeviceLocationDetailVO location;
    @Valid
    @Nullable
    @Schema(name="qosConfig", description="Switch qos config")
    private OswQosConfigVO qosConfig;
    @NumberSet(value={0, 1, 2}, message="Parameter [rememberDevice] should be 0 or 1 or 2")
    @Schema(name="rememberDevice", description="Whether to remember the device.RememberDevice should be a value as follows: 0:off, 1:on, 2: follow site")
    private Integer rememberDevice;

    public static OswConfigVO buildWebVO(OswStackDetailConfigOpenApiVO openApiVO) {
        OswConfigVO vo = new OswConfigVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setName(openApiVO.getName());
        vo.setLedSetting(openApiVO.getLedSetting());
        vo.setSnmp(openApiVO.getSnmp());
        vo.setMvlanNetworkId(openApiVO.getMvlanNetworkId());
        vo.setMvlanBridgeVlan(openApiVO.getMvlanBridgeVlan());
        vo.setLoopbackDetectEnable(openApiVO.getLoopbackDetectEnable());
        vo.setStp(openApiVO.getStp());
        vo.setPriority(openApiVO.getPriority());
        vo.setHelloTime(openApiVO.getHelloTime());
        vo.setMaxAge(openApiVO.getMaxAge());
        vo.setForwardDelay(openApiVO.getForwardDelay());
        vo.setTxHoldCount(openApiVO.getTxHoldCount());
        vo.setMaxHops(openApiVO.getMaxHops());
        vo.setMstp(openApiVO.getMstp());
        vo.setJumbo(openApiVO.getJumbo());
        vo.setLagHashAlg(openApiVO.getLagHashAlg());
        vo.setLocation(openApiVO.getLocation());
        vo.setQosConfig(openApiVO.getQosConfig());
        vo.setRememberDevice(openApiVO.getRememberDevice());
        vo.setTagIds(openApiVO.getTagIds());
        return vo;
    }

    @Generated
    protected OswStackDetailConfigOpenApiVO(OswStackDetailConfigOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.ledSetting = b2.ledSetting;
        this.mvlanNetworkId = b2.mvlanNetworkId;
        this.mvlanBridgeVlan = b2.mvlanBridgeVlan;
        this.loopbackDetectEnable = b2.loopbackDetectEnable;
        this.stp = b2.stp;
        this.snmp = b2.snmp;
        this.priority = b2.priority;
        this.helloTime = b2.helloTime;
        this.maxAge = b2.maxAge;
        this.forwardDelay = b2.forwardDelay;
        this.txHoldCount = b2.txHoldCount;
        this.maxHops = b2.maxHops;
        this.mstp = b2.mstp;
        this.tagIds = b2.tagIds;
        this.jumbo = b2.jumbo;
        this.lagHashAlg = b2.lagHashAlg;
        this.location = b2.location;
        this.qosConfig = b2.qosConfig;
        this.rememberDevice = b2.rememberDevice;
    }

    @Generated
    public static OswStackDetailConfigOpenApiVOBuilder<?, ?> builder() {
        return new OswStackDetailConfigOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLedSetting() {
        return this.ledSetting;
    }

    @Generated
    public String getMvlanNetworkId() {
        return this.mvlanNetworkId;
    }

    @Generated
    public Integer getMvlanBridgeVlan() {
        return this.mvlanBridgeVlan;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Integer getStp() {
        return this.stp;
    }

    @Generated
    public OswSnmpVO getSnmp() {
        return this.snmp;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public Integer getHelloTime() {
        return this.helloTime;
    }

    @Generated
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Generated
    public Integer getForwardDelay() {
        return this.forwardDelay;
    }

    @Generated
    public Integer getTxHoldCount() {
        return this.txHoldCount;
    }

    @Generated
    public Integer getMaxHops() {
        return this.maxHops;
    }

    @Generated
    public OswStpMstpConfig getMstp() {
        return this.mstp;
    }

    @Generated
    public List<String> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Integer getJumbo() {
        return this.jumbo;
    }

    @Generated
    public Integer getLagHashAlg() {
        return this.lagHashAlg;
    }

    @Generated
    public DeviceLocationDetailVO getLocation() {
        return this.location;
    }

    @Nullable
    @Generated
    public OswQosConfigVO getQosConfig() {
        return this.qosConfig;
    }

    @Generated
    public Integer getRememberDevice() {
        return this.rememberDevice;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLedSetting(Integer ledSetting) {
        this.ledSetting = ledSetting;
    }

    @Generated
    public void setMvlanNetworkId(String mvlanNetworkId) {
        this.mvlanNetworkId = mvlanNetworkId;
    }

    @Generated
    public void setMvlanBridgeVlan(Integer mvlanBridgeVlan) {
        this.mvlanBridgeVlan = mvlanBridgeVlan;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setStp(Integer stp) {
        this.stp = stp;
    }

    @Generated
    public void setSnmp(OswSnmpVO snmp) {
        this.snmp = snmp;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setHelloTime(Integer helloTime) {
        this.helloTime = helloTime;
    }

    @Generated
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    @Generated
    public void setForwardDelay(Integer forwardDelay) {
        this.forwardDelay = forwardDelay;
    }

    @Generated
    public void setTxHoldCount(Integer txHoldCount) {
        this.txHoldCount = txHoldCount;
    }

    @Generated
    public void setMaxHops(Integer maxHops) {
        this.maxHops = maxHops;
    }

    @Generated
    public void setMstp(OswStpMstpConfig mstp) {
        this.mstp = mstp;
    }

    @Generated
    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    @Generated
    public void setJumbo(Integer jumbo) {
        this.jumbo = jumbo;
    }

    @Generated
    public void setLagHashAlg(Integer lagHashAlg) {
        this.lagHashAlg = lagHashAlg;
    }

    @Generated
    public void setLocation(DeviceLocationDetailVO location) {
        this.location = location;
    }

    @Generated
    public void setQosConfig(@Nullable OswQosConfigVO qosConfig) {
        this.qosConfig = qosConfig;
    }

    @Generated
    public void setRememberDevice(Integer rememberDevice) {
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public String toString() {
        return "OswStackDetailConfigOpenApiVO(name=" + this.getName() + ", ledSetting=" + this.getLedSetting() + ", mvlanNetworkId=" + this.getMvlanNetworkId() + ", mvlanBridgeVlan=" + this.getMvlanBridgeVlan() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", stp=" + this.getStp() + ", snmp=" + this.getSnmp() + ", priority=" + this.getPriority() + ", helloTime=" + this.getHelloTime() + ", maxAge=" + this.getMaxAge() + ", forwardDelay=" + this.getForwardDelay() + ", txHoldCount=" + this.getTxHoldCount() + ", maxHops=" + this.getMaxHops() + ", mstp=" + this.getMstp() + ", tagIds=" + this.getTagIds() + ", jumbo=" + this.getJumbo() + ", lagHashAlg=" + this.getLagHashAlg() + ", location=" + this.getLocation() + ", qosConfig=" + this.getQosConfig() + ", rememberDevice=" + this.getRememberDevice() + ")";
    }

    @Generated
    public OswStackDetailConfigOpenApiVO(String name, Integer ledSetting, String mvlanNetworkId, Integer mvlanBridgeVlan, Boolean loopbackDetectEnable, Integer stp, OswSnmpVO snmp, Integer priority, Integer helloTime, Integer maxAge, Integer forwardDelay, Integer txHoldCount, Integer maxHops, OswStpMstpConfig mstp, List<String> tagIds, Integer jumbo, Integer lagHashAlg, DeviceLocationDetailVO location, @Nullable OswQosConfigVO qosConfig, Integer rememberDevice) {
        this.name = name;
        this.ledSetting = ledSetting;
        this.mvlanNetworkId = mvlanNetworkId;
        this.mvlanBridgeVlan = mvlanBridgeVlan;
        this.loopbackDetectEnable = loopbackDetectEnable;
        this.stp = stp;
        this.snmp = snmp;
        this.priority = priority;
        this.helloTime = helloTime;
        this.maxAge = maxAge;
        this.forwardDelay = forwardDelay;
        this.txHoldCount = txHoldCount;
        this.maxHops = maxHops;
        this.mstp = mstp;
        this.tagIds = tagIds;
        this.jumbo = jumbo;
        this.lagHashAlg = lagHashAlg;
        this.location = location;
        this.qosConfig = qosConfig;
        this.rememberDevice = rememberDevice;
    }

    @Generated
    public OswStackDetailConfigOpenApiVO() {
    }

    @Generated
    public static abstract class OswStackDetailConfigOpenApiVOBuilder<C extends OswStackDetailConfigOpenApiVO, B extends OswStackDetailConfigOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Integer ledSetting;
        @Generated
        private String mvlanNetworkId;
        @Generated
        private Integer mvlanBridgeVlan;
        @Generated
        private Boolean loopbackDetectEnable;
        @Generated
        private Integer stp;
        @Generated
        private OswSnmpVO snmp;
        @Generated
        private Integer priority;
        @Generated
        private Integer helloTime;
        @Generated
        private Integer maxAge;
        @Generated
        private Integer forwardDelay;
        @Generated
        private Integer txHoldCount;
        @Generated
        private Integer maxHops;
        @Generated
        private OswStpMstpConfig mstp;
        @Generated
        private List<String> tagIds;
        @Generated
        private Integer jumbo;
        @Generated
        private Integer lagHashAlg;
        @Generated
        private DeviceLocationDetailVO location;
        @Generated
        private OswQosConfigVO qosConfig;
        @Generated
        private Integer rememberDevice;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B ledSetting(Integer ledSetting) {
            this.ledSetting = ledSetting;
            return this.self();
        }

        @Generated
        public B mvlanNetworkId(String mvlanNetworkId) {
            this.mvlanNetworkId = mvlanNetworkId;
            return this.self();
        }

        @Generated
        public B mvlanBridgeVlan(Integer mvlanBridgeVlan) {
            this.mvlanBridgeVlan = mvlanBridgeVlan;
            return this.self();
        }

        @Generated
        public B loopbackDetectEnable(Boolean loopbackDetectEnable) {
            this.loopbackDetectEnable = loopbackDetectEnable;
            return this.self();
        }

        @Generated
        public B stp(Integer stp) {
            this.stp = stp;
            return this.self();
        }

        @Generated
        public B snmp(OswSnmpVO snmp) {
            this.snmp = snmp;
            return this.self();
        }

        @Generated
        public B priority(Integer priority) {
            this.priority = priority;
            return this.self();
        }

        @Generated
        public B helloTime(Integer helloTime) {
            this.helloTime = helloTime;
            return this.self();
        }

        @Generated
        public B maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this.self();
        }

        @Generated
        public B forwardDelay(Integer forwardDelay) {
            this.forwardDelay = forwardDelay;
            return this.self();
        }

        @Generated
        public B txHoldCount(Integer txHoldCount) {
            this.txHoldCount = txHoldCount;
            return this.self();
        }

        @Generated
        public B maxHops(Integer maxHops) {
            this.maxHops = maxHops;
            return this.self();
        }

        @Generated
        public B mstp(OswStpMstpConfig mstp) {
            this.mstp = mstp;
            return this.self();
        }

        @Generated
        public B tagIds(List<String> tagIds) {
            this.tagIds = tagIds;
            return this.self();
        }

        @Generated
        public B jumbo(Integer jumbo) {
            this.jumbo = jumbo;
            return this.self();
        }

        @Generated
        public B lagHashAlg(Integer lagHashAlg) {
            this.lagHashAlg = lagHashAlg;
            return this.self();
        }

        @Generated
        public B location(DeviceLocationDetailVO location) {
            this.location = location;
            return this.self();
        }

        @Generated
        public B qosConfig(@Nullable OswQosConfigVO qosConfig) {
            this.qosConfig = qosConfig;
            return this.self();
        }

        @Generated
        public B rememberDevice(Integer rememberDevice) {
            this.rememberDevice = rememberDevice;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OswStackDetailConfigOpenApiVO.OswStackDetailConfigOpenApiVOBuilder(name=" + this.name + ", ledSetting=" + this.ledSetting + ", mvlanNetworkId=" + this.mvlanNetworkId + ", mvlanBridgeVlan=" + this.mvlanBridgeVlan + ", loopbackDetectEnable=" + this.loopbackDetectEnable + ", stp=" + this.stp + ", snmp=" + this.snmp + ", priority=" + this.priority + ", helloTime=" + this.helloTime + ", maxAge=" + this.maxAge + ", forwardDelay=" + this.forwardDelay + ", txHoldCount=" + this.txHoldCount + ", maxHops=" + this.maxHops + ", mstp=" + this.mstp + ", tagIds=" + this.tagIds + ", jumbo=" + this.jumbo + ", lagHashAlg=" + this.lagHashAlg + ", location=" + this.location + ", qosConfig=" + this.qosConfig + ", rememberDevice=" + this.rememberDevice + ")";
        }
    }

    @Generated
    private static final class OswStackDetailConfigOpenApiVOBuilderImpl
    extends OswStackDetailConfigOpenApiVOBuilder<OswStackDetailConfigOpenApiVO, OswStackDetailConfigOpenApiVOBuilderImpl> {
        @Generated
        private OswStackDetailConfigOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected OswStackDetailConfigOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OswStackDetailConfigOpenApiVO build() {
            return new OswStackDetailConfigOpenApiVO(this);
        }
    }
}

