/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.stack;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswBandCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswPortDhcpL2RelayVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.OswStormCtrlVO;
import com.tplink.smb.omada.manager.device.api.web.osw.dto.SpanningTreeSettingVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.BatchStackPortSettingVO;
import com.tplink.smb.omada.manager.stack.api.web.dto.OswStackUnitVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

@Schema(name="BatchStackPortSettingOpenApiVO")
public class BatchStackPortSettingOpenApiVO {
    @NotNull(message="Parameter [unitList] should not be null.")
    @Size(min=1, message="Parameter [unitList] should not be empty.")
    @Valid
    @Schema(name="unitList", description="Unit List")
    private @NotNull(message="Parameter [unitList] should not be null.") @Size(min=1, message="Parameter [unitList] should not be empty.") @Valid List<OswStackUnitVO> unitList;
    @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters")
    @Schema(name="name", description="Port name")
    private @Pattern(regexp="^[^ ?\"]$|^[^ ?\"][^?\"]{0,126}[^ ?\"]$", message="Parameter [name] should be 1 ~ 128 characters") String name;
    @Schema(name="profileId", description="Lan Profile ID")
    private String profileId;
    @Schema(name="profileOverrideEnable", description="Indicates whether to enable Profile Override")
    private Boolean profileOverrideEnable;
    @Pattern(regexp="switching", message="PortSetting parameter [operation] should be \"switching")
    @Schema(name="operation", description="Operation should be a value as follows: SWITCHING; ")
    private @Pattern(regexp="switching", message="PortSetting parameter [operation] should be \"switching") String operation;
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, message="PortSetting parameter [linkSpeed] should be [0, 1, 2, 3, 4, 5,6,7,8,9]")
    @Schema(name="linkSpeed", description="LinkSpeed should be a value as follows: 0: Auto; 1: 10M; 2: 100M; 3: 1000M; 4: 2500M; 5: 10G; 6: 5G; 7: 25G; 8: 100G; 9: 40G.")
    private Integer linkSpeed;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [duplex] should be 0 or 1 or 2")
    @Schema(name="duplex", description="Duplex should be a value as follows: 0: Auto; 1: Half; 2: Full")
    private Integer duplex;
    @Schema(name="dot1x", description="Dot1x should be a value as follows: 0: Force unauthorized; 1: Force authorized; 2: Auto")
    private Integer dot1x;
    @NumberSet(value={0, 1}, message="PortSetting parameter [poe] should be 0 or 1")
    @Schema(name="poe", description="PoE switch should be a value as follows: 0: Off; 1: 802.3at/af")
    private Integer poe;
    @NumberSet(value={0, 1, 2}, message="PortSetting parameter [bandWidthCtrlType] should be 0, 1, 2")
    @Schema(name="bandWidthCtrlType", description="BandWidthCtrlType should be a value as follows: 0: Off; 1: Rate Limit; 2: Storming Control")
    private Integer bandWidthCtrlType;
    @Valid
    @Schema(name="bandCtrl", description="Speed Limit")
    private OswBandCtrlVO bandCtrl;
    @Valid
    @Schema(name="stormCtrl", description="Storm Control")
    private OswStormCtrlVO stormCtrl;
    @Schema(name="lldpMedEnable", description="LLDP-MED enable status")
    private Boolean lldpMedEnable;
    @Schema(name="spanningTreeEnable", description="SpanningTree enable status")
    private Boolean spanningTreeEnable;
    @Valid
    @Schema(name="spanningTreeSetting", description="SpanningTree Setting")
    private SpanningTreeSettingVO spanningTreeSetting;
    @Schema(name="loopbackDetectEnable", description="LoopbackDetect enable status")
    private Boolean loopbackDetectEnable;
    @Schema(name="loopbackDetectVlanBasedEnable", description="LoopbackDetectVLANBased enable status")
    private Boolean loopbackDetectVlanBasedEnable;
    @Schema(name="igmpFastLeaveEnable", description="Indicates whether igmp fast leave is enabled")
    private Boolean igmpFastLeaveEnable;
    @Schema(name="mldFastLeaveEnable", description="Indicates whether mld fast leave is enabled")
    private Boolean mldFastLeaveEnable;
    @Schema(name="portIsolationEnable", description="Port-isolation enable status")
    private Boolean portIsolationEnable;
    @Schema(name="eeeEnable", description="EEE enable status")
    private Boolean eeeEnable;
    @Schema(name="flowControlEnable", description="FlowControl enable status")
    private Boolean flowControlEnable;
    @Schema(name="fastLeaveEnable", description="Indicates whether igmpSnooping fastLeave is enabled")
    private Boolean fastLeaveEnable;
    @Valid
    @Schema(name="dhcpL2RelaySettings", description="Dhcp L2 Relay Setting")
    private OswPortDhcpL2RelayVO dhcpL2RelaySettings;
    @Range(min=0L, max=7L)
    @Schema(name="dot1pPriority", description="Dot1p Priority")
    private @Range(min=0L, max=7L) Integer dot1pPriority;
    @Schema(name="trustMode", description="TrustMode should be a value as follows: 0: Untrusted; 1: Trust 802.1p; 2: Trust DSCP")
    private Integer trustMode;

    public static BatchStackPortSettingVO buildWebVO(BatchStackPortSettingOpenApiVO openApiVO) {
        BatchStackPortSettingVO vo = new BatchStackPortSettingVO();
        if (openApiVO == null) {
            return vo;
        }
        vo.setUnitList(openApiVO.getUnitList());
        vo.setName(openApiVO.getName());
        vo.setProfileId(openApiVO.getProfileId());
        vo.setProfileOverrideEnable(openApiVO.getProfileOverrideEnable());
        vo.setOperation(openApiVO.getOperation());
        vo.setPoe(openApiVO.getPoe());
        vo.setDot1x(openApiVO.getDot1x());
        vo.setLinkSpeed(openApiVO.getLinkSpeed());
        vo.setDuplex(openApiVO.getDuplex());
        vo.setPortIsolationEnable(openApiVO.getPortIsolationEnable());
        vo.setSpanningTreeEnable(openApiVO.getSpanningTreeEnable());
        vo.setSpanningTreeSetting(openApiVO.getSpanningTreeSetting());
        vo.setLoopbackDetectEnable(openApiVO.getLoopbackDetectEnable());
        vo.setLoopbackDetectVlanBasedEnable(openApiVO.getLoopbackDetectVlanBasedEnable());
        vo.setIgmpFastLeaveEnable(openApiVO.getIgmpFastLeaveEnable());
        vo.setMldFastLeaveEnable(openApiVO.getMldFastLeaveEnable());
        vo.setBandWidthCtrlType(openApiVO.getBandWidthCtrlType());
        vo.setLldpMedEnable(openApiVO.getLldpMedEnable());
        vo.setStormCtrl(openApiVO.getStormCtrl());
        vo.setBandCtrl(openApiVO.getBandCtrl());
        vo.setEeeEnable(openApiVO.getEeeEnable());
        vo.setFlowControlEnable(openApiVO.getFlowControlEnable());
        vo.setFastLeaveEnable(openApiVO.getFastLeaveEnable());
        vo.setDhcpL2RelaySettings(openApiVO.getDhcpL2RelaySettings());
        vo.setDot1pPriority(openApiVO.getDot1pPriority());
        vo.setTrustMode(openApiVO.getTrustMode());
        return vo;
    }

    @Generated
    protected BatchStackPortSettingOpenApiVO(BatchStackPortSettingOpenApiVOBuilder<?, ?> b2) {
        this.unitList = b2.unitList;
        this.name = b2.name;
        this.profileId = b2.profileId;
        this.profileOverrideEnable = b2.profileOverrideEnable;
        this.operation = b2.operation;
        this.linkSpeed = b2.linkSpeed;
        this.duplex = b2.duplex;
        this.dot1x = b2.dot1x;
        this.poe = b2.poe;
        this.bandWidthCtrlType = b2.bandWidthCtrlType;
        this.bandCtrl = b2.bandCtrl;
        this.stormCtrl = b2.stormCtrl;
        this.lldpMedEnable = b2.lldpMedEnable;
        this.spanningTreeEnable = b2.spanningTreeEnable;
        this.spanningTreeSetting = b2.spanningTreeSetting;
        this.loopbackDetectEnable = b2.loopbackDetectEnable;
        this.loopbackDetectVlanBasedEnable = b2.loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = b2.igmpFastLeaveEnable;
        this.mldFastLeaveEnable = b2.mldFastLeaveEnable;
        this.portIsolationEnable = b2.portIsolationEnable;
        this.eeeEnable = b2.eeeEnable;
        this.flowControlEnable = b2.flowControlEnable;
        this.fastLeaveEnable = b2.fastLeaveEnable;
        this.dhcpL2RelaySettings = b2.dhcpL2RelaySettings;
        this.dot1pPriority = b2.dot1pPriority;
        this.trustMode = b2.trustMode;
    }

    @Generated
    public static BatchStackPortSettingOpenApiVOBuilder<?, ?> builder() {
        return new BatchStackPortSettingOpenApiVOBuilderImpl();
    }

    @Generated
    public List<OswStackUnitVO> getUnitList() {
        return this.unitList;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getProfileId() {
        return this.profileId;
    }

    @Generated
    public Boolean getProfileOverrideEnable() {
        return this.profileOverrideEnable;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    @Generated
    public Integer getDuplex() {
        return this.duplex;
    }

    @Generated
    public Integer getDot1x() {
        return this.dot1x;
    }

    @Generated
    public Integer getPoe() {
        return this.poe;
    }

    @Generated
    public Integer getBandWidthCtrlType() {
        return this.bandWidthCtrlType;
    }

    @Generated
    public OswBandCtrlVO getBandCtrl() {
        return this.bandCtrl;
    }

    @Generated
    public OswStormCtrlVO getStormCtrl() {
        return this.stormCtrl;
    }

    @Generated
    public Boolean getLldpMedEnable() {
        return this.lldpMedEnable;
    }

    @Generated
    public Boolean getSpanningTreeEnable() {
        return this.spanningTreeEnable;
    }

    @Generated
    public SpanningTreeSettingVO getSpanningTreeSetting() {
        return this.spanningTreeSetting;
    }

    @Generated
    public Boolean getLoopbackDetectEnable() {
        return this.loopbackDetectEnable;
    }

    @Generated
    public Boolean getLoopbackDetectVlanBasedEnable() {
        return this.loopbackDetectVlanBasedEnable;
    }

    @Generated
    public Boolean getIgmpFastLeaveEnable() {
        return this.igmpFastLeaveEnable;
    }

    @Generated
    public Boolean getMldFastLeaveEnable() {
        return this.mldFastLeaveEnable;
    }

    @Generated
    public Boolean getPortIsolationEnable() {
        return this.portIsolationEnable;
    }

    @Generated
    public Boolean getEeeEnable() {
        return this.eeeEnable;
    }

    @Generated
    public Boolean getFlowControlEnable() {
        return this.flowControlEnable;
    }

    @Generated
    public Boolean getFastLeaveEnable() {
        return this.fastLeaveEnable;
    }

    @Generated
    public OswPortDhcpL2RelayVO getDhcpL2RelaySettings() {
        return this.dhcpL2RelaySettings;
    }

    @Generated
    public Integer getDot1pPriority() {
        return this.dot1pPriority;
    }

    @Generated
    public Integer getTrustMode() {
        return this.trustMode;
    }

    @Generated
    public void setUnitList(List<OswStackUnitVO> unitList) {
        this.unitList = unitList;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    @Generated
    public void setProfileOverrideEnable(Boolean profileOverrideEnable) {
        this.profileOverrideEnable = profileOverrideEnable;
    }

    @Generated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Generated
    public void setLinkSpeed(Integer linkSpeed) {
        this.linkSpeed = linkSpeed;
    }

    @Generated
    public void setDuplex(Integer duplex) {
        this.duplex = duplex;
    }

    @Generated
    public void setDot1x(Integer dot1x) {
        this.dot1x = dot1x;
    }

    @Generated
    public void setPoe(Integer poe) {
        this.poe = poe;
    }

    @Generated
    public void setBandWidthCtrlType(Integer bandWidthCtrlType) {
        this.bandWidthCtrlType = bandWidthCtrlType;
    }

    @Generated
    public void setBandCtrl(OswBandCtrlVO bandCtrl) {
        this.bandCtrl = bandCtrl;
    }

    @Generated
    public void setStormCtrl(OswStormCtrlVO stormCtrl) {
        this.stormCtrl = stormCtrl;
    }

    @Generated
    public void setLldpMedEnable(Boolean lldpMedEnable) {
        this.lldpMedEnable = lldpMedEnable;
    }

    @Generated
    public void setSpanningTreeEnable(Boolean spanningTreeEnable) {
        this.spanningTreeEnable = spanningTreeEnable;
    }

    @Generated
    public void setSpanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
        this.spanningTreeSetting = spanningTreeSetting;
    }

    @Generated
    public void setLoopbackDetectEnable(Boolean loopbackDetectEnable) {
        this.loopbackDetectEnable = loopbackDetectEnable;
    }

    @Generated
    public void setLoopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
    }

    @Generated
    public void setIgmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
    }

    @Generated
    public void setMldFastLeaveEnable(Boolean mldFastLeaveEnable) {
        this.mldFastLeaveEnable = mldFastLeaveEnable;
    }

    @Generated
    public void setPortIsolationEnable(Boolean portIsolationEnable) {
        this.portIsolationEnable = portIsolationEnable;
    }

    @Generated
    public void setEeeEnable(Boolean eeeEnable) {
        this.eeeEnable = eeeEnable;
    }

    @Generated
    public void setFlowControlEnable(Boolean flowControlEnable) {
        this.flowControlEnable = flowControlEnable;
    }

    @Generated
    public void setFastLeaveEnable(Boolean fastLeaveEnable) {
        this.fastLeaveEnable = fastLeaveEnable;
    }

    @Generated
    public void setDhcpL2RelaySettings(OswPortDhcpL2RelayVO dhcpL2RelaySettings) {
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
    }

    @Generated
    public void setDot1pPriority(Integer dot1pPriority) {
        this.dot1pPriority = dot1pPriority;
    }

    @Generated
    public void setTrustMode(Integer trustMode) {
        this.trustMode = trustMode;
    }

    @Generated
    public String toString() {
        return "BatchStackPortSettingOpenApiVO(unitList=" + this.getUnitList() + ", name=" + this.getName() + ", profileId=" + this.getProfileId() + ", profileOverrideEnable=" + this.getProfileOverrideEnable() + ", operation=" + this.getOperation() + ", linkSpeed=" + this.getLinkSpeed() + ", duplex=" + this.getDuplex() + ", dot1x=" + this.getDot1x() + ", poe=" + this.getPoe() + ", bandWidthCtrlType=" + this.getBandWidthCtrlType() + ", bandCtrl=" + this.getBandCtrl() + ", stormCtrl=" + this.getStormCtrl() + ", lldpMedEnable=" + this.getLldpMedEnable() + ", spanningTreeEnable=" + this.getSpanningTreeEnable() + ", spanningTreeSetting=" + this.getSpanningTreeSetting() + ", loopbackDetectEnable=" + this.getLoopbackDetectEnable() + ", loopbackDetectVlanBasedEnable=" + this.getLoopbackDetectVlanBasedEnable() + ", igmpFastLeaveEnable=" + this.getIgmpFastLeaveEnable() + ", mldFastLeaveEnable=" + this.getMldFastLeaveEnable() + ", portIsolationEnable=" + this.getPortIsolationEnable() + ", eeeEnable=" + this.getEeeEnable() + ", flowControlEnable=" + this.getFlowControlEnable() + ", fastLeaveEnable=" + this.getFastLeaveEnable() + ", dhcpL2RelaySettings=" + this.getDhcpL2RelaySettings() + ", dot1pPriority=" + this.getDot1pPriority() + ", trustMode=" + this.getTrustMode() + ")";
    }

    @Generated
    public BatchStackPortSettingOpenApiVO(List<OswStackUnitVO> unitList, String name, String profileId, Boolean profileOverrideEnable, String operation, Integer linkSpeed, Integer duplex, Integer dot1x, Integer poe, Integer bandWidthCtrlType, OswBandCtrlVO bandCtrl, OswStormCtrlVO stormCtrl, Boolean lldpMedEnable, Boolean spanningTreeEnable, SpanningTreeSettingVO spanningTreeSetting, Boolean loopbackDetectEnable, Boolean loopbackDetectVlanBasedEnable, Boolean igmpFastLeaveEnable, Boolean mldFastLeaveEnable, Boolean portIsolationEnable, Boolean eeeEnable, Boolean flowControlEnable, Boolean fastLeaveEnable, OswPortDhcpL2RelayVO dhcpL2RelaySettings, Integer dot1pPriority, Integer trustMode) {
        this.unitList = unitList;
        this.name = name;
        this.profileId = profileId;
        this.profileOverrideEnable = profileOverrideEnable;
        this.operation = operation;
        this.linkSpeed = linkSpeed;
        this.duplex = duplex;
        this.dot1x = dot1x;
        this.poe = poe;
        this.bandWidthCtrlType = bandWidthCtrlType;
        this.bandCtrl = bandCtrl;
        this.stormCtrl = stormCtrl;
        this.lldpMedEnable = lldpMedEnable;
        this.spanningTreeEnable = spanningTreeEnable;
        this.spanningTreeSetting = spanningTreeSetting;
        this.loopbackDetectEnable = loopbackDetectEnable;
        this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
        this.igmpFastLeaveEnable = igmpFastLeaveEnable;
        this.mldFastLeaveEnable = mldFastLeaveEnable;
        this.portIsolationEnable = portIsolationEnable;
        this.eeeEnable = eeeEnable;
        this.flowControlEnable = flowControlEnable;
        this.fastLeaveEnable = fastLeaveEnable;
        this.dhcpL2RelaySettings = dhcpL2RelaySettings;
        this.dot1pPriority = dot1pPriority;
        this.trustMode = trustMode;
    }

    @Generated
    public BatchStackPortSettingOpenApiVO() {
    }

    @Generated
    public static abstract class BatchStackPortSettingOpenApiVOBuilder<C extends BatchStackPortSettingOpenApiVO, B extends BatchStackPortSettingOpenApiVOBuilder<C, B>> {
        @Generated
        private List<OswStackUnitVO> unitList;
        @Generated
        private String name;
        @Generated
        private String profileId;
        @Generated
        private Boolean profileOverrideEnable;
        @Generated
        private String operation;
        @Generated
        private Integer linkSpeed;
        @Generated
        private Integer duplex;
        @Generated
        private Integer dot1x;
        @Generated
        private Integer poe;
        @Generated
        private Integer bandWidthCtrlType;
        @Generated
        private OswBandCtrlVO bandCtrl;
        @Generated
        private OswStormCtrlVO stormCtrl;
        @Generated
        private Boolean lldpMedEnable;
        @Generated
        private Boolean spanningTreeEnable;
        @Generated
        private SpanningTreeSettingVO spanningTreeSetting;
        @Generated
        private Boolean loopbackDetectEnable;
        @Generated
        private Boolean loopbackDetectVlanBasedEnable;
        @Generated
        private Boolean igmpFastLeaveEnable;
        @Generated
        private Boolean mldFastLeaveEnable;
        @Generated
        private Boolean portIsolationEnable;
        @Generated
        private Boolean eeeEnable;
        @Generated
        private Boolean flowControlEnable;
        @Generated
        private Boolean fastLeaveEnable;
        @Generated
        private OswPortDhcpL2RelayVO dhcpL2RelaySettings;
        @Generated
        private Integer dot1pPriority;
        @Generated
        private Integer trustMode;

        @Generated
        public B unitList(List<OswStackUnitVO> unitList) {
            this.unitList = unitList;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B profileId(String profileId) {
            this.profileId = profileId;
            return this.self();
        }

        @Generated
        public B profileOverrideEnable(Boolean profileOverrideEnable) {
            this.profileOverrideEnable = profileOverrideEnable;
            return this.self();
        }

        @Generated
        public B operation(String operation) {
            this.operation = operation;
            return this.self();
        }

        @Generated
        public B linkSpeed(Integer linkSpeed) {
            this.linkSpeed = linkSpeed;
            return this.self();
        }

        @Generated
        public B duplex(Integer duplex) {
            this.duplex = duplex;
            return this.self();
        }

        @Generated
        public B dot1x(Integer dot1x) {
            this.dot1x = dot1x;
            return this.self();
        }

        @Generated
        public B poe(Integer poe) {
            this.poe = poe;
            return this.self();
        }

        @Generated
        public B bandWidthCtrlType(Integer bandWidthCtrlType) {
            this.bandWidthCtrlType = bandWidthCtrlType;
            return this.self();
        }

        @Generated
        public B bandCtrl(OswBandCtrlVO bandCtrl) {
            this.bandCtrl = bandCtrl;
            return this.self();
        }

        @Generated
        public B stormCtrl(OswStormCtrlVO stormCtrl) {
            this.stormCtrl = stormCtrl;
            return this.self();
        }

        @Generated
        public B lldpMedEnable(Boolean lldpMedEnable) {
            this.lldpMedEnable = lldpMedEnable;
            return this.self();
        }

        @Generated
        public B spanningTreeEnable(Boolean spanningTreeEnable) {
            this.spanningTreeEnable = spanningTreeEnable;
            return this.self();
        }

        @Generated
        public B spanningTreeSetting(SpanningTreeSettingVO spanningTreeSetting) {
            this.spanningTreeSetting = spanningTreeSetting;
            return this.self();
        }

        @Generated
        public B loopbackDetectEnable(Boolean loopbackDetectEnable) {
            this.loopbackDetectEnable = loopbackDetectEnable;
            return this.self();
        }

        @Generated
        public B loopbackDetectVlanBasedEnable(Boolean loopbackDetectVlanBasedEnable) {
            this.loopbackDetectVlanBasedEnable = loopbackDetectVlanBasedEnable;
            return this.self();
        }

        @Generated
        public B igmpFastLeaveEnable(Boolean igmpFastLeaveEnable) {
            this.igmpFastLeaveEnable = igmpFastLeaveEnable;
            return this.self();
        }

        @Generated
        public B mldFastLeaveEnable(Boolean mldFastLeaveEnable) {
            this.mldFastLeaveEnable = mldFastLeaveEnable;
            return this.self();
        }

        @Generated
        public B portIsolationEnable(Boolean portIsolationEnable) {
            this.portIsolationEnable = portIsolationEnable;
            return this.self();
        }

        @Generated
        public B eeeEnable(Boolean eeeEnable) {
            this.eeeEnable = eeeEnable;
            return this.self();
        }

        @Generated
        public B flowControlEnable(Boolean flowControlEnable) {
            this.flowControlEnable = flowControlEnable;
            return this.self();
        }

        @Generated
        public B fastLeaveEnable(Boolean fastLeaveEnable) {
            this.fastLeaveEnable = fastLeaveEnable;
            return this.self();
        }

        @Generated
        public B dhcpL2RelaySettings(OswPortDhcpL2RelayVO dhcpL2RelaySettings) {
            this.dhcpL2RelaySettings = dhcpL2RelaySettings;
            return this.self();
        }

        @Generated
        public B dot1pPriority(Integer dot1pPriority) {
            this.dot1pPriority = dot1pPriority;
            return this.self();
        }

        @Generated
        public B trustMode(Integer trustMode) {
            this.trustMode = trustMode;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchStackPortSettingOpenApiVO.BatchStackPortSettingOpenApiVOBuilder(unitList=" + this.unitList + ", name=" + this.name + ", profileId=" + this.profileId + ", profileOverrideEnable=" + this.profileOverrideEnable + ", operation=" + this.operation + ", linkSpeed=" + this.linkSpeed + ", duplex=" + this.duplex + ", dot1x=" + this.dot1x + ", poe=" + this.poe + ", bandWidthCtrlType=" + this.bandWidthCtrlType + ", bandCtrl=" + this.bandCtrl + ", stormCtrl=" + this.stormCtrl + ", lldpMedEnable=" + this.lldpMedEnable + ", spanningTreeEnable=" + this.spanningTreeEnable + ", spanningTreeSetting=" + this.spanningTreeSetting + ", loopbackDetectEnable=" + this.loopbackDetectEnable + ", loopbackDetectVlanBasedEnable=" + this.loopbackDetectVlanBasedEnable + ", igmpFastLeaveEnable=" + this.igmpFastLeaveEnable + ", mldFastLeaveEnable=" + this.mldFastLeaveEnable + ", portIsolationEnable=" + this.portIsolationEnable + ", eeeEnable=" + this.eeeEnable + ", flowControlEnable=" + this.flowControlEnable + ", fastLeaveEnable=" + this.fastLeaveEnable + ", dhcpL2RelaySettings=" + this.dhcpL2RelaySettings + ", dot1pPriority=" + this.dot1pPriority + ", trustMode=" + this.trustMode + ")";
        }
    }

    @Generated
    private static final class BatchStackPortSettingOpenApiVOBuilderImpl
    extends BatchStackPortSettingOpenApiVOBuilder<BatchStackPortSettingOpenApiVO, BatchStackPortSettingOpenApiVOBuilderImpl> {
        @Generated
        private BatchStackPortSettingOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchStackPortSettingOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchStackPortSettingOpenApiVO build() {
            return new BatchStackPortSettingOpenApiVO(this);
        }
    }
}

