/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.VenueInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import lombok.Generated;

public class VenueInfoOpenApiVO {
    @NotNull(message="When configuring Venue Info, the parameter group cannot be null.")
    @Schema(name="group", description="Venue Group.Parameter group should be a value as follows: [0: Unspecified; 1: Assembly; 2: Business; 3: Educational; 4: Factory and Industrial; 5: Institutional; 6: Mercantile; 7: Residential; 8: Storage; 9: Utility and Miscellaneous; 10: Vehicular; 11: Outdoor]")
    private @NotNull(message="When configuring Venue Info, the parameter group cannot be null.") Integer group;
    @NotNull(message="When configuring Venue Info, the parameter type cannot be null.")
    @Schema(name="type", description="Venue Type.When Venue Group = 0, type should be a value as follows:[0: Unspecified]When Venue Group = 1, type should be a value as follows:[0: Unspecified Assembly;1: Arena;2: Stadium;3: Passenger Terminal (e.g., airport, bus, ferry, train station);4: Amphitheater;5: Amusement Park;6: Place of Worship;7: Convention Center;8: Library;9: Museum;10: Restaurant;11: Theater;12: Bar;13: Coffee Shop;14: Zoo or Aquarium;15: Emergency Coordination Center]When Venue Group = 2, type should be a value as follows:[0: Unspecified Business;1: Doctor or Dentist office;2: Bank;3: Fire Station;4: Police Station;5: Post Office;6: Professional Office;7: Research and Development Facility;8: Attorney Office]When Venue Group = 3, type should be a value as follows:[0: Unspecified Educational;1: School,Primary;2: School, Secondary;3: University or College;]When Venue Group = 4, type should be a value as follows:[0: Unspecified Factory and Industrial;1: Factory]When Venue Group = 5, type should be a value as follows:[0: Unspecified Institutional;1: Hospital;2: Long-Term Care Facility (e.g. Nursing home, Hospice, etc.);3: Alchohol and Drug Re-habilitation Center;4: Group Home;5: Prison or Jail;]When Venue Group = 6, type should be a value as follows:[0: Unspecified Mercantile;1: Retail Store;2: Grocery Market;3: Automotive Service Station;4: Shopping Mall;5: Gas Station;]When Venue Group = 7, type should be a value as follows:[0: Unspecified Residential;1: Private Residence;2: Hotel or Motel;3: Dormitory;4: Boarding House;]When Venue Group = 8, type should be a value as follows:[0: Unspecified Storage]When Venue Group = 9, type should be a value as follows:[0: Unspecified Utility and Miscellaneous]When Venue Group = 10, type should be a value as follows:[0: Unspecified Vehicular;1: Automobile or Truck;2: Airplane;3: Bus;4: Ferry;5: Ship or Boat;6: Train;7: Motor Bike;]When Venue Group = 11, type should be a value as follows:[0: Unspecified Outdoor;1: Muni-mesh Network;2: City Park;3: Rest Area;4: Traffic Control;5: Bus Stop;6: Kiosk]")
    private @NotNull(message="When configuring Venue Info, the parameter type cannot be null.") Integer type;
    @Nullable
    @Pattern(regexp="^$|^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="It should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.")
    @Schema(name="name", description="Network\u2019s venue name, identifying the physical location of the network.<br />Note: It should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.")
    private @Pattern(regexp="^$|^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="It should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.") String name;

    @Nullable
    public static VenueInfoVO toWebVO(VenueInfoOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return VenueInfoVO.builder().group(Integer.valueOf(0)).type(Integer.valueOf(0)).build();
        }
        VenueInfoVO webVO = new VenueInfoVO();
        webVO.setGroup(openApiVO.getGroup());
        webVO.setType(openApiVO.getType());
        webVO.setName(openApiVO.getName());
        return webVO;
    }

    @Generated
    protected VenueInfoOpenApiVO(VenueInfoOpenApiVOBuilder<?, ?> b2) {
        this.group = b2.group;
        this.type = b2.type;
        this.name = b2.name;
    }

    @Generated
    public static VenueInfoOpenApiVOBuilder<?, ?> builder() {
        return new VenueInfoOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getGroup() {
        return this.group;
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setGroup(Integer group) {
        this.group = group;
    }

    @Generated
    public void setType(Integer type) {
        this.type = type;
    }

    @Generated
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Generated
    public VenueInfoOpenApiVO(Integer group, Integer type, @Nullable String name) {
        this.group = group;
        this.type = type;
        this.name = name;
    }

    @Generated
    public VenueInfoOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "VenueInfoOpenApiVO(group=" + this.getGroup() + ", type=" + this.getType() + ", name=" + this.getName() + ")";
    }

    @Generated
    public static abstract class VenueInfoOpenApiVOBuilder<C extends VenueInfoOpenApiVO, B extends VenueInfoOpenApiVOBuilder<C, B>> {
        @Generated
        private Integer group;
        @Generated
        private Integer type;
        @Generated
        private String name;

        @Generated
        public B group(Integer group) {
            this.group = group;
            return this.self();
        }

        @Generated
        public B type(Integer type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B name(@Nullable String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "VenueInfoOpenApiVO.VenueInfoOpenApiVOBuilder(group=" + this.group + ", type=" + this.type + ", name=" + this.name + ")";
        }
    }

    @Generated
    private static final class VenueInfoOpenApiVOBuilderImpl
    extends VenueInfoOpenApiVOBuilder<VenueInfoOpenApiVO, VenueInfoOpenApiVOBuilderImpl> {
        @Generated
        private VenueInfoOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected VenueInfoOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public VenueInfoOpenApiVO build() {
            return new VenueInfoOpenApiVO(this);
        }
    }
}

