/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.CustomRateLimitSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.RateLimitSettingOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.Objects;
import lombok.Generated;

public class UpdateSsidRateLimitOpenApiVO {
    @Schema(name="clientRateLimit", description="Client rate limit config.")
    @Valid
    private RateLimitSettingOpenApiVO clientRateLimit;
    @Schema(name="ssidRateLimit", description="SSID rate limit config.")
    @Valid
    private RateLimitSettingOpenApiVO ssidRateLimit;

    public static OperationResponse validateRatelimit(UpdateSsidRateLimitOpenApiVO ssidVO) {
        RateLimitSettingOpenApiVO clientRateLimit = ssidVO.getClientRateLimit();
        RateLimitSettingOpenApiVO ssidRateLimit = ssidVO.getSsidRateLimit();
        if (clientRateLimit == null && ssidRateLimit == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidRateLimitOpenApiVO.validateClientRateLimit(clientRateLimit)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidRateLimitOpenApiVO.validateSsidRateLimit(ssidRateLimit)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static boolean validateClientRateLimit(RateLimitSettingOpenApiVO clientRateLimit) {
        boolean rateLimitEnable;
        if (clientRateLimit == null || clientRateLimit.getCustomSetting() == null) {
            return true;
        }
        CustomRateLimitSettingOpenApiVO customSetting = clientRateLimit.getCustomSetting();
        boolean downEnable = Boolean.TRUE.equals(customSetting.getDownLimitEnable());
        boolean upEnable = Boolean.TRUE.equals(customSetting.getUpLimitEnable());
        boolean bl = rateLimitEnable = downEnable || upEnable;
        if (!rateLimitEnable) {
            return true;
        }
        if (downEnable && customSetting.getDownLimit() == null) {
            return false;
        }
        if (upEnable && customSetting.getUpLimit() == null) {
            return false;
        }
        if (Objects.equals(customSetting.getDownLimitType(), 1)) {
            if (downEnable && (customSetting.getDownLimit() < 1 || customSetting.getDownLimit() > 10240)) {
                return false;
            }
            if (upEnable && (customSetting.getUpLimit() < 1 || customSetting.getUpLimit() > 10240)) {
                return false;
            }
        }
        if (Objects.equals(customSetting.getDownLimitType(), 0)) {
            if (downEnable && (customSetting.getDownLimit() < 1 || customSetting.getDownLimit() > 0xA00000)) {
                return false;
            }
            if (upEnable && (customSetting.getUpLimit() < 1 || customSetting.getUpLimit() > 0xA00000)) {
                return false;
            }
        }
        return true;
    }

    private static boolean validateSsidRateLimit(RateLimitSettingOpenApiVO ssidRateLimit) {
        boolean rateLimitEnable;
        if (ssidRateLimit == null || ssidRateLimit.getCustomSetting() == null) {
            return true;
        }
        CustomRateLimitSettingOpenApiVO customSetting = ssidRateLimit.getCustomSetting();
        boolean downEnable = Boolean.TRUE.equals(customSetting.getDownLimitEnable());
        boolean upEnable = Boolean.TRUE.equals(customSetting.getUpLimitEnable());
        boolean bl = rateLimitEnable = downEnable || upEnable;
        if (!rateLimitEnable) {
            return true;
        }
        if (downEnable && customSetting.getDownLimit() == null) {
            return false;
        }
        if (upEnable && customSetting.getUpLimit() == null) {
            return false;
        }
        if (Objects.equals(customSetting.getDownLimitType(), 1)) {
            if (downEnable && (customSetting.getDownLimit() < 1 || customSetting.getDownLimit() > 10240)) {
                return false;
            }
            if (upEnable && (customSetting.getUpLimit() < 1 || customSetting.getUpLimit() > 10240)) {
                return false;
            }
        }
        if (Objects.equals(customSetting.getDownLimitType(), 0)) {
            if (downEnable && (customSetting.getDownLimit() < 1 || customSetting.getDownLimit() > 0xA00000)) {
                return false;
            }
            if (upEnable && (customSetting.getUpLimit() < 1 || customSetting.getUpLimit() > 0xA00000)) {
                return false;
            }
        }
        return true;
    }

    @Generated
    public RateLimitSettingOpenApiVO getClientRateLimit() {
        return this.clientRateLimit;
    }

    @Generated
    public RateLimitSettingOpenApiVO getSsidRateLimit() {
        return this.ssidRateLimit;
    }

    @Generated
    public void setClientRateLimit(RateLimitSettingOpenApiVO clientRateLimit) {
        this.clientRateLimit = clientRateLimit;
    }

    @Generated
    public void setSsidRateLimit(RateLimitSettingOpenApiVO ssidRateLimit) {
        this.ssidRateLimit = ssidRateLimit;
    }

    @Generated
    public String toString() {
        return "UpdateSsidRateLimitOpenApiVO(clientRateLimit=" + this.getClientRateLimit() + ", ssidRateLimit=" + this.getSsidRateLimit() + ")";
    }

    @Generated
    public UpdateSsidRateLimitOpenApiVO() {
    }

    @Generated
    public UpdateSsidRateLimitOpenApiVO(RateLimitSettingOpenApiVO clientRateLimit, RateLimitSettingOpenApiVO ssidRateLimit) {
        this.clientRateLimit = clientRateLimit;
        this.ssidRateLimit = ssidRateLimit;
    }
}

