/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.access.OperationResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class UpdateSsidMultiCastOpenApiVO {
    @Schema(name="multiCastEnable", description="Whether to enable multicast to unicast, which is disabled by default; true: enable, false: disable")
    @NotNull(message="Parameter [multiCastEnable] should not be null.")
    private @NotNull(message="Parameter [multiCastEnable] should not be null.") Boolean multiCastEnable;
    @Schema(name="channelUtil", description="This item indicates that when the channel utilization reaches the threshold, multicast will no longer be converted to unicast, the default threshold is 100, and the value should be within the range of 0-100.")
    @Range(min=0L, max=100L, message="Value of channelUtil is from 0 to 100.")
    @NotNull(message="Parameter [channelUtil] should not be null.")
    private @Range(min=0L, max=100L, message="Value of channelUtil is from 0 to 100.") @NotNull(message="Parameter [channelUtil] should not be null.") Integer channelUtil;
    @Schema(name="arpCastEnable", description="Whether to enable ARP cast to unicast, which is disabled by default; true: enable, false: disable")
    @NotNull(message="Parameter [arpCastEnable] should not be null.")
    private @NotNull(message="Parameter [arpCastEnable] should not be null.") Boolean arpCastEnable;
    @Schema(name="ipv6CastEnable", description="Whether to enable IPv6 multicast to unicast, which is enabled by default; true: enable, false: disable")
    @NotNull(message="Parameter [ipv6CastEnable] should not be null.")
    private @NotNull(message="Parameter [ipv6CastEnable] should not be null.") Boolean ipv6CastEnable;
    @Schema(name="filterEnable", description="Whether to enable the multicast filter switch, which is disabled by default; true: enable, false: disable")
    @NotNull(message="Parameter [filterEnable] should not be null.")
    private @NotNull(message="Parameter [filterEnable] should not be null.") Boolean filterEnable;
    @Schema(name="filterMode", description="This item indicates the status of the filtering protocol, the lowest low bit indicates whether IGMP is enabled, the second low bit indicates whether MDNS is enabled, and the third low bit indicates whether Others is enabled; 1 means enable while 0 means disable. For example, 7(111) means that all are enabled, 1(001) means that only IGMP is enabled. ")
    private Integer filterMode;
    @Schema(name="macGroupId", description="This field represents MAC Group Profile ID. MAC Group Profile can be created using Create a new group profile interface, and MAC Group Profile ID can be obtained from Get group profile list by type interface.")
    private String macGroupId;

    public static OperationResponse validateMultiCast(UpdateSsidMultiCastOpenApiVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getMultiCastEnable()) && Objects.isNull(ssidVO.getChannelUtil())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (Boolean.TRUE.equals(ssidVO.getFilterEnable()) && Objects.isNull(ssidVO.getFilterMode())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getMultiCastEnable() {
        return this.multiCastEnable;
    }

    @Generated
    public Integer getChannelUtil() {
        return this.channelUtil;
    }

    @Generated
    public Boolean getArpCastEnable() {
        return this.arpCastEnable;
    }

    @Generated
    public Boolean getIpv6CastEnable() {
        return this.ipv6CastEnable;
    }

    @Generated
    public Boolean getFilterEnable() {
        return this.filterEnable;
    }

    @Generated
    public Integer getFilterMode() {
        return this.filterMode;
    }

    @Generated
    public String getMacGroupId() {
        return this.macGroupId;
    }

    @Generated
    public void setMultiCastEnable(Boolean multiCastEnable) {
        this.multiCastEnable = multiCastEnable;
    }

    @Generated
    public void setChannelUtil(Integer channelUtil) {
        this.channelUtil = channelUtil;
    }

    @Generated
    public void setArpCastEnable(Boolean arpCastEnable) {
        this.arpCastEnable = arpCastEnable;
    }

    @Generated
    public void setIpv6CastEnable(Boolean ipv6CastEnable) {
        this.ipv6CastEnable = ipv6CastEnable;
    }

    @Generated
    public void setFilterEnable(Boolean filterEnable) {
        this.filterEnable = filterEnable;
    }

    @Generated
    public void setFilterMode(Integer filterMode) {
        this.filterMode = filterMode;
    }

    @Generated
    public void setMacGroupId(String macGroupId) {
        this.macGroupId = macGroupId;
    }

    @Generated
    public String toString() {
        return "UpdateSsidMultiCastOpenApiVO(multiCastEnable=" + this.getMultiCastEnable() + ", channelUtil=" + this.getChannelUtil() + ", arpCastEnable=" + this.getArpCastEnable() + ", ipv6CastEnable=" + this.getIpv6CastEnable() + ", filterEnable=" + this.getFilterEnable() + ", filterMode=" + this.getFilterMode() + ", macGroupId=" + this.getMacGroupId() + ")";
    }

    @Generated
    public UpdateSsidMultiCastOpenApiVO() {
    }

    @Generated
    public UpdateSsidMultiCastOpenApiVO(Boolean multiCastEnable, Integer channelUtil, Boolean arpCastEnable, Boolean ipv6CastEnable, Boolean filterEnable, Integer filterMode, String macGroupId) {
        this.multiCastEnable = multiCastEnable;
        this.channelUtil = channelUtil;
        this.arpCastEnable = arpCastEnable;
        this.ipv6CastEnable = ipv6CastEnable;
        this.filterEnable = filterEnable;
        this.filterMode = filterMode;
        this.macGroupId = macGroupId;
    }
}

