/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;

public class UpdateSsidMacFilterOpenApiVO {
    @Schema(name="macFilterEnable", description="SSID MAC Filter global config status. True: enable, false: disable.")
    @NotNull(message="Parameter [macFilterEnable] should not be null.")
    private @NotNull(message="Parameter [macFilterEnable] should not be null.") Boolean macFilterEnable;
    @Schema(name="policy", description="SSID MAC Filter policy config mode; It should be a value as follows: 0: Deny List, 1: Allow List.")
    @NumberSet(value={0, 1}, message="Parameter [policy] should be 0 or 1")
    private Integer policy;
    @Schema(name="macFilterId", description="This field represents MAC Group Profile ID. MAC Group Profile can be created using Create a new group profile interface, and MAC Group Profile ID can be obtained from Get group profile list by type interface.")
    private String macFilterId;
    @Schema(name="ouiProfileIdList", description="This field represents OUI Profile ID list. OUI Profile can be created using Create OUI profile interface, and OUI Profile ID can be obtained from Get OUI profile summary list interface(This configuration applies to the Pro Site of the Omada Pro Controller only).")
    private List<String> ouiProfileIdList;

    public static OperationResponse validateMacFilter(UpdateSsidMacFilterOpenApiVO ssidVO) {
        if (!ssidVO.getMacFilterEnable().booleanValue()) {
            ssidVO.setPolicy(null);
            ssidVO.setMacFilterId(null);
            ssidVO.setOuiProfileIdList(null);
            return OperationResponse.SUCCESS;
        }
        if (T.a((String)ssidVO.getMacFilterId()) && CollectionUtils.isEmpty(ssidVO.getOuiProfileIdList())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    @Generated
    public Boolean getMacFilterEnable() {
        return this.macFilterEnable;
    }

    @Generated
    public Integer getPolicy() {
        return this.policy;
    }

    @Generated
    public String getMacFilterId() {
        return this.macFilterId;
    }

    @Generated
    public List<String> getOuiProfileIdList() {
        return this.ouiProfileIdList;
    }

    @Generated
    public void setMacFilterEnable(Boolean macFilterEnable) {
        this.macFilterEnable = macFilterEnable;
    }

    @Generated
    public void setPolicy(Integer policy) {
        this.policy = policy;
    }

    @Generated
    public void setMacFilterId(String macFilterId) {
        this.macFilterId = macFilterId;
    }

    @Generated
    public void setOuiProfileIdList(List<String> ouiProfileIdList) {
        this.ouiProfileIdList = ouiProfileIdList;
    }

    @Generated
    public String toString() {
        return "UpdateSsidMacFilterOpenApiVO(macFilterEnable=" + this.getMacFilterEnable() + ", policy=" + this.getPolicy() + ", macFilterId=" + this.getMacFilterId() + ", ouiProfileIdList=" + this.getOuiProfileIdList() + ")";
    }

    @Generated
    public UpdateSsidMacFilterOpenApiVO() {
    }

    @Generated
    public UpdateSsidMacFilterOpenApiVO(Boolean macFilterEnable, Integer policy, String macFilterId, List<String> ouiProfileIdList) {
        this.macFilterEnable = macFilterEnable;
        this.policy = policy;
        this.macFilterId = macFilterId;
        this.ouiProfileIdList = ouiProfileIdList;
    }
}

