/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.c.G;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class UpdateSsidDhcpOptionOpenApiVO {
    @Schema(name="dhcpEnable", description="SSID DHCP Option 82 global config status. True: enable, false: disable.")
    @NotNull(message="Parameter [dhcpEnable] should not be null.")
    private @NotNull(message="Parameter [dhcpEnable] should not be null.") Boolean dhcpEnable;
    @Schema(name="format", description="SSID DHCP Option 82 format config; It should be a value as follows: 0: ASCII; 1: Binary.")
    @NumberSet(value={0, 1}, message="Parameter [format] should be 0 or 1")
    private Integer format;
    @Schema(name="delimiter", description="SSID DHCP Option 82 delimiter config (A single arbitrary ASCII character is acceptable).")
    @Pattern(regexp="^[\\040-\\0176]$", message="A single arbitrary ASCII character is acceptable")
    private @Pattern(regexp="^[\\040-\\0176]$", message="A single arbitrary ASCII character is acceptable") String delimiter;
    @Schema(name="circuitId", description="SSID DHCP Option 82 Circuit-ID config. Circuit-ID is an array formed in the selected order, with each array element corresponding to the following enumeration values: 1: VLAN-ID; 2: AP Radio Mac-Address; 3: SSID-Type; 4: SSID-Name; 5: AP Ethernet MAC address; 6: Site-Name. As in the example [3,1,2,4], the following enumeration values are selected sequentially on the page: SSID-Type, VLAN-ID, AP Radio Mac-Address and SSID-Name.")
    private List<Integer> circuitId;
    @Schema(name="remoteId", description="SSID DHCP Option 82 Remote-ID config. Remote-ID is an array formed in the selected order, with each array element corresponding to the following enumeration values: 1: VLAN-ID; 2: AP Radio Mac-Address; 3: SSID-Type; 4: SSID-Name; 5: AP Ethernet MAC address; 6: Site-Name. As in the example [3,1,2,4], the following enumeration values are selected sequentially on the page: SSID-Type, VLAN-ID, AP Radio Mac-Address and SSID-Name.")
    private List<Integer> remoteId;

    public static OperationResponse validateDhcpOption82(UpdateSsidDhcpOptionOpenApiVO ssidVO) {
        if (ssidVO == null) {
            return OperationResponse.SUCCESS;
        }
        if (!Boolean.TRUE.equals(ssidVO.getDhcpEnable())) {
            return OperationResponse.SUCCESS;
        }
        if (Objects.isNull(ssidVO.getFormat()) || Objects.isNull(ssidVO.getDelimiter())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidDhcpOptionOpenApiVO.validateCircuitIdAndRemoteId(ssidVO)) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static boolean validateCircuitIdAndRemoteId(UpdateSsidDhcpOptionOpenApiVO ssidVO) {
        if (CollectionUtils.isEmpty(ssidVO.getCircuitId()) || CollectionUtils.isEmpty(ssidVO.getRemoteId())) {
            return false;
        }
        List<Integer> circuitIds = ssidVO.getCircuitId();
        for (Integer circuitId : circuitIds) {
            int circuitIdNum = I.a((Integer)circuitId);
            if (G.bH.contains(circuitIdNum)) continue;
            return false;
        }
        List<Integer> remoteIds = ssidVO.getRemoteId();
        for (Integer remoteId : remoteIds) {
            int remoteIdNum = I.a((Integer)remoteId);
            if (G.bH.contains(remoteIdNum)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Boolean getDhcpEnable() {
        return this.dhcpEnable;
    }

    @Generated
    public Integer getFormat() {
        return this.format;
    }

    @Generated
    public String getDelimiter() {
        return this.delimiter;
    }

    @Generated
    public List<Integer> getCircuitId() {
        return this.circuitId;
    }

    @Generated
    public List<Integer> getRemoteId() {
        return this.remoteId;
    }

    @Generated
    public void setDhcpEnable(Boolean dhcpEnable) {
        this.dhcpEnable = dhcpEnable;
    }

    @Generated
    public void setFormat(Integer format) {
        this.format = format;
    }

    @Generated
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Generated
    public void setCircuitId(List<Integer> circuitId) {
        this.circuitId = circuitId;
    }

    @Generated
    public void setRemoteId(List<Integer> remoteId) {
        this.remoteId = remoteId;
    }

    @Generated
    public String toString() {
        return "UpdateSsidDhcpOptionOpenApiVO(dhcpEnable=" + this.getDhcpEnable() + ", format=" + this.getFormat() + ", delimiter=" + this.getDelimiter() + ", circuitId=" + this.getCircuitId() + ", remoteId=" + this.getRemoteId() + ")";
    }

    @Generated
    public UpdateSsidDhcpOptionOpenApiVO() {
    }

    @Generated
    public UpdateSsidDhcpOptionOpenApiVO(Boolean dhcpEnable, Integer format, String delimiter, List<Integer> circuitId, List<Integer> remoteId) {
        this.dhcpEnable = dhcpEnable;
        this.format = format;
        this.delimiter = delimiter;
        this.circuitId = circuitId;
        this.remoteId = remoteId;
    }
}

