/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidEnterpriseSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPpskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidVlanCustomSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidVlanSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UpdateSsidBasicConfigOpenApiVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateSsidBasicConfigOpenApiVO.class);
    @Schema(name="name", description="SSID name. It should contain 1 to 32 UTF-8 characters.")
    @NotNull(message="Parameter [name] should not be null.")
    private @NotNull(message="Parameter [name] should not be null.") String name;
    @Schema(name="band", description="SSID band. The lowest bit indicates whether 2.4G is included; the second lowest bit indicates whether 5G is included; the third lowest bit indicates whether 6G is included; 1 means included while 0 means not included. For example, 7(111) means that 2G/5G/6G are enabled; 1(001) means that 2G is enabled. (When 5G is included\uff0cit means 5G/5G1/5G2 are enabled.)")
    @NotNull(message="Parameter [band] should not be null.")
    @Range(min=1L, max=7L, message="Parameter [band] should between 1 and 7.")
    private @NotNull(message="Parameter [band] should not be null.") @Range(min=1L, max=7L, message="Parameter [band] should between 1 and 7.") Integer band;
    @Schema(name="autoWanAccess", description="Whether to enable auto wan access. True: enable, false: disable.")
    private Boolean autoWanAccess;
    @Schema(name="guestNetEnable", description="SSID guest network config status. True: enable, false: disable.")
    @NotNull(message="Parameter [guestNetEnable] should not be null.")
    private @NotNull(message="Parameter [guestNetEnable] should not be null.") Boolean guestNetEnable;
    @Schema(name="security", description="SSID security mode; Security should be a value as follows: 0: None; 2: WPA-Enterprise; 3: WPA-Personal; 4: PPSK without RADIUS; 5: PPSK with RADIUS.")
    @NotNull(message="Parameter [security] should not be null.")
    private @NotNull(message="Parameter [security] should not be null.") Integer security;
    @Schema(name="oweEnable", description="Opportunistic Wireless Encryption, also known as Enhanced Open, is a certification provided by the Wi-Fi Alliance as part of the WPA3 wireless security standard. OWE will enable two wireless VAPs per radio, one for access of OWE-supported stations, and one for access of other stations. An SSID with OWE enabled will be counted as two SSID entries for 2G and 5G. Only for security is None and band contains 2.4G or 5G.")
    private Boolean oweEnable;
    @Schema(name="broadcast", description="SSID broadcast config status. True: enable, false: disable.")
    @NotNull(message="Parameter [broadcast] should not be null.")
    private @NotNull(message="Parameter [broadcast] should not be null.") Boolean broadcast;
    @Schema(name="vlanEnable", description="SSID VLAN config status. True: enable, false: disable.")
    @NotNull(message="Parameter [vlanEnable] should not be null.")
    private @NotNull(message="Parameter [vlanEnable] should not be null.") Boolean vlanEnable;
    @Schema(name="vlanId", description="SSID VLAN ID. This field is required when Parameter [vlanEnable] is true; It should be within the range of 1\u20134094. ")
    @Range(min=1L, max=4094L, message="Parameter [vlanEnable] must between 1 and 4094")
    private @Range(min=1L, max=4094L, message="Parameter [vlanEnable] must between 1 and 4094") Integer vlanId;
    @Valid
    @Schema(name="pskSetting", description="WPA-Personal SSID config. This is necessary when the value of security is 3(WPA-Personal), 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPskSettingOpenApiVO pskSetting;
    @Valid
    @Schema(name="entSetting", description="WPA-Enterprise SSID config. This is necessary when the value of security is 2(WPA-Enterprise).")
    private SsidEnterpriseSettingOpenApiVO entSetting;
    @Valid
    @Schema(name="ppskSetting", description="PPSK without RADIUS/PPSK without RADIUS SSID config. This is necessary when the value of security is 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPpskSettingOpenApiVO ppskSetting;
    @Schema(name="mloEnable", description="SSID MLO config status. True: enable, false: disable.")
    @NotNull(message="Parameter [mloEnable] should not be null.")
    private @NotNull(message="Parameter [mloEnable] should not be null.") Boolean mloEnable;
    @Schema(name="pmfMode", description="SSID PMF mode. It should be a value as follows: 1: Mandatory; 2: Capable; 3: Disable.")
    @NumberSet(value={1, 2, 3}, message="Parameter [pmfMode] should be 1 or 2 or 3")
    @NotNull(message="Parameter [pmfMode] should not be null.")
    private @NotNull(message="Parameter [pmfMode] should not be null.") Integer pmfMode;
    @Schema(name="enable11r", description="SSID 802.11r config status. True: enable, false: disable.")
    @NotNull(message="Parameter [enable11r] should not be null.")
    private @NotNull(message="Parameter [enable11r] should not be null.") Boolean enable11r;
    @Schema(name="hidePwd", description="If this field is true, the SSID password will be hidden.")
    private Boolean hidePwd;
    @Schema(name="greEnable", description="SSID EoGre Tunnel config status. True: enable, false: disable; This configuration can be enabled only when the [VPN - EoGre Tunnel] global config is enabled.")
    private Boolean greEnable;
    @Schema(name="vlanSetting", description="A newly added field is added to set the SSID VLAN configuration. ")
    private SsidVlanSettingOpenApiVO vlanSetting;
    @Schema(name="prohibitWifiShare", description="SSID prohibitWifiShare config status. True: enable, false: disable.")
    private Boolean prohibitWifiShare;

    public static OperationResponse validateSsidBasicConfig(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        OperationResponse validateRes = UpdateSsidBasicConfigOpenApiVO.validateAndFillSsidName(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        validateRes = UpdateSsidBasicConfigOpenApiVO.validateAndFillVlan(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        if (!(SsidVO.contain2G((Integer)ssidVO.getBand()) || SsidVO.contain5G((Integer)ssidVO.getBand()) || SsidVO.contain6G((Integer)ssidVO.getBand()))) {
            log.warn("Invalid band {} for ssid {}", (Object)ssidVO.getBand(), (Object)ssidVO.getName());
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = UpdateSsidBasicConfigOpenApiVO.validateAndFillSecurity(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        validateRes = UpdateSsidBasicConfigOpenApiVO.validateMlo(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = UpdateSsidBasicConfigOpenApiVO.validate11r(ssidVO);
        if (!validateRes.success()) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSsidName(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (!b.e((String)ssidVO.getName())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gf);
        }
        if (Objects.equals(ssidVO.getName(), "00000JAPAN")) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fW);
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillVlan(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (ssidVO.getVlanSetting() != null) {
            return UpdateSsidBasicConfigOpenApiVO.validateNewVlanSetting(ssidVO);
        }
        if (Boolean.TRUE.equals(ssidVO.getVlanEnable()) && (ssidVO.getVlanId() == null || !b.a((int)ssidVO.getVlanId(), (int)1, (int)4094))) {
            log.warn("Invalid vlanId {}", (Object)ssidVO.getVlanId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
        }
        SsidVlanSettingOpenApiVO ssidVlanSettingVO = new SsidVlanSettingOpenApiVO();
        if (Boolean.TRUE.equals(ssidVO.getVlanEnable())) {
            ssidVlanSettingVO.setMode(1);
            ssidVlanSettingVO.setCustomConfig((SsidVlanCustomSettingOpenApiVO)((SsidVlanCustomSettingOpenApiVO.SsidVlanCustomSettingOpenApiVOBuilder)((Object)((SsidVlanCustomSettingOpenApiVO.SsidVlanCustomSettingOpenApiVOBuilder)((Object)SsidVlanCustomSettingOpenApiVO.builder().customMode(1))).vlanPoolIds(ssidVO.getVlanId().toString()))).build());
        } else {
            ssidVlanSettingVO.setMode(0);
        }
        ssidVO.setVlanSetting(ssidVlanSettingVO);
        ssidVO.setVlanId(null);
        ssidVO.setVlanEnable(null);
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateNewVlanSetting(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        SsidVlanSettingOpenApiVO vlanSetting = ssidVO.getVlanSetting();
        if (Objects.equals(vlanSetting.getMode(), 0)) {
            return OperationResponse.SUCCESS;
        }
        if (Objects.equals(vlanSetting.getMode(), 1)) {
            if (vlanSetting.getCustomConfig() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            Integer customMode = vlanSetting.getCustomConfig().getCustomMode();
            if (Objects.equals(customMode, 0)) {
                Map<String, List<Integer>> lanNetworkVlanIds = vlanSetting.getCustomConfig().getLanNetworkVlanIds();
                if (Objects.isNull(vlanSetting.getCustomConfig().getLanNetworkId()) && CollectionUtils.isEmpty(lanNetworkVlanIds)) {
                    log.warn("LanNetworkVlanIds and lanNetworkIds are both null.");
                    return OperationResponse.PARAM_ERROR;
                }
                if (!CollectionUtils.isEmpty(lanNetworkVlanIds)) {
                    OperationResponse operationResponse = UpdateSsidBasicConfigOpenApiVO.checkVlanIds(lanNetworkVlanIds);
                    if (!operationResponse.success()) {
                        return operationResponse;
                    }
                    UpdateSsidBasicConfigOpenApiVO.fillLanNetworkIdAndBridgeVlan(ssidVO);
                }
            } else if (Objects.equals(customMode, 1)) {
                if (Objects.isNull(vlanSetting.getCustomConfig().getVlanPoolIds()) && Objects.isNull(vlanSetting.getCustomConfig().getVlanId())) {
                    log.warn("VlanPoolIds and vlanId are both null.");
                    return OperationResponse.PARAM_ERROR;
                }
                if (vlanSetting.getCustomConfig().getVlanPoolIds() != null) {
                    OperationResponse operationResponse = UpdateSsidBasicConfigOpenApiVO.parseVlansString(vlanSetting.getCustomConfig().getVlanPoolIds());
                    if (!operationResponse.success()) {
                        log.warn("parse vlanPoolId failed because {}, vlanPoolId:{}", (Object)operationResponse.getMsg(), (Object)vlanSetting.getCustomConfig().getVlanPoolIds());
                        return operationResponse;
                    }
                    List vlanIds = (List)operationResponse.getResult();
                    if (vlanIds.size() > 256) {
                        log.warn("One SSID supports up to 256 VLAN pool ID.");
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.gv);
                    }
                    Collections.sort(vlanIds);
                    ssidVO.setVlanId((Integer)vlanIds.get(0));
                    vlanSetting.getCustomConfig().setVlanId((Integer)vlanIds.get(0));
                }
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static void fillLanNetworkIdAndBridgeVlan(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        Map<String, List<Integer>> lanNetworkIdVlanIds = ssidVO.getVlanSetting().getCustomConfig().getLanNetworkVlanIds();
        ArrayList<Map.Entry<String, List<Integer>>> lanNetworkIdVlanIdsList = new ArrayList<Map.Entry<String, List<Integer>>>(lanNetworkIdVlanIds.entrySet());
        lanNetworkIdVlanIdsList.sort((o1, o2) -> {
            Integer i1 = (Integer)Collections.min((Collection)o1.getValue());
            Integer i2 = (Integer)Collections.min((Collection)o2.getValue());
            return i1 - i2;
        });
        ssidVO.getVlanSetting().getCustomConfig().setLanNetworkId((String)((Map.Entry)lanNetworkIdVlanIdsList.get(0)).getKey());
        ssidVO.getVlanSetting().getCustomConfig().setBridgeVlan((Integer)Collections.min((Collection)((Map.Entry)lanNetworkIdVlanIdsList.get(0)).getValue()));
    }

    private static OperationResponse parseVlansString(@Nonnull String vlans) {
        if (!vlans.matches("^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$")) {
            return OperationResponse.PARAM_ERROR;
        }
        ArrayList<Integer> vlanIds = new ArrayList<Integer>();
        String[] splitStrings = vlans.split(",");
        if (splitStrings == null || splitStrings.length == 0) {
            return OperationResponse.PARAM_ERROR;
        }
        if (splitStrings.length == 1 && splitStrings[0].matches("[\\d]+")) {
            if (!UpdateSsidBasicConfigOpenApiVO.checkVlanString(splitStrings[0])) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
            }
            Integer vlanNum = Integer.valueOf(splitStrings[0]);
            vlanIds.add(vlanNum);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
        }
        for (String splitString : splitStrings) {
            if (!UpdateSsidBasicConfigOpenApiVO.checkVlanString(splitString)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD);
            }
            OperationResponse operationResponse = UpdateSsidBasicConfigOpenApiVO.addVlansToMap(splitString, vlanIds);
            if (operationResponse.success()) continue;
            return operationResponse;
        }
        if (vlanIds.size() == 0) {
            return OperationResponse.PARAM_ERROR;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
    }

    private static boolean checkVlanString(String vlanString) {
        if (vlanString.matches("[\\d]+")) {
            int vlanNum = Integer.parseInt(vlanString);
            if (vlanNum < 1 || vlanNum > 4094) {
                log.warn("ssid vlan should be between 1 and 4094");
                return false;
            }
        } else if (vlanString.matches("^\\d+-\\d+$")) {
            String[] strings = vlanString.split("-");
            if (strings.length != 2) {
                log.warn("vlan should be like begin-end instead of {}", (Object)vlanString);
                return false;
            }
            int begin = Integer.parseInt(strings[0]);
            if (begin < 1 || begin > 4094) {
                log.warn("ssid begin vlan should be between 1 and 4094");
                return false;
            }
            int end = Integer.parseInt(strings[1]);
            if (end < 1 || end > 4094) {
                log.warn("ssid end vlan should be between 1 and 4094");
                return false;
            }
        } else {
            log.warn("vlanSplitString should be like 1 or 1-100");
            return false;
        }
        return true;
    }

    private static OperationResponse addVlansToMap(String splitString, List<Integer> vlanIds) {
        if (splitString.matches("[\\d]+")) {
            Integer vlanNum = Integer.valueOf(splitString);
            if (vlanIds.contains(vlanNum)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
            }
            vlanIds.add(vlanNum);
        } else {
            String[] strings = splitString.split("-");
            int begin = Integer.parseInt(strings[0]);
            int end = Integer.parseInt(strings[1]);
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            for (int i2 = begin; i2 <= end; ++i2) {
                if (vlanIds.contains(i2)) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
                }
                vlanIds.add(i2);
            }
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse checkVlanIds(Map<String, List<Integer>> lanNetworkVlanIds) {
        int total = 0;
        for (String lanNetworkId : lanNetworkVlanIds.keySet()) {
            List<Integer> vlanIds = lanNetworkVlanIds.get(lanNetworkId);
            total += vlanIds.size();
        }
        if (total > 256) {
            log.warn("One SSID supports up to 256 VLAN pool ID.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gv);
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSecurity(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        OperationResponse validateRes;
        Integer security = ssidVO.getSecurity();
        if (ssidVO.getSecurity() == null) {
            log.warn("Invalid security mode: null");
            return OperationResponse.PARAM_ERROR;
        }
        switch (security) {
            case 0: {
                validateRes = OperationResponse.SUCCESS;
                break;
            }
            case 2: {
                validateRes = UpdateSsidBasicConfigOpenApiVO.validateEnterprise(ssidVO);
                break;
            }
            case 3: {
                validateRes = UpdateSsidBasicConfigOpenApiVO.validatePersonal(ssidVO, true);
                break;
            }
            case 4: 
            case 5: {
                validateRes = UpdateSsidBasicConfigOpenApiVO.validatePPSK(ssidVO);
                break;
            }
            default: {
                log.warn("Invalid SecurityMode {} of ssid {}", (Object)ssidVO.getSecurity(), (Object)ssidVO.getName());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.fN);
            }
        }
        return validateRes;
    }

    private static OperationResponse validateEnterprise(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        boolean notSupportMix;
        boolean contain6G = SsidVO.contain6G((Integer)ssidVO.getBand());
        if (!SsidVO.validateWpaEntVersion((Integer)ssidVO.getEntSetting().getVersionEnt(), (boolean)contain6G)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEncryption((Integer)ssidVO.getEntSetting().getEncryptionEnt())) {
            return OperationResponse.PARAM_ERROR;
        }
        boolean bl = notSupportMix = SsidVO.onlyEnable6G((Integer)ssidVO.getBand()) || SsidVO.contain6G((Integer)ssidVO.getBand()) && Boolean.TRUE.equals(ssidVO.getMloEnable());
        if (!SsidVO.validateWpa3Encryption((Integer)ssidVO.getEntSetting().getVersionEnt(), (Integer)ssidVO.getEntSetting().getEncryptionEnt(), (boolean)notSupportMix)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getEntSetting().getGikRekeyEntEnable().booleanValue()) {
            if (ssidVO.getEntSetting().getIntervalEntType() == null || ssidVO.getEntSetting().getRekeyEntInterval() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            if (!SsidVO.validateGroupKeyUpdatePeriod((Integer)ssidVO.getEntSetting().getRekeyEntInterval(), (Integer)ssidVO.getEntSetting().getIntervalEntType())) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        if (!SsidVO.validatePmfForEnterprise((Integer)ssidVO.getEntSetting().getVersionEnt(), (Integer)ssidVO.getEntSetting().getEncryptionEnt(), (Integer)ssidVO.getPmfMode())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidBasicConfigOpenApiVO.validateWpaEntNasidMode(ssidVO.getEntSetting().getNasIdMode())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (T.b((String)ssidVO.getEntSetting().getNasId()) && (ssidVO.getEntSetting().getNasIdMode() == null || ssidVO.getEntSetting().getNasIdMode() != 2)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getEntSetting().getNasIdMode() != null && ssidVO.getEntSetting().getNasIdMode() == 2 && !UpdateSsidBasicConfigOpenApiVO.validateWpaEntNasid(ssidVO.getEntSetting().getNasId())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidBasicConfigOpenApiVO.validateMloForPskAndEnt(ssidVO.getEntSetting().getVersionEnt(), ssidVO.getMloEnable())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validatePersonal(UpdateSsidBasicConfigOpenApiVO ssidVO, boolean needCheckSecurityKey) {
        if (ssidVO == null || ssidVO.getPskSetting() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (needCheckSecurityKey && T.a((String)ssidVO.getPskSetting().getSecurityKey())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!T.a((String)ssidVO.getPskSetting().getSecurityKey()) && !SsidVO.validatePsk((String)ssidVO.getPskSetting().getSecurityKey())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fT);
        }
        OperationResponse checkPersonalWpaResp = UpdateSsidBasicConfigOpenApiVO.validatePersonalWpaVersion(ssidVO);
        if (!checkPersonalWpaResp.success()) {
            return checkPersonalWpaResp;
        }
        OperationResponse checkPersonalGroupKeyResp = UpdateSsidBasicConfigOpenApiVO.validatePersonalGroupKeyConfig(ssidVO);
        if (!checkPersonalGroupKeyResp.success()) {
            return checkPersonalWpaResp;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validatePPSK(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (ssidVO == null || ssidVO.getPpskSetting() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse ops = UpdateSsidBasicConfigOpenApiVO.validatePersonal(ssidVO, false);
        if (!ops.success()) {
            return ops;
        }
        SsidPpskSettingOpenApiVO ppskSettingVO = ssidVO.getPpskSetting();
        if (4 == ssidVO.getSecurity()) {
            if (ppskSettingVO.getPpskProfileId() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            if (ppskSettingVO.getRadiusProfileId() != null) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        if (5 == ssidVO.getSecurity() && ppskSettingVO.getRadiusProfileId() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validate11r(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (Boolean.TRUE.equals(ssidVO.getMloEnable()) && Boolean.TRUE.equals(ssidVO.getEnable11r())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateMlo(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        boolean contain6g;
        if (!Boolean.TRUE.equals(ssidVO.getMloEnable())) {
            return OperationResponse.SUCCESS;
        }
        int bandNum = 0;
        if (SsidVO.contain2G((Integer)ssidVO.getBand())) {
            ++bandNum;
        }
        if (SsidVO.contain5G((Integer)ssidVO.getBand())) {
            ++bandNum;
        }
        if (contain6g = SsidVO.contain6G((Integer)ssidVO.getBand())) {
            ++bandNum;
        }
        if (bandNum < 2) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validatePersonalWpaVersion(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (ssidVO.getPskSetting().getVersionPsk() == null || ssidVO.getPskSetting().getEncryptionPsk() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        boolean contain6G = SsidVO.contain6G((Integer)ssidVO.getBand());
        if (!SsidVO.validateWpaPskVersion((Integer)ssidVO.getPskSetting().getVersionPsk(), (boolean)contain6G)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEncryption((Integer)ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpa3PskEncryption((Integer)ssidVO.getPskSetting().getVersionPsk(), (Integer)ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validatePmfForPsk((Integer)ssidVO.getPskSetting().getVersionPsk(), (Integer)ssidVO.getPmfMode(), (Integer)ssidVO.getBand(), (Boolean)ssidVO.getMloEnable())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!UpdateSsidBasicConfigOpenApiVO.validateMloForPskAndEnt(ssidVO.getPskSetting().getVersionPsk(), ssidVO.getMloEnable())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    private static boolean validateMloForPskAndEnt(Integer versionPsk, Boolean mloEnable) {
        if (!Boolean.TRUE.equals(mloEnable)) {
            return true;
        }
        return Objects.equals(versionPsk, 4);
    }

    private static OperationResponse validatePersonalGroupKeyConfig(UpdateSsidBasicConfigOpenApiVO ssidVO) {
        if (ssidVO.getPskSetting().getGikRekeyPskEnable() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (ssidVO.getPskSetting().getGikRekeyPskEnable().booleanValue()) {
            if (ssidVO.getPskSetting().getIntervalPskType() == null || ssidVO.getPskSetting().getRekeyPskInterval() == null) {
                return OperationResponse.PARAM_ERROR;
            }
            if (!SsidVO.validateGroupKeyUpdatePeriod((Integer)ssidVO.getPskSetting().getRekeyPskInterval(), (Integer)ssidVO.getPskSetting().getIntervalPskType())) {
                return OperationResponse.PARAM_ERROR;
            }
        }
        return OperationResponse.SUCCESS;
    }

    public static boolean validateWpaEntNasidMode(Integer mode) {
        return mode == null || mode == 0 || mode == 1 || mode == 2;
    }

    public static boolean validateWpaEntNasid(String nasId) {
        if (T.a((String)nasId)) {
            return false;
        }
        byte[] bytes = nasId.getBytes(StandardCharsets.UTF_8);
        return bytes.length <= 64;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Boolean getAutoWanAccess() {
        return this.autoWanAccess;
    }

    @Generated
    public Boolean getGuestNetEnable() {
        return this.guestNetEnable;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public Boolean getOweEnable() {
        return this.oweEnable;
    }

    @Generated
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public Boolean getVlanEnable() {
        return this.vlanEnable;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public SsidPskSettingOpenApiVO getPskSetting() {
        return this.pskSetting;
    }

    @Generated
    public SsidEnterpriseSettingOpenApiVO getEntSetting() {
        return this.entSetting;
    }

    @Generated
    public SsidPpskSettingOpenApiVO getPpskSetting() {
        return this.ppskSetting;
    }

    @Generated
    public Boolean getMloEnable() {
        return this.mloEnable;
    }

    @Generated
    public Integer getPmfMode() {
        return this.pmfMode;
    }

    @Generated
    public Boolean getEnable11r() {
        return this.enable11r;
    }

    @Generated
    public Boolean getHidePwd() {
        return this.hidePwd;
    }

    @Generated
    public Boolean getGreEnable() {
        return this.greEnable;
    }

    @Generated
    public SsidVlanSettingOpenApiVO getVlanSetting() {
        return this.vlanSetting;
    }

    @Generated
    public Boolean getProhibitWifiShare() {
        return this.prohibitWifiShare;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setAutoWanAccess(Boolean autoWanAccess) {
        this.autoWanAccess = autoWanAccess;
    }

    @Generated
    public void setGuestNetEnable(Boolean guestNetEnable) {
        this.guestNetEnable = guestNetEnable;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setOweEnable(Boolean oweEnable) {
        this.oweEnable = oweEnable;
    }

    @Generated
    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setVlanEnable(Boolean vlanEnable) {
        this.vlanEnable = vlanEnable;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setPskSetting(SsidPskSettingOpenApiVO pskSetting) {
        this.pskSetting = pskSetting;
    }

    @Generated
    public void setEntSetting(SsidEnterpriseSettingOpenApiVO entSetting) {
        this.entSetting = entSetting;
    }

    @Generated
    public void setPpskSetting(SsidPpskSettingOpenApiVO ppskSetting) {
        this.ppskSetting = ppskSetting;
    }

    @Generated
    public void setMloEnable(Boolean mloEnable) {
        this.mloEnable = mloEnable;
    }

    @Generated
    public void setPmfMode(Integer pmfMode) {
        this.pmfMode = pmfMode;
    }

    @Generated
    public void setEnable11r(Boolean enable11r) {
        this.enable11r = enable11r;
    }

    @Generated
    public void setHidePwd(Boolean hidePwd) {
        this.hidePwd = hidePwd;
    }

    @Generated
    public void setGreEnable(Boolean greEnable) {
        this.greEnable = greEnable;
    }

    @Generated
    public void setVlanSetting(SsidVlanSettingOpenApiVO vlanSetting) {
        this.vlanSetting = vlanSetting;
    }

    @Generated
    public void setProhibitWifiShare(Boolean prohibitWifiShare) {
        this.prohibitWifiShare = prohibitWifiShare;
    }

    @Generated
    public String toString() {
        return "UpdateSsidBasicConfigOpenApiVO(name=" + this.getName() + ", band=" + this.getBand() + ", autoWanAccess=" + this.getAutoWanAccess() + ", guestNetEnable=" + this.getGuestNetEnable() + ", security=" + this.getSecurity() + ", oweEnable=" + this.getOweEnable() + ", broadcast=" + this.getBroadcast() + ", vlanEnable=" + this.getVlanEnable() + ", vlanId=" + this.getVlanId() + ", pskSetting=" + this.getPskSetting() + ", entSetting=" + this.getEntSetting() + ", ppskSetting=" + this.getPpskSetting() + ", mloEnable=" + this.getMloEnable() + ", pmfMode=" + this.getPmfMode() + ", enable11r=" + this.getEnable11r() + ", hidePwd=" + this.getHidePwd() + ", greEnable=" + this.getGreEnable() + ", vlanSetting=" + this.getVlanSetting() + ", prohibitWifiShare=" + this.getProhibitWifiShare() + ")";
    }

    @Generated
    public UpdateSsidBasicConfigOpenApiVO() {
    }

    @Generated
    public UpdateSsidBasicConfigOpenApiVO(String name, Integer band, Boolean autoWanAccess, Boolean guestNetEnable, Integer security, Boolean oweEnable, Boolean broadcast, Boolean vlanEnable, Integer vlanId, SsidPskSettingOpenApiVO pskSetting, SsidEnterpriseSettingOpenApiVO entSetting, SsidPpskSettingOpenApiVO ppskSetting, Boolean mloEnable, Integer pmfMode, Boolean enable11r, Boolean hidePwd, Boolean greEnable, SsidVlanSettingOpenApiVO vlanSetting, Boolean prohibitWifiShare) {
        this.name = name;
        this.band = band;
        this.autoWanAccess = autoWanAccess;
        this.guestNetEnable = guestNetEnable;
        this.security = security;
        this.oweEnable = oweEnable;
        this.broadcast = broadcast;
        this.vlanEnable = vlanEnable;
        this.vlanId = vlanId;
        this.pskSetting = pskSetting;
        this.entSetting = entSetting;
        this.ppskSetting = ppskSetting;
        this.mloEnable = mloEnable;
        this.pmfMode = pmfMode;
        this.enable11r = enable11r;
        this.hidePwd = hidePwd;
        this.greEnable = greEnable;
        this.vlanSetting = vlanSetting;
        this.prohibitWifiShare = prohibitWifiShare;
    }
}

