/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.f.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPskSettingForIpptOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.UpdateSsidBasicConfigOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSsidBasicConfigForIpptOpenApiVO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateSsidBasicConfigForIpptOpenApiVO.class);
    @Schema(name="name", description="SSID name. It should contain 1 to 32 UTF-8 characters.")
    @NotNull(message="Parameter [name] should not be null.")
    private @NotNull(message="Parameter [name] should not be null.") String name;
    @Schema(name="band", description="SSID band. The lowest bit indicates whether 2.4G is included; the second lowest bit indicates whether 5G is included; the third lowest bit indicates whether 6G is included; 1 means included while 0 means not included. For example, 7(111) means that 2G/5G/6G are enabled; 1(001) means that 2G is enabled. (When 5G is included\uff0cit means 5G/5G1/5G2 are enabled.)")
    @NotNull(message="Parameter [band] should not be null.")
    @NumberSet(value={1}, message="Parameter [band] should be 1.")
    private @NotNull(message="Parameter [band] should not be null.") Integer band;
    @Schema(name="autoWanAccess", description="Whether to enable auto wan access. True: enable, false: disable.")
    private Boolean autoWanAccess;
    @Schema(name="security", description="SSID security mode; Security should be a value as follows: 0: None; 2: WPA-Enterprise; 3: WPA-Personal; 4: PPSK without RADIUS; 5: PPSK with RADIUS.")
    @NotNull(message="Parameter [security] should not be null.")
    private @NotNull(message="Parameter [security] should not be null.") Integer security;
    @Schema(name="oweEnable", description="Opportunistic Wireless Encryption, also known as Enhanced Open, is a certification provided by the Wi-Fi Alliance as part of the WPA3 wireless security standard. OWE will enable two wireless VAPs per radio, one for access of OWE-supported stations, and one for access of other stations. An SSID with OWE enabled will be counted as two SSID entries for 2G and 5G. Only for security is None and band contains 2.4G or 5G.")
    private Boolean oweEnable;
    @Schema(name="broadcast", description="SSID broadcast config status. True: enable, false: disable.")
    @NotNull(message="Parameter [broadcast] should not be null.")
    private @NotNull(message="Parameter [broadcast] should not be null.") Boolean broadcast;
    @Valid
    @Schema(name="pskSetting", description="WPA-Personal SSID config. This is necessary when the value of security is 3(WPA-Personal).")
    private SsidPskSettingForIpptOpenApiVO pskSetting;

    public static OperationResponse validateSsidBasicConfig(UpdateSsidBasicConfigForIpptOpenApiVO ssidVO) {
        OperationResponse validateRes = UpdateSsidBasicConfigForIpptOpenApiVO.validateAndFillSsidName(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        if (!SsidVO.contain2G((Integer)ssidVO.getBand()) || SsidVO.contain5G((Integer)ssidVO.getBand()) || SsidVO.contain6G((Integer)ssidVO.getBand())) {
            log.warn("Invalid band {} for ssid {}", (Object)ssidVO.getBand(), (Object)ssidVO.getName());
            return OperationResponse.PARAM_ERROR;
        }
        validateRes = UpdateSsidBasicConfigForIpptOpenApiVO.validateAndFillSecurity(ssidVO);
        if (!validateRes.success()) {
            return validateRes;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSsidName(UpdateSsidBasicConfigForIpptOpenApiVO ssidVO) {
        if (!b.e((String)ssidVO.getName())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.gf);
        }
        if (Objects.equals(ssidVO.getName(), "00000JAPAN")) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fW);
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validateAndFillSecurity(UpdateSsidBasicConfigForIpptOpenApiVO ssidVO) {
        OperationResponse validateRes;
        Integer security = ssidVO.getSecurity();
        if (ssidVO.getSecurity() == null) {
            log.warn("Invalid security mode: null");
            return OperationResponse.PARAM_ERROR;
        }
        switch (security) {
            case 0: {
                validateRes = OperationResponse.SUCCESS;
                break;
            }
            case 3: {
                validateRes = UpdateSsidBasicConfigForIpptOpenApiVO.validatePersonal(ssidVO, true);
                break;
            }
            default: {
                log.warn("Invalid SecurityMode {} of ssid {}", (Object)ssidVO.getSecurity(), (Object)ssidVO.getName());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.fN);
            }
        }
        return validateRes;
    }

    private static OperationResponse validatePersonal(UpdateSsidBasicConfigForIpptOpenApiVO ssidVO, boolean needCheckSecurityKey) {
        if (ssidVO == null || ssidVO.getPskSetting() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        if (needCheckSecurityKey && T.a((String)ssidVO.getPskSetting().getSecurityKey())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!T.a((String)ssidVO.getPskSetting().getSecurityKey()) && !SsidVO.validatePsk((String)ssidVO.getPskSetting().getSecurityKey())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fT);
        }
        OperationResponse checkPersonalWpaResp = UpdateSsidBasicConfigForIpptOpenApiVO.validatePersonalWpaVersion(ssidVO);
        if (!checkPersonalWpaResp.success()) {
            return checkPersonalWpaResp;
        }
        return OperationResponse.SUCCESS;
    }

    private static OperationResponse validatePersonalWpaVersion(UpdateSsidBasicConfigForIpptOpenApiVO ssidVO) {
        if (ssidVO.getPskSetting().getVersionPsk() == null || ssidVO.getPskSetting().getEncryptionPsk() == null) {
            return OperationResponse.PARAM_ERROR;
        }
        boolean contain6G = SsidVO.contain6G((Integer)ssidVO.getBand());
        if (!SsidVO.validateWpaPskVersion((Integer)ssidVO.getPskSetting().getVersionPsk(), (boolean)contain6G)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpaEncryption((Integer)ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!SsidVO.validateWpa3PskEncryption((Integer)ssidVO.getPskSetting().getVersionPsk(), (Integer)ssidVO.getPskSetting().getEncryptionPsk())) {
            return OperationResponse.PARAM_ERROR;
        }
        return OperationResponse.SUCCESS;
    }

    public static UpdateSsidBasicConfigOpenApiVO toConfigVO(UpdateSsidBasicConfigForIpptOpenApiVO vo) {
        UpdateSsidBasicConfigOpenApiVO res = new UpdateSsidBasicConfigOpenApiVO();
        if (Objects.isNull(vo)) {
            return res;
        }
        res.setName(vo.getName());
        res.setBand(vo.getBand());
        res.setBroadcast(vo.getBroadcast());
        res.setAutoWanAccess(vo.getAutoWanAccess());
        res.setSecurity(vo.getSecurity());
        res.setOweEnable(vo.getOweEnable());
        if (vo.getPskSetting() != null) {
            res.setPskSetting(vo.getPskSetting().toVO());
        }
        return res;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Boolean getAutoWanAccess() {
        return this.autoWanAccess;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public Boolean getOweEnable() {
        return this.oweEnable;
    }

    @Generated
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public SsidPskSettingForIpptOpenApiVO getPskSetting() {
        return this.pskSetting;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setAutoWanAccess(Boolean autoWanAccess) {
        this.autoWanAccess = autoWanAccess;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setOweEnable(Boolean oweEnable) {
        this.oweEnable = oweEnable;
    }

    @Generated
    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setPskSetting(SsidPskSettingForIpptOpenApiVO pskSetting) {
        this.pskSetting = pskSetting;
    }

    @Generated
    public String toString() {
        return "UpdateSsidBasicConfigForIpptOpenApiVO(name=" + this.getName() + ", band=" + this.getBand() + ", autoWanAccess=" + this.getAutoWanAccess() + ", security=" + this.getSecurity() + ", oweEnable=" + this.getOweEnable() + ", broadcast=" + this.getBroadcast() + ", pskSetting=" + this.getPskSetting() + ")";
    }

    @Generated
    public UpdateSsidBasicConfigForIpptOpenApiVO() {
    }

    @Generated
    public UpdateSsidBasicConfigForIpptOpenApiVO(String name, Integer band, Boolean autoWanAccess, Integer security, Boolean oweEnable, Boolean broadcast, SsidPskSettingForIpptOpenApiVO pskSetting) {
        this.name = name;
        this.band = band;
        this.autoWanAccess = autoWanAccess;
        this.security = security;
        this.oweEnable = oweEnable;
        this.broadcast = broadcast;
        this.pskSetting = pskSetting;
    }
}

