/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.EapMethodOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.RealmVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class RealmOpenApiVO {
    @NotNull(message="When configuring NAI Realm, the parameter name cannot be null.")
    @Schema(name="name", description="The name of the NAI realm. Usually the domain name of the service provider.<br />Note: It should contain 1 to 64 UTF-8 characters.")
    private @NotNull(message="When configuring NAI Realm, the parameter name cannot be null.") String name;
    @NotNull(message="When configuring NAI Realm, the parameter encoding cannot be null.")
    @NumberSet(value={0, 1}, message="Parameter encoding should be a value as follows:[0,1].")
    @Schema(name="encoding", description="Encoding format.<br />Parameter encoding should be a value as follows:[0:RFC4282;1:UTF-8].")
    private @NotNull(message="When configuring NAI Realm, the parameter encoding cannot be null.") Integer encoding;
    @NotNull(message="When configuring NAI Realm, the parameter eap cannot be null.")
    @Size(max=4, message="Up to 4 entries are allowed for the EAP Method list.")
    @Valid
    @Schema(name="eap", description="EAP Method list.<br />Note: Up to 4 entries are allowed for the EAP Method list.")
    private @NotNull(message="When configuring NAI Realm, the parameter eap cannot be null.") @Size(max=4, message="Up to 4 entries are allowed for the EAP Method list.") @Valid List<EapMethodOpenApiVO> eap;

    public static RealmVO toWebVO(RealmOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        RealmVO webVO = new RealmVO();
        webVO.setName(openApiVO.getName());
        webVO.setEncoding(openApiVO.getEncoding());
        webVO.setEap(openApiVO.getEap().stream().map(eapMethodOpenApiVO -> EapMethodOpenApiVO.toWebVO(eapMethodOpenApiVO)).toList());
        return webVO;
    }

    @Generated
    protected RealmOpenApiVO(RealmOpenApiVOBuilder<?, ?> b2) {
        this.name = b2.name;
        this.encoding = b2.encoding;
        this.eap = b2.eap;
    }

    @Generated
    public static RealmOpenApiVOBuilder<?, ?> builder() {
        return new RealmOpenApiVOBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getEncoding() {
        return this.encoding;
    }

    @Generated
    public List<EapMethodOpenApiVO> getEap() {
        return this.eap;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEncoding(Integer encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setEap(List<EapMethodOpenApiVO> eap) {
        this.eap = eap;
    }

    @Generated
    public RealmOpenApiVO(String name, Integer encoding, List<EapMethodOpenApiVO> eap) {
        this.name = name;
        this.encoding = encoding;
        this.eap = eap;
    }

    @Generated
    public RealmOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "RealmOpenApiVO(name=" + this.getName() + ", encoding=" + this.getEncoding() + ", eap=" + this.getEap() + ")";
    }

    @Generated
    public static abstract class RealmOpenApiVOBuilder<C extends RealmOpenApiVO, B extends RealmOpenApiVOBuilder<C, B>> {
        @Generated
        private String name;
        @Generated
        private Integer encoding;
        @Generated
        private List<EapMethodOpenApiVO> eap;

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B encoding(Integer encoding) {
            this.encoding = encoding;
            return this.self();
        }

        @Generated
        public B eap(List<EapMethodOpenApiVO> eap) {
            this.eap = eap;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RealmOpenApiVO.RealmOpenApiVOBuilder(name=" + this.name + ", encoding=" + this.encoding + ", eap=" + this.eap + ")";
        }
    }

    @Generated
    private static final class RealmOpenApiVOBuilderImpl
    extends RealmOpenApiVOBuilder<RealmOpenApiVO, RealmOpenApiVOBuilderImpl> {
        @Generated
        private RealmOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected RealmOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealmOpenApiVO build() {
            return new RealmOpenApiVO(this);
        }
    }
}

