/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.QuickCreateSsidDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

public class QuickCreateSsidOpenApiVO {
    @Schema(name="wlanId", description="WLAN ID")
    private String wlanId;
    @Schema(name="ssidName", description="SSID name. It should contain 1 to 32 UTF-8 characters.")
    @NotNull(message="Parameter [ssidName] should not be null.")
    private @NotNull(message="Parameter [ssidName] should not be null.") String ssidName;
    @Schema(name="band", description="SSID band. The lowest bit indicates whether 2.4G is included; the second lowest bit indicates whether 5G is included; the third lowest bit indicates whether 6G is included; 1 means included while 0 means not included. For example, 7(111) means that 2G/5G/6G are enabled; 1(001) means that 2G is enabled. (When 5G is included\uff0cit means 5G/5G1/5G2 are enabled.)")
    @NotNull(message="Parameter [band] should not be null.")
    private @NotNull(message="Parameter [band] should not be null.") Integer band;
    @Schema(name="deviceType", description="SSID device type, identify which devices this SSID will take effect; The lowest bit indicates whether [EAP] is included, the second low bit indicates whether [Gateway] is included, 1 means included while 0 means not included; For example, 3(11) means that EAP/Gateway is enabled, 1(01) means that EAP is enabled.")
    private Integer deviceType;
    @Schema(name="security", description="SSID security mode; Security should be a value as follows: 0: None; 2: WPA-Enterprise; 3: WPA-Personal; ")
    @NotNull(message="Parameter [security] should not be null.")
    @NumberSet(value={0, 2, 3}, message="Parameter [security] should be [0, 2, 3]")
    private @NotNull(message="Parameter [security] should not be null.") Integer security;
    @Schema(name="securityKey", description="WPA-Personal SSID password. This is necessary when the value of security is 3(WPA-Personal);It should contain 8-63 printable ASCII characters or 8-63 hexadecimal digits.")
    private String securityKey;
    @Schema(name="guestNetEnable", description="SSID guest network config status. True: enable, false: disable.\nWith this option enabled, the guest network will prevent wireless clients on the same AP from communicating with each other. This may restrain the functions of AirPlay, ChromeCast, Sonos devices, screen mirroring, and wireless printers.")
    private Boolean guestNetworkEnable;
    @Schema(name="radiusProfileId", description="This field represents RADIUS Profile ID. RADIUS Profile(RADIUS Profile Template) can be created using Create a new Radius profile(Create a new Radius profile template) interface, and RADIUS Profile ID(RADIUS Profile Template ID) can be obtained from Get Radius profile list(Get Radius profile template list) interface.")
    private String radiusProfileId;

    public static QuickCreateSsidDTO toDTO(QuickCreateSsidOpenApiVO quickCreateSsidOpenApiVO) {
        return QuickCreateSsidDTO.builder().wlanId(quickCreateSsidOpenApiVO.getWlanId()).ssidName(quickCreateSsidOpenApiVO.getSsidName()).band(quickCreateSsidOpenApiVO.getBand()).deviceType(quickCreateSsidOpenApiVO.getDeviceType()).security(quickCreateSsidOpenApiVO.getSecurity()).securityKey(quickCreateSsidOpenApiVO.getSecurityKey()).guestNetworkEnable(quickCreateSsidOpenApiVO.getGuestNetworkEnable()).radiusProfileId(quickCreateSsidOpenApiVO.getRadiusProfileId()).build();
    }

    @Generated
    public String getWlanId() {
        return this.wlanId;
    }

    @Generated
    public String getSsidName() {
        return this.ssidName;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public String getSecurityKey() {
        return this.securityKey;
    }

    @Generated
    public Boolean getGuestNetworkEnable() {
        return this.guestNetworkEnable;
    }

    @Generated
    public String getRadiusProfileId() {
        return this.radiusProfileId;
    }

    @Generated
    public void setWlanId(String wlanId) {
        this.wlanId = wlanId;
    }

    @Generated
    public void setSsidName(String ssidName) {
        this.ssidName = ssidName;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
    }

    @Generated
    public void setGuestNetworkEnable(Boolean guestNetworkEnable) {
        this.guestNetworkEnable = guestNetworkEnable;
    }

    @Generated
    public void setRadiusProfileId(String radiusProfileId) {
        this.radiusProfileId = radiusProfileId;
    }

    @Generated
    public QuickCreateSsidOpenApiVO() {
    }

    @Generated
    public QuickCreateSsidOpenApiVO(String wlanId, String ssidName, Integer band, Integer deviceType, Integer security, String securityKey, Boolean guestNetworkEnable, String radiusProfileId) {
        this.wlanId = wlanId;
        this.ssidName = ssidName;
        this.band = band;
        this.deviceType = deviceType;
        this.security = security;
        this.securityKey = securityKey;
        this.guestNetworkEnable = guestNetworkEnable;
        this.radiusProfileId = radiusProfileId;
    }
}

