/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.PlmnIdOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.RealmOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.RoamingConsortiumOiOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.VenueInfoOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.HotspotV2SettingVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class HotspotV2SettingOpenApiVO {
    @NotNull(message="When configuring Hotspot2.0, the parameter hotspotV2Enable cannot be null.")
    @Schema(name="hotspotV2Enable", description="Whether Hotspot2.0 is enabled.<br />If hotspot2.0 is disabled, other parameters in Hotspot2.0 will be invalid.")
    private @NotNull(message="When configuring Hotspot2.0, the parameter hotspotV2Enable cannot be null.") Boolean hotspotV2Enable;
    @Nullable
    @NumberSet(value={0, 1, 2, 3, 4, 5, 14, 15}, message="Parameter networkType should be a value as follows:[0, 1, 2, 3, 4, 5, 14, 15].")
    @Schema(name="networkType", description="Specify the 802.11u network type.<br /> Parameter networkType should be a value as follows: [0: Private network; 1: Private network with guest access; 2: Chargeable public network; 3: Free public network; 4: Personal device network; 5: Emergency services only network; 14: Test or experimental; 15: Wildcard].")
    private Integer networkType;
    @Nullable
    @Size(max=6, message="Up to 6 entries are allowed for the PLMN ID list.")
    @Valid
    @Schema(name="plmnId", description="PLMN ID list, enter PLMN ID of 802.11u 3GPP cellular network.<br />Note: Up to 6 entries are allowed for the PLMN ID list.")
    private @Size(max=6, message="Up to 6 entries are allowed for the PLMN ID list.") @Valid List<PlmnIdOpenApiVO> plmnId;
    @Nullable
    @Size(max=3, message="Up to 3 entries are allowed for the Roaming Consortium Oi list.")
    @Valid
    @Schema(name="roamingConsortiumOi", description="Roaming Consortium Oi list, enter the 802.11u roaming organization identifiers.<br />Note: Up to 3 entries are allowed for the Roaming Consortium Oi list.")
    private @Size(max=3, message="Up to 3 entries are allowed for the Roaming Consortium Oi list.") @Valid List<RoamingConsortiumOiOpenApiVO> roamingConsortiumOi;
    @Nullable
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Pattern(regexp="^$|^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?$", message="Incorrect domain name format.")
    @Schema(name="operatorDomain", description="Enter the domain name of the hotspot operator.<br />For example, www.omadanetworks.com.")
    private @Pattern(regexp="^$|^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?$", message="Incorrect domain name format.") String operatorDomain;
    @Nullable
    @Schema(name="dgafDisable", description="Whether to enable DGAF(downstream group-addressed forwarding) disable mode.<br />In DGAF disable mode, the AP will not forward downstream multicast and broadcast packets.")
    private Boolean dgafDisable;
    @Nullable
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @Pattern(regexp="^$|^[A-F0-9]{1}[02468ACE]{1}([-][A-F0-9]{2}){5}$", message="HESSID should be consistent with one of the BSSIDs of the APs in the zone.")
    @Schema(name="heSsid", description="Homogenous Extended Service Set Identifier, it is used to identify the same type of ESS network set.<br />Note: HESSID should be consistent with one of the BSSIDs of the APs in the zone.")
    private @Pattern(regexp="^$|^[A-F0-9]{1}[02468ACE]{1}([-][A-F0-9]{2}){5}$", message="HESSID should be consistent with one of the BSSIDs of the APs in the zone.") String heSsid;
    @Nullable
    @Schema(name="internet", description="Internet access support status (network reachability), which indicates that the network is allowed to access the Internet.")
    private Boolean internet;
    @Nullable
    @NumberSet(value={0, 1, 2, 3, 4, 5, 6, 7}, message="Parameter availabilityIpv4 should be a value as follows:[0, 1, 2, 3, 4, 5, 6, 7].")
    @Schema(name="availabilityIpv4", description="Available type information of IPv4 addresses.<br />Parameter availabilityIpv4 should be a value as follows: [0: Address type not available; 1: Public IPv4 address available; 2: Port-restricted IPv4 address available; 3: Single NATed private IPv4 address available; 4: Double NATed private IPv4 address available; 5: Port-restricted IPv4 address and single NATed IPv4 address available; 6: Port-restricted IPv4 address and double NATed IPv4 address available; 7: Availability of the address type is not known].")
    private Integer availabilityIpv4;
    @Nullable
    @NumberSet(value={0, 1, 2}, message="Parameter availabilityIpv6 should be a value as follows:[0, 1, 2].")
    @Schema(name="availabilityIpv6", description="Available type information of IPv6 addresses.<br /> Parameter availabilityIpv6 should be a value as follows: [0: Address type not available; 1: Address type available; 2: Availability of the address type not known].")
    private Integer availabilityIpv6;
    @Nullable
    @Pattern(regexp="^$|^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter operatorFriendly should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.")
    @Schema(name="operatorFriendly", description="Hotspot network operator friendly name.<br />Note:Parameter operatorFriendly should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.")
    private @Pattern(regexp="^$|^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,62}[\\041-\\0176]$", message="Parameter operatorFriendly should contain between 1 and 64 visible ASCII characters, with no Spaces at the beginning and end, and Spaces in between.") String operatorFriendly;
    @Nullable
    @Valid
    @Schema(name="venueInfo", description="Indicates the venue information using the combination of the network's venue group and venue type (using the international building code).")
    private VenueInfoOpenApiVO venueInfo;
    @Nullable
    @Size(max=10, message="Up to 10 entries are allowed for the Realm list.")
    @Valid
    @Schema(name="realmList", description="Add a profile to identify and describe a NAI (Network Access Identifier) realm accessible using the AP, and the method that this NAI realm uses for authentication.<br />Note: Up to 10 entries are allowed for the NAI Realm list.")
    private @Size(max=10, message="Up to 10 entries are allowed for the Realm list.") @Valid List<RealmOpenApiVO> realmList;

    public static HotspotV2SettingVO toWebVO(HotspotV2SettingOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        HotspotV2SettingVO webVO = new HotspotV2SettingVO();
        if (Boolean.TRUE.equals(openApiVO.getHotspotV2Enable())) {
            webVO.setHotspotV2Enable(openApiVO.getHotspotV2Enable());
            webVO.setNetworkType(Integer.valueOf(Objects.isNull(openApiVO.getNetworkType()) ? 0 : openApiVO.getNetworkType()));
            webVO.setPlmnId((List)Optional.ofNullable(openApiVO.getPlmnId()).map(plmnIdOpenApiVOS -> plmnIdOpenApiVOS.stream().map(plmnIdOpenApiVO -> PlmnIdOpenApiVO.toWebVO(plmnIdOpenApiVO)).toList()).orElse(new ArrayList()));
            webVO.setRoamingConsortiumOi((List)Optional.ofNullable(openApiVO.getRoamingConsortiumOi()).map(roamingConsortiumOiOpenApiVOS -> roamingConsortiumOiOpenApiVOS.stream().map(roamingConsortiumOiOpenApiVO -> RoamingConsortiumOiOpenApiVO.toWebVO(roamingConsortiumOiOpenApiVO)).toList()).orElse(new ArrayList()));
            webVO.setOperatorDomain(openApiVO.getOperatorDomain());
            webVO.setDgaf(openApiVO.getDgafDisable());
            webVO.setHeSsid(openApiVO.getHeSsid());
            webVO.setInternet(openApiVO.getInternet());
            webVO.setAvailabilityIpv4(Integer.valueOf(Objects.isNull(openApiVO.getAvailabilityIpv4()) ? 0 : openApiVO.getAvailabilityIpv4()));
            webVO.setAvailabilityIpv6(Integer.valueOf(Objects.isNull(openApiVO.getAvailabilityIpv6()) ? 0 : openApiVO.getAvailabilityIpv6()));
            webVO.setOperatorFriendly(openApiVO.getOperatorFriendly());
            webVO.setVenueInfo(VenueInfoOpenApiVO.toWebVO(openApiVO.getVenueInfo()));
            webVO.setRealmList((List)Optional.ofNullable(openApiVO.getRealmList()).map(realmOpenApiVOS -> realmOpenApiVOS.stream().map(realmOpenApiVO -> RealmOpenApiVO.toWebVO(realmOpenApiVO)).toList()).orElse(new ArrayList()));
        } else {
            webVO.setHotspotV2Enable(Boolean.valueOf(false));
        }
        return webVO;
    }

    @Generated
    protected HotspotV2SettingOpenApiVO(HotspotV2SettingOpenApiVOBuilder<?, ?> b2) {
        this.hotspotV2Enable = b2.hotspotV2Enable;
        this.networkType = b2.networkType;
        this.plmnId = b2.plmnId;
        this.roamingConsortiumOi = b2.roamingConsortiumOi;
        this.operatorDomain = b2.operatorDomain;
        this.dgafDisable = b2.dgafDisable;
        this.heSsid = b2.heSsid;
        this.internet = b2.internet;
        this.availabilityIpv4 = b2.availabilityIpv4;
        this.availabilityIpv6 = b2.availabilityIpv6;
        this.operatorFriendly = b2.operatorFriendly;
        this.venueInfo = b2.venueInfo;
        this.realmList = b2.realmList;
    }

    @Generated
    public static HotspotV2SettingOpenApiVOBuilder<?, ?> builder() {
        return new HotspotV2SettingOpenApiVOBuilderImpl();
    }

    @Generated
    public Boolean getHotspotV2Enable() {
        return this.hotspotV2Enable;
    }

    @Nullable
    @Generated
    public Integer getNetworkType() {
        return this.networkType;
    }

    @Nullable
    @Generated
    public List<PlmnIdOpenApiVO> getPlmnId() {
        return this.plmnId;
    }

    @Nullable
    @Generated
    public List<RoamingConsortiumOiOpenApiVO> getRoamingConsortiumOi() {
        return this.roamingConsortiumOi;
    }

    @Nullable
    @Generated
    public String getOperatorDomain() {
        return this.operatorDomain;
    }

    @Nullable
    @Generated
    public Boolean getDgafDisable() {
        return this.dgafDisable;
    }

    @Nullable
    @Generated
    public String getHeSsid() {
        return this.heSsid;
    }

    @Nullable
    @Generated
    public Boolean getInternet() {
        return this.internet;
    }

    @Nullable
    @Generated
    public Integer getAvailabilityIpv4() {
        return this.availabilityIpv4;
    }

    @Nullable
    @Generated
    public Integer getAvailabilityIpv6() {
        return this.availabilityIpv6;
    }

    @Nullable
    @Generated
    public String getOperatorFriendly() {
        return this.operatorFriendly;
    }

    @Nullable
    @Generated
    public VenueInfoOpenApiVO getVenueInfo() {
        return this.venueInfo;
    }

    @Nullable
    @Generated
    public List<RealmOpenApiVO> getRealmList() {
        return this.realmList;
    }

    @Generated
    public void setHotspotV2Enable(Boolean hotspotV2Enable) {
        this.hotspotV2Enable = hotspotV2Enable;
    }

    @Generated
    public void setNetworkType(@Nullable Integer networkType) {
        this.networkType = networkType;
    }

    @Generated
    public void setPlmnId(@Nullable List<PlmnIdOpenApiVO> plmnId) {
        this.plmnId = plmnId;
    }

    @Generated
    public void setRoamingConsortiumOi(@Nullable List<RoamingConsortiumOiOpenApiVO> roamingConsortiumOi) {
        this.roamingConsortiumOi = roamingConsortiumOi;
    }

    @Generated
    public void setOperatorDomain(@Nullable String operatorDomain) {
        this.operatorDomain = operatorDomain;
    }

    @Generated
    public void setDgafDisable(@Nullable Boolean dgafDisable) {
        this.dgafDisable = dgafDisable;
    }

    @Generated
    public void setHeSsid(@Nullable String heSsid) {
        this.heSsid = heSsid;
    }

    @Generated
    public void setInternet(@Nullable Boolean internet) {
        this.internet = internet;
    }

    @Generated
    public void setAvailabilityIpv4(@Nullable Integer availabilityIpv4) {
        this.availabilityIpv4 = availabilityIpv4;
    }

    @Generated
    public void setAvailabilityIpv6(@Nullable Integer availabilityIpv6) {
        this.availabilityIpv6 = availabilityIpv6;
    }

    @Generated
    public void setOperatorFriendly(@Nullable String operatorFriendly) {
        this.operatorFriendly = operatorFriendly;
    }

    @Generated
    public void setVenueInfo(@Nullable VenueInfoOpenApiVO venueInfo) {
        this.venueInfo = venueInfo;
    }

    @Generated
    public void setRealmList(@Nullable List<RealmOpenApiVO> realmList) {
        this.realmList = realmList;
    }

    @Generated
    public HotspotV2SettingOpenApiVO(Boolean hotspotV2Enable, @Nullable Integer networkType, @Nullable List<PlmnIdOpenApiVO> plmnId, @Nullable List<RoamingConsortiumOiOpenApiVO> roamingConsortiumOi, @Nullable String operatorDomain, @Nullable Boolean dgafDisable, @Nullable String heSsid, @Nullable Boolean internet, @Nullable Integer availabilityIpv4, @Nullable Integer availabilityIpv6, @Nullable String operatorFriendly, @Nullable VenueInfoOpenApiVO venueInfo, @Nullable List<RealmOpenApiVO> realmList) {
        this.hotspotV2Enable = hotspotV2Enable;
        this.networkType = networkType;
        this.plmnId = plmnId;
        this.roamingConsortiumOi = roamingConsortiumOi;
        this.operatorDomain = operatorDomain;
        this.dgafDisable = dgafDisable;
        this.heSsid = heSsid;
        this.internet = internet;
        this.availabilityIpv4 = availabilityIpv4;
        this.availabilityIpv6 = availabilityIpv6;
        this.operatorFriendly = operatorFriendly;
        this.venueInfo = venueInfo;
        this.realmList = realmList;
    }

    @Generated
    public HotspotV2SettingOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "HotspotV2SettingOpenApiVO(hotspotV2Enable=" + this.getHotspotV2Enable() + ", networkType=" + this.getNetworkType() + ", plmnId=" + this.getPlmnId() + ", roamingConsortiumOi=" + this.getRoamingConsortiumOi() + ", operatorDomain=" + this.getOperatorDomain() + ", dgafDisable=" + this.getDgafDisable() + ", heSsid=" + this.getHeSsid() + ", internet=" + this.getInternet() + ", availabilityIpv4=" + this.getAvailabilityIpv4() + ", availabilityIpv6=" + this.getAvailabilityIpv6() + ", operatorFriendly=" + this.getOperatorFriendly() + ", venueInfo=" + this.getVenueInfo() + ", realmList=" + this.getRealmList() + ")";
    }

    @Generated
    public static abstract class HotspotV2SettingOpenApiVOBuilder<C extends HotspotV2SettingOpenApiVO, B extends HotspotV2SettingOpenApiVOBuilder<C, B>> {
        @Generated
        private Boolean hotspotV2Enable;
        @Generated
        private Integer networkType;
        @Generated
        private List<PlmnIdOpenApiVO> plmnId;
        @Generated
        private List<RoamingConsortiumOiOpenApiVO> roamingConsortiumOi;
        @Generated
        private String operatorDomain;
        @Generated
        private Boolean dgafDisable;
        @Generated
        private String heSsid;
        @Generated
        private Boolean internet;
        @Generated
        private Integer availabilityIpv4;
        @Generated
        private Integer availabilityIpv6;
        @Generated
        private String operatorFriendly;
        @Generated
        private VenueInfoOpenApiVO venueInfo;
        @Generated
        private List<RealmOpenApiVO> realmList;

        @Generated
        public B hotspotV2Enable(Boolean hotspotV2Enable) {
            this.hotspotV2Enable = hotspotV2Enable;
            return this.self();
        }

        @Generated
        public B networkType(@Nullable Integer networkType) {
            this.networkType = networkType;
            return this.self();
        }

        @Generated
        public B plmnId(@Nullable List<PlmnIdOpenApiVO> plmnId) {
            this.plmnId = plmnId;
            return this.self();
        }

        @Generated
        public B roamingConsortiumOi(@Nullable List<RoamingConsortiumOiOpenApiVO> roamingConsortiumOi) {
            this.roamingConsortiumOi = roamingConsortiumOi;
            return this.self();
        }

        @Generated
        public B operatorDomain(@Nullable String operatorDomain) {
            this.operatorDomain = operatorDomain;
            return this.self();
        }

        @Generated
        public B dgafDisable(@Nullable Boolean dgafDisable) {
            this.dgafDisable = dgafDisable;
            return this.self();
        }

        @Generated
        public B heSsid(@Nullable String heSsid) {
            this.heSsid = heSsid;
            return this.self();
        }

        @Generated
        public B internet(@Nullable Boolean internet) {
            this.internet = internet;
            return this.self();
        }

        @Generated
        public B availabilityIpv4(@Nullable Integer availabilityIpv4) {
            this.availabilityIpv4 = availabilityIpv4;
            return this.self();
        }

        @Generated
        public B availabilityIpv6(@Nullable Integer availabilityIpv6) {
            this.availabilityIpv6 = availabilityIpv6;
            return this.self();
        }

        @Generated
        public B operatorFriendly(@Nullable String operatorFriendly) {
            this.operatorFriendly = operatorFriendly;
            return this.self();
        }

        @Generated
        public B venueInfo(@Nullable VenueInfoOpenApiVO venueInfo) {
            this.venueInfo = venueInfo;
            return this.self();
        }

        @Generated
        public B realmList(@Nullable List<RealmOpenApiVO> realmList) {
            this.realmList = realmList;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "HotspotV2SettingOpenApiVO.HotspotV2SettingOpenApiVOBuilder(hotspotV2Enable=" + this.hotspotV2Enable + ", networkType=" + this.networkType + ", plmnId=" + this.plmnId + ", roamingConsortiumOi=" + this.roamingConsortiumOi + ", operatorDomain=" + this.operatorDomain + ", dgafDisable=" + this.dgafDisable + ", heSsid=" + this.heSsid + ", internet=" + this.internet + ", availabilityIpv4=" + this.availabilityIpv4 + ", availabilityIpv6=" + this.availabilityIpv6 + ", operatorFriendly=" + this.operatorFriendly + ", venueInfo=" + this.venueInfo + ", realmList=" + this.realmList + ")";
        }
    }

    @Generated
    private static final class HotspotV2SettingOpenApiVOBuilderImpl
    extends HotspotV2SettingOpenApiVOBuilder<HotspotV2SettingOpenApiVO, HotspotV2SettingOpenApiVOBuilderImpl> {
        @Generated
        private HotspotV2SettingOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected HotspotV2SettingOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HotspotV2SettingOpenApiVO build() {
            return new HotspotV2SettingOpenApiVO(this);
        }
    }
}

