/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.AuthenticationParamOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.EapMethodVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class EapMethodOpenApiVO {
    @NotNull(message="When configuring EAP Method, the parameter method cannot be null.")
    @NumberSet(value={0, 1, 2, 5, 6, 13, 18, 21, 23, 25, 28, 29}, message="EAP method should be a value as follows:[0, 1, 2, 5, 6, 13, 18, 21, 23, 25, 28, 29]")
    @Schema(name="method", description="EAP authentication method supported by the NAI realm.<br />Parameter method should be a value as follows:[0:None;1:Identity;2:Notification;5:One-Time Password (OTP);6:Generic Token Card (GTC);13:EAP-TLS;18:GSM Subscriber Identity Modules (EAP-SIM);21:EAP-TTLS;23:EAP-AKA Authentication;25:PEAP;28:CRYPTOCard;29:EAP-MSCHAP-V2]")
    private @NotNull(message="When configuring EAP Method, the parameter method cannot be null.") Integer method;
    @NotNull(message="When configuring EAP Method, the parameter param cannot be null.")
    @Size(max=4, message="Up to 4 entries are allowed for the Authentication Param list.")
    @Schema(name="param", description="Authentication Param list, configure the EAP authentication parameter identifier and authentication parameters.<br />Note: Up to 4 entries are allowed for the Authentication Param list.")
    private @NotNull(message="When configuring EAP Method, the parameter param cannot be null.") @Size(max=4, message="Up to 4 entries are allowed for the Authentication Param list.") List<AuthenticationParamOpenApiVO> param;

    public static EapMethodVO toWebVO(EapMethodOpenApiVO openApiVO) {
        if (Objects.isNull(openApiVO)) {
            return null;
        }
        EapMethodVO webVO = new EapMethodVO();
        webVO.setMethod(openApiVO.getMethod());
        webVO.setParam(openApiVO.getParam().stream().map(authenticationParamOpenApiVO -> AuthenticationParamOpenApiVO.toWebVO(authenticationParamOpenApiVO)).toList());
        return webVO;
    }

    @Generated
    protected EapMethodOpenApiVO(EapMethodOpenApiVOBuilder<?, ?> b2) {
        this.method = b2.method;
        this.param = b2.param;
    }

    @Generated
    public static EapMethodOpenApiVOBuilder<?, ?> builder() {
        return new EapMethodOpenApiVOBuilderImpl();
    }

    @Generated
    public Integer getMethod() {
        return this.method;
    }

    @Generated
    public List<AuthenticationParamOpenApiVO> getParam() {
        return this.param;
    }

    @Generated
    public void setMethod(Integer method) {
        this.method = method;
    }

    @Generated
    public void setParam(List<AuthenticationParamOpenApiVO> param) {
        this.param = param;
    }

    @Generated
    public EapMethodOpenApiVO(Integer method, List<AuthenticationParamOpenApiVO> param) {
        this.method = method;
        this.param = param;
    }

    @Generated
    public EapMethodOpenApiVO() {
    }

    @Generated
    public String toString() {
        return "EapMethodOpenApiVO(method=" + this.getMethod() + ", param=" + this.getParam() + ")";
    }

    @Generated
    public static abstract class EapMethodOpenApiVOBuilder<C extends EapMethodOpenApiVO, B extends EapMethodOpenApiVOBuilder<C, B>> {
        @Generated
        private Integer method;
        @Generated
        private List<AuthenticationParamOpenApiVO> param;

        @Generated
        public B method(Integer method) {
            this.method = method;
            return this.self();
        }

        @Generated
        public B param(List<AuthenticationParamOpenApiVO> param) {
            this.param = param;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "EapMethodOpenApiVO.EapMethodOpenApiVOBuilder(method=" + this.method + ", param=" + this.param + ")";
        }
    }

    @Generated
    private static final class EapMethodOpenApiVOBuilderImpl
    extends EapMethodOpenApiVOBuilder<EapMethodOpenApiVO, EapMethodOpenApiVOBuilderImpl> {
        @Generated
        private EapMethodOpenApiVOBuilderImpl() {
        }

        @Override
        @Generated
        protected EapMethodOpenApiVOBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EapMethodOpenApiVO build() {
            return new EapMethodOpenApiVO(this);
        }
    }
}

