/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.CustomRateLimitSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.HotspotV2SettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.RateLimitSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidDhcpOptionOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidEnterpriseSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidMacFilterOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidMultiCastOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPpskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidVlanSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidWlanScheduleOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.embed.SsidRateControlOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class CreateSsidV2OpenApiVO {
    @Schema(name="name", description="SSID name. It should contain 1 to 32 UTF-8 characters.")
    @NotNull(message="Parameter [name] should not be null.")
    private @NotNull(message="Parameter [name] should not be null.") String name;
    @Schema(name="deviceType", description="SSID device type, identify which devices this SSID will take effect; The lowest bit indicates whether [EAP] is included, the second low bit indicates whether [Gateway] is included, 1 means included while 0 means not included; For example, 3(11) means that EAP/Gateway is enabled, 1(01) means that EAP is enabled.")
    private Integer deviceType;
    @Schema(name="band", description="SSID band. The lowest bit indicates whether 2.4G is included; the second lowest bit indicates whether 5G is included; the third lowest bit indicates whether 6G is included; 1 means included while 0 means not included. For example, 7(111) means that 2G/5G/6G are enabled; 1(001) means that 2G is enabled. (When 5G is included\uff0cit means 5G/5G1/5G2 are enabled.)")
    @NotNull(message="Parameter [band] should not be null.")
    private @NotNull(message="Parameter [band] should not be null.") Integer band;
    @Schema(name="guestNetEnable", description="SSID guest network config status. True: enable, false: disable.\nWith this option enabled, the guest network will prevent wireless clients on the same AP from communicating with each other. This may restrain the functions of AirPlay, ChromeCast, Sonos devices, screen mirroring, and wireless printers.")
    private Boolean guestNetEnable;
    @Schema(name="security", description="SSID security mode; Security should be a value as follows: 0: None; 2: WPA-Enterprise; 3: WPA-Personal; 4: PPSK without RADIUS; 5: PPSK with RADIUS.")
    @NotNull(message="Parameter [security] should not be null.")
    @NumberSet(value={0, 2, 3, 4, 5}, message="Parameter [security] should be [0, 2, 3, 4, 5]")
    private @NotNull(message="Parameter [security] should not be null.") Integer security;
    @Schema(name="oweEnable", description="Opportunistic Wireless Encryption, also known as Enhanced Open, is a certification provided by the Wi-Fi Alliance as part of the WPA3 wireless security standard. OWE will enable two wireless VAPs per radio, one for access of OWE-supported stations, and one for access of other stations. An SSID with OWE enabled will be counted as two SSID entries for 2G and 5G.")
    private Boolean oweEnable;
    @Schema(name="broadcast", description="SSID broadcast config status. True: enable, false: disable.")
    private Boolean broadcast;
    @Schema(name="vlanEnable", description="SSID VLAN config status. True: enable, false: disable.")
    private Boolean vlanEnable;
    @Schema(name="vlanId", description="SSID VLAN ID. This field is required when Parameter [vlanEnable] is true; It should be within the range of 1\u20134094.")
    @Range(min=1L, max=4094L, message="Invalid VLAN ID. Enter a number from 1 to 4094.")
    private @Range(min=1L, max=4094L, message="Invalid VLAN ID. Enter a number from 1 to 4094.") Integer vlanId;
    @Valid
    @Schema(name="pskSetting", description="WPA-Personal SSID config. This is necessary when the value of security is 3(WPA-Personal), 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPskSettingOpenApiVO pskSetting;
    @Valid
    @Schema(name="entSetting", description="WPA-Enterprise SSID config. This is necessary when the value of security is 2(WPA-Enterprise).")
    private SsidEnterpriseSettingOpenApiVO entSetting;
    @Valid
    @Schema(name="ppskSetting", description="PPSK without RADIUS/PPSK without RADIUS SSID config. This is necessary when the value of security is 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPpskSettingOpenApiVO ppskSetting;
    @Schema(name="mloEnable", description="SSID MLO config status. True: enable, false: disable.")
    private Boolean mloEnable;
    @Schema(name="pmfMode", description="SSID PMF mode. It should be a value as follows: 1: Mandatory; 2: Capable; 3: Disable.")
    @NumberSet(value={1, 2, 3}, message="Parameter [pmfMode] should be 1 or 2 or 3")
    private Integer pmfMode;
    @Schema(name="enable11r", description="SSID 802.11r config status. True: enable, false: disable.")
    private Boolean enable11r;
    @Schema(name="hidePwd", description="If this field is true, the SSID password will be hidden.")
    private Boolean hidePwd;
    @Schema(name="greEnable", description="SSID EoGre Tunnel config status. True: enable, false: disable. This configuration can be enabled only when the [VPN - EoGre Tunnel] global config is enabled;")
    private Boolean greEnable;
    @Schema(name="vlanSetting", description="This field is required when Parameter [vlanEnable] is true. Field to set the SSID VLAN configuration. ")
    private SsidVlanSettingOpenApiVO vlanSetting;
    @Schema(name="prohibitWifiShare", description="SSID prohibitWifiShare config status. True: enable, false: disable.")
    private Boolean prohibitWifiShare;
    @Schema(name="clientRateLimit", description="Client rate limit config.")
    @Valid
    private RateLimitSettingOpenApiVO clientRateLimit;
    @Schema(name="ssidRateLimit", description="SSID rate limit config.")
    @Valid
    private RateLimitSettingOpenApiVO ssidRateLimit;
    @Schema(name="ssidWlanSchedule", description="SSID WLAN Schedule config.")
    @Valid
    private SsidWlanScheduleOpenApiVO ssidWlanSchedule;
    @Schema(name="ssidRateControl", description="SSID Rate Control config.")
    @Valid
    private SsidRateControlOpenApiVO ssidRateControl;
    @Schema(name="ssidMacFilter", description="SSID Mac Filter config.")
    @Valid
    private SsidMacFilterOpenApiVO ssidMacFilter;
    @Schema(name="ssidMulticast", description="SSID Multicast config.")
    @Valid
    private SsidMultiCastOpenApiVO ssidMultiCast;
    @Schema(name="ssidDhcpOption", description="SSID DhcpOption config.")
    @Valid
    private SsidDhcpOptionOpenApiVO ssidDhcpOption;
    @Valid
    @Schema(name="hotspotV2Setting", description="Hotspot 2.0 is a WFA (Wi-Fi Alliance) technical specification based on IEEE 802.11u protocol.<br />It provides a simplified mechanism for wireless clients to discover and connect to suitable networks and switch seamlessly between mobile networks and wireless networks.")
    private HotspotV2SettingOpenApiVO hotspotV2Setting;

    public static OperationResponse validate(CreateSsidV2OpenApiVO createSsidV2OpenApiVO) {
        if (createSsidV2OpenApiVO.getSecurity() == 3 && (createSsidV2OpenApiVO.getPskSetting() == null || createSsidV2OpenApiVO.getEntSetting() != null || createSsidV2OpenApiVO.getPpskSetting() != null)) {
            return new OperationResponse(b.d);
        }
        if (createSsidV2OpenApiVO.getSecurity() == 2 && (createSsidV2OpenApiVO.getPskSetting() != null || createSsidV2OpenApiVO.getEntSetting() == null || createSsidV2OpenApiVO.getPpskSetting() != null)) {
            return new OperationResponse(b.d);
        }
        if (!(createSsidV2OpenApiVO.getSecurity() != 5 && createSsidV2OpenApiVO.getSecurity() != 4 || createSsidV2OpenApiVO.getPskSetting() != null && createSsidV2OpenApiVO.getEntSetting() == null && createSsidV2OpenApiVO.getPpskSetting() != null)) {
            return new OperationResponse(b.d);
        }
        return new OperationResponse(b.a);
    }

    public void fillConfigBeforeValidate() {
        this.deviceType = this.deviceType == null ? 3 : this.deviceType;
        this.guestNetEnable = this.guestNetEnable == null ? false : this.guestNetEnable;
        this.mloEnable = this.mloEnable == null ? false : this.mloEnable;
        this.hidePwd = this.hidePwd == null ? false : this.hidePwd;
        this.broadcast = this.broadcast == null ? true : this.broadcast;
        this.enable11r = this.enable11r == null ? false : this.enable11r;
        this.greEnable = this.greEnable == null ? false : this.greEnable;
        this.prohibitWifiShare = this.prohibitWifiShare == null ? false : this.prohibitWifiShare;
        this.vlanEnable = this.vlanEnable == null ? false : this.vlanEnable;
        this.clientRateLimit = this.clientRateLimit == null ? ((RateLimitSettingOpenApiVO.RateLimitSettingOpenApiVOBuilder)RateLimitSettingOpenApiVO.builder().customSetting(CustomRateLimitSettingOpenApiVO.createDefault())).build() : this.clientRateLimit;
        this.ssidRateLimit = this.ssidRateLimit == null ? ((RateLimitSettingOpenApiVO.RateLimitSettingOpenApiVOBuilder)RateLimitSettingOpenApiVO.builder().customSetting(CustomRateLimitSettingOpenApiVO.createDefault())).build() : this.ssidRateLimit;
        SsidWlanScheduleOpenApiVO ssidWlanScheduleOpenApiVO = new SsidWlanScheduleOpenApiVO();
        ssidWlanScheduleOpenApiVO.setWlanScheduleEnable(false);
        this.ssidWlanSchedule = this.ssidWlanSchedule == null ? ssidWlanScheduleOpenApiVO : this.ssidWlanSchedule;
        SsidMacFilterOpenApiVO ssidMacFilterOpenApiVO = new SsidMacFilterOpenApiVO();
        ssidMacFilterOpenApiVO.setMacFilterEnable(false);
        this.ssidMacFilter = this.ssidMacFilter == null ? ssidMacFilterOpenApiVO : this.ssidMacFilter;
        this.ssidRateControl = this.ssidRateControl == null ? SsidRateControlOpenApiVO.createDefault() : this.ssidRateControl;
        SsidMultiCastOpenApiVO ssidMultiCastOpenApiVO = this.ssidMultiCast = this.ssidMultiCast == null ? SsidMultiCastOpenApiVO.createDefault() : this.ssidMultiCast;
        if (this.security == 2) {
            this.entSetting.setNasIdMode(this.entSetting.getNasIdMode() == null ? 0 : this.entSetting.getNasIdMode());
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Boolean getGuestNetEnable() {
        return this.guestNetEnable;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public Boolean getOweEnable() {
        return this.oweEnable;
    }

    @Generated
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public Boolean getVlanEnable() {
        return this.vlanEnable;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public SsidPskSettingOpenApiVO getPskSetting() {
        return this.pskSetting;
    }

    @Generated
    public SsidEnterpriseSettingOpenApiVO getEntSetting() {
        return this.entSetting;
    }

    @Generated
    public SsidPpskSettingOpenApiVO getPpskSetting() {
        return this.ppskSetting;
    }

    @Generated
    public Boolean getMloEnable() {
        return this.mloEnable;
    }

    @Generated
    public Integer getPmfMode() {
        return this.pmfMode;
    }

    @Generated
    public Boolean getEnable11r() {
        return this.enable11r;
    }

    @Generated
    public Boolean getHidePwd() {
        return this.hidePwd;
    }

    @Generated
    public Boolean getGreEnable() {
        return this.greEnable;
    }

    @Generated
    public SsidVlanSettingOpenApiVO getVlanSetting() {
        return this.vlanSetting;
    }

    @Generated
    public Boolean getProhibitWifiShare() {
        return this.prohibitWifiShare;
    }

    @Generated
    public RateLimitSettingOpenApiVO getClientRateLimit() {
        return this.clientRateLimit;
    }

    @Generated
    public RateLimitSettingOpenApiVO getSsidRateLimit() {
        return this.ssidRateLimit;
    }

    @Generated
    public SsidWlanScheduleOpenApiVO getSsidWlanSchedule() {
        return this.ssidWlanSchedule;
    }

    @Generated
    public SsidRateControlOpenApiVO getSsidRateControl() {
        return this.ssidRateControl;
    }

    @Generated
    public SsidMacFilterOpenApiVO getSsidMacFilter() {
        return this.ssidMacFilter;
    }

    @Generated
    public SsidMultiCastOpenApiVO getSsidMultiCast() {
        return this.ssidMultiCast;
    }

    @Generated
    public SsidDhcpOptionOpenApiVO getSsidDhcpOption() {
        return this.ssidDhcpOption;
    }

    @Generated
    public HotspotV2SettingOpenApiVO getHotspotV2Setting() {
        return this.hotspotV2Setting;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setGuestNetEnable(Boolean guestNetEnable) {
        this.guestNetEnable = guestNetEnable;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setOweEnable(Boolean oweEnable) {
        this.oweEnable = oweEnable;
    }

    @Generated
    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setVlanEnable(Boolean vlanEnable) {
        this.vlanEnable = vlanEnable;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setPskSetting(SsidPskSettingOpenApiVO pskSetting) {
        this.pskSetting = pskSetting;
    }

    @Generated
    public void setEntSetting(SsidEnterpriseSettingOpenApiVO entSetting) {
        this.entSetting = entSetting;
    }

    @Generated
    public void setPpskSetting(SsidPpskSettingOpenApiVO ppskSetting) {
        this.ppskSetting = ppskSetting;
    }

    @Generated
    public void setMloEnable(Boolean mloEnable) {
        this.mloEnable = mloEnable;
    }

    @Generated
    public void setPmfMode(Integer pmfMode) {
        this.pmfMode = pmfMode;
    }

    @Generated
    public void setEnable11r(Boolean enable11r) {
        this.enable11r = enable11r;
    }

    @Generated
    public void setHidePwd(Boolean hidePwd) {
        this.hidePwd = hidePwd;
    }

    @Generated
    public void setGreEnable(Boolean greEnable) {
        this.greEnable = greEnable;
    }

    @Generated
    public void setVlanSetting(SsidVlanSettingOpenApiVO vlanSetting) {
        this.vlanSetting = vlanSetting;
    }

    @Generated
    public void setProhibitWifiShare(Boolean prohibitWifiShare) {
        this.prohibitWifiShare = prohibitWifiShare;
    }

    @Generated
    public void setClientRateLimit(RateLimitSettingOpenApiVO clientRateLimit) {
        this.clientRateLimit = clientRateLimit;
    }

    @Generated
    public void setSsidRateLimit(RateLimitSettingOpenApiVO ssidRateLimit) {
        this.ssidRateLimit = ssidRateLimit;
    }

    @Generated
    public void setSsidWlanSchedule(SsidWlanScheduleOpenApiVO ssidWlanSchedule) {
        this.ssidWlanSchedule = ssidWlanSchedule;
    }

    @Generated
    public void setSsidRateControl(SsidRateControlOpenApiVO ssidRateControl) {
        this.ssidRateControl = ssidRateControl;
    }

    @Generated
    public void setSsidMacFilter(SsidMacFilterOpenApiVO ssidMacFilter) {
        this.ssidMacFilter = ssidMacFilter;
    }

    @Generated
    public void setSsidMultiCast(SsidMultiCastOpenApiVO ssidMultiCast) {
        this.ssidMultiCast = ssidMultiCast;
    }

    @Generated
    public void setSsidDhcpOption(SsidDhcpOptionOpenApiVO ssidDhcpOption) {
        this.ssidDhcpOption = ssidDhcpOption;
    }

    @Generated
    public void setHotspotV2Setting(HotspotV2SettingOpenApiVO hotspotV2Setting) {
        this.hotspotV2Setting = hotspotV2Setting;
    }

    @Generated
    public String toString() {
        return "CreateSsidV2OpenApiVO(name=" + this.getName() + ", deviceType=" + this.getDeviceType() + ", band=" + this.getBand() + ", guestNetEnable=" + this.getGuestNetEnable() + ", security=" + this.getSecurity() + ", oweEnable=" + this.getOweEnable() + ", broadcast=" + this.getBroadcast() + ", vlanEnable=" + this.getVlanEnable() + ", vlanId=" + this.getVlanId() + ", pskSetting=" + this.getPskSetting() + ", entSetting=" + this.getEntSetting() + ", ppskSetting=" + this.getPpskSetting() + ", mloEnable=" + this.getMloEnable() + ", pmfMode=" + this.getPmfMode() + ", enable11r=" + this.getEnable11r() + ", hidePwd=" + this.getHidePwd() + ", greEnable=" + this.getGreEnable() + ", vlanSetting=" + this.getVlanSetting() + ", prohibitWifiShare=" + this.getProhibitWifiShare() + ", clientRateLimit=" + this.getClientRateLimit() + ", ssidRateLimit=" + this.getSsidRateLimit() + ", ssidWlanSchedule=" + this.getSsidWlanSchedule() + ", ssidRateControl=" + this.getSsidRateControl() + ", ssidMacFilter=" + this.getSsidMacFilter() + ", ssidMultiCast=" + this.getSsidMultiCast() + ", ssidDhcpOption=" + this.getSsidDhcpOption() + ", hotspotV2Setting=" + this.getHotspotV2Setting() + ")";
    }

    @Generated
    public CreateSsidV2OpenApiVO() {
    }

    @Generated
    public CreateSsidV2OpenApiVO(String name, Integer deviceType, Integer band, Boolean guestNetEnable, Integer security, Boolean oweEnable, Boolean broadcast, Boolean vlanEnable, Integer vlanId, SsidPskSettingOpenApiVO pskSetting, SsidEnterpriseSettingOpenApiVO entSetting, SsidPpskSettingOpenApiVO ppskSetting, Boolean mloEnable, Integer pmfMode, Boolean enable11r, Boolean hidePwd, Boolean greEnable, SsidVlanSettingOpenApiVO vlanSetting, Boolean prohibitWifiShare, RateLimitSettingOpenApiVO clientRateLimit, RateLimitSettingOpenApiVO ssidRateLimit, SsidWlanScheduleOpenApiVO ssidWlanSchedule, SsidRateControlOpenApiVO ssidRateControl, SsidMacFilterOpenApiVO ssidMacFilter, SsidMultiCastOpenApiVO ssidMultiCast, SsidDhcpOptionOpenApiVO ssidDhcpOption, HotspotV2SettingOpenApiVO hotspotV2Setting) {
        this.name = name;
        this.deviceType = deviceType;
        this.band = band;
        this.guestNetEnable = guestNetEnable;
        this.security = security;
        this.oweEnable = oweEnable;
        this.broadcast = broadcast;
        this.vlanEnable = vlanEnable;
        this.vlanId = vlanId;
        this.pskSetting = pskSetting;
        this.entSetting = entSetting;
        this.ppskSetting = ppskSetting;
        this.mloEnable = mloEnable;
        this.pmfMode = pmfMode;
        this.enable11r = enable11r;
        this.hidePwd = hidePwd;
        this.greEnable = greEnable;
        this.vlanSetting = vlanSetting;
        this.prohibitWifiShare = prohibitWifiShare;
        this.clientRateLimit = clientRateLimit;
        this.ssidRateLimit = ssidRateLimit;
        this.ssidWlanSchedule = ssidWlanSchedule;
        this.ssidRateControl = ssidRateControl;
        this.ssidMacFilter = ssidMacFilter;
        this.ssidMultiCast = ssidMultiCast;
        this.ssidDhcpOption = ssidDhcpOption;
        this.hotspotV2Setting = hotspotV2Setting;
    }
}

