/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork;

import com.tplink.smb.omada.common.validator.anons.NumberSet;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidEnterpriseSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPpskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidPskSettingOpenApiVO;
import com.tplink.smb.omada.manager.configuration.api.openapi.site.wirelessnetwork.SsidVlanSettingOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;

public class CreateSsidOpenApiVO {
    @Schema(name="name", description="SSID name. It should contain 1 to 32 UTF-8 characters.")
    @NotNull(message="Parameter [name] should not be null.")
    private @NotNull(message="Parameter [name] should not be null.") String name;
    @Schema(name="deviceType", description="SSID device type, identify which devices this SSID will take effect; The lowest bit indicates whether [EAP] is included, the second low bit indicates whether [Gateway] is included, 1 means included while 0 means not included; For example, 3(11) means that EAP/Gateway is enabled, 1(01) means that EAP is enabled.")
    @NotNull(message="Parameter [deviceType] should not be null.")
    private @NotNull(message="Parameter [deviceType] should not be null.") Integer deviceType;
    @Schema(name="band", description="SSID band. The lowest bit indicates whether 2.4G is included; the second lowest bit indicates whether 5G is included; the third lowest bit indicates whether 6G is included; 1 means included while 0 means not included. For example, 7(111) means that 2G/5G/6G are enabled; 1(001) means that 2G is enabled. (When 5G is included\uff0cit means 5G/5G1/5G2 are enabled.)")
    @NotNull(message="Parameter [band] should not be null.")
    private @NotNull(message="Parameter [band] should not be null.") Integer band;
    @Schema(name="guestNetEnable", description="SSID guest network config status. True: enable, false: disable.")
    @NotNull(message="Parameter [guestNetEnable] should not be null.")
    private @NotNull(message="Parameter [guestNetEnable] should not be null.") Boolean guestNetEnable;
    @Schema(name="security", description="SSID security mode; Security should be a value as follows: 0: None; 2: WPA-Enterprise; 3: WPA-Personal; 4: PPSK without RADIUS; 5: PPSK with RADIUS.")
    @NotNull(message="Parameter [security] should not be null.")
    @NumberSet(value={0, 2, 3, 4, 5}, message="Parameter [security] should be [0, 2, 3, 4, 5]")
    private @NotNull(message="Parameter [security] should not be null.") Integer security;
    @Schema(name="broadcast", description="SSID broadcast config status. True: enable, false: disable.")
    @NotNull(message="Parameter [broadcast] should not be null.")
    private @NotNull(message="Parameter [broadcast] should not be null.") Boolean broadcast;
    @Schema(name="vlanEnable", description="SSID VLAN config status. True: enable, false: disable.")
    @NotNull(message="Parameter [vlanEnable] should not be null.")
    private @NotNull(message="Parameter [vlanEnable] should not be null.") Boolean vlanEnable;
    @Schema(name="vlanId", description="SSID VLAN ID. This field is required when Parameter [vlanEnable] is true; It should be within the range of 1\u20134094. If the field vlanSetting is entered, this field must be null.")
    @Range(min=1L, max=4094L, message="Invalid VLAN ID. Enter a number from 1 to 4094.")
    private @Range(min=1L, max=4094L, message="Invalid VLAN ID. Enter a number from 1 to 4094.") Integer vlanId;
    @Valid
    @Schema(name="pskSetting", description="WPA-Personal SSID config. This is necessary when the value of security is 3(WPA-Personal), 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPskSettingOpenApiVO pskSetting;
    @Valid
    @Schema(name="entSetting", description="WPA-Enterprise SSID config. This is necessary when the value of security is 2(WPA-Enterprise).")
    private SsidEnterpriseSettingOpenApiVO entSetting;
    @Valid
    @Schema(name="ppskSetting", description="PPSK without RADIUS/PPSK without RADIUS SSID config. This is necessary when the value of security is 4(PPSK without RADIUS), 5(PPSK with RADIUS).")
    private SsidPpskSettingOpenApiVO ppskSetting;
    @Schema(name="mloEnable", description="SSID MLO config status. True: enable, false: disable.")
    @NotNull(message="Parameter [mloEnable] should not be null.")
    private @NotNull(message="Parameter [mloEnable] should not be null.") Boolean mloEnable;
    @Schema(name="pmfMode", description="SSID PMF mode. It should be a value as follows: 1: Mandatory; 2: Capable; 3: Disable.")
    @NumberSet(value={1, 2, 3}, message="Parameter [pmfMode] should be 1 or 2 or 3")
    @NotNull(message="Parameter [pmfMode] should not be null.")
    private @NotNull(message="Parameter [pmfMode] should not be null.") Integer pmfMode;
    @Schema(name="enable11r", description="SSID 802.11r config status. True: enable, false: disable.")
    @NotNull(message="Parameter [enable11r] should not be null.")
    private @NotNull(message="Parameter [enable11r] should not be null.") Boolean enable11r;
    @Schema(name="hidePwd", description="If this field is true, the SSID password will be hidden.")
    @NotNull(message="Parameter [hidePwd] should not be null.")
    private @NotNull(message="Parameter [hidePwd] should not be null.") Boolean hidePwd;
    @Schema(name="greEnable", description="SSID EoGre Tunnel config status. True: enable, false: disable. This configuration can be enabled only when the [VPN - EoGre Tunnel] global config is enabled;(This configuration applies to the Pro Site of the Omada Pro Controller only).")
    private Boolean greEnable;
    @Schema(name="vlanSetting", description="This field is required when Parameter [vlanEnable] is true. A newly added field is added to set the SSID VLAN configuration. If the field vlanId is entered, this field must be null.")
    private SsidVlanSettingOpenApiVO vlanSetting;
    @Schema(name="prohibitWifiShare", description="SSID prohibitWifiShare config status. True: enable, false: disable.")
    private Boolean prohibitWifiShare;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Integer getBand() {
        return this.band;
    }

    @Generated
    public Boolean getGuestNetEnable() {
        return this.guestNetEnable;
    }

    @Generated
    public Integer getSecurity() {
        return this.security;
    }

    @Generated
    public Boolean getBroadcast() {
        return this.broadcast;
    }

    @Generated
    public Boolean getVlanEnable() {
        return this.vlanEnable;
    }

    @Generated
    public Integer getVlanId() {
        return this.vlanId;
    }

    @Generated
    public SsidPskSettingOpenApiVO getPskSetting() {
        return this.pskSetting;
    }

    @Generated
    public SsidEnterpriseSettingOpenApiVO getEntSetting() {
        return this.entSetting;
    }

    @Generated
    public SsidPpskSettingOpenApiVO getPpskSetting() {
        return this.ppskSetting;
    }

    @Generated
    public Boolean getMloEnable() {
        return this.mloEnable;
    }

    @Generated
    public Integer getPmfMode() {
        return this.pmfMode;
    }

    @Generated
    public Boolean getEnable11r() {
        return this.enable11r;
    }

    @Generated
    public Boolean getHidePwd() {
        return this.hidePwd;
    }

    @Generated
    public Boolean getGreEnable() {
        return this.greEnable;
    }

    @Generated
    public SsidVlanSettingOpenApiVO getVlanSetting() {
        return this.vlanSetting;
    }

    @Generated
    public Boolean getProhibitWifiShare() {
        return this.prohibitWifiShare;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setBand(Integer band) {
        this.band = band;
    }

    @Generated
    public void setGuestNetEnable(Boolean guestNetEnable) {
        this.guestNetEnable = guestNetEnable;
    }

    @Generated
    public void setSecurity(Integer security) {
        this.security = security;
    }

    @Generated
    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Generated
    public void setVlanEnable(Boolean vlanEnable) {
        this.vlanEnable = vlanEnable;
    }

    @Generated
    public void setVlanId(Integer vlanId) {
        this.vlanId = vlanId;
    }

    @Generated
    public void setPskSetting(SsidPskSettingOpenApiVO pskSetting) {
        this.pskSetting = pskSetting;
    }

    @Generated
    public void setEntSetting(SsidEnterpriseSettingOpenApiVO entSetting) {
        this.entSetting = entSetting;
    }

    @Generated
    public void setPpskSetting(SsidPpskSettingOpenApiVO ppskSetting) {
        this.ppskSetting = ppskSetting;
    }

    @Generated
    public void setMloEnable(Boolean mloEnable) {
        this.mloEnable = mloEnable;
    }

    @Generated
    public void setPmfMode(Integer pmfMode) {
        this.pmfMode = pmfMode;
    }

    @Generated
    public void setEnable11r(Boolean enable11r) {
        this.enable11r = enable11r;
    }

    @Generated
    public void setHidePwd(Boolean hidePwd) {
        this.hidePwd = hidePwd;
    }

    @Generated
    public void setGreEnable(Boolean greEnable) {
        this.greEnable = greEnable;
    }

    @Generated
    public void setVlanSetting(SsidVlanSettingOpenApiVO vlanSetting) {
        this.vlanSetting = vlanSetting;
    }

    @Generated
    public void setProhibitWifiShare(Boolean prohibitWifiShare) {
        this.prohibitWifiShare = prohibitWifiShare;
    }

    @Generated
    public String toString() {
        return "CreateSsidOpenApiVO(name=" + this.getName() + ", deviceType=" + this.getDeviceType() + ", band=" + this.getBand() + ", guestNetEnable=" + this.getGuestNetEnable() + ", security=" + this.getSecurity() + ", broadcast=" + this.getBroadcast() + ", vlanEnable=" + this.getVlanEnable() + ", vlanId=" + this.getVlanId() + ", pskSetting=" + this.getPskSetting() + ", entSetting=" + this.getEntSetting() + ", ppskSetting=" + this.getPpskSetting() + ", mloEnable=" + this.getMloEnable() + ", pmfMode=" + this.getPmfMode() + ", enable11r=" + this.getEnable11r() + ", hidePwd=" + this.getHidePwd() + ", greEnable=" + this.getGreEnable() + ", vlanSetting=" + this.getVlanSetting() + ", prohibitWifiShare=" + this.getProhibitWifiShare() + ")";
    }

    @Generated
    public CreateSsidOpenApiVO() {
    }

    @Generated
    public CreateSsidOpenApiVO(String name, Integer deviceType, Integer band, Boolean guestNetEnable, Integer security, Boolean broadcast, Boolean vlanEnable, Integer vlanId, SsidPskSettingOpenApiVO pskSetting, SsidEnterpriseSettingOpenApiVO entSetting, SsidPpskSettingOpenApiVO ppskSetting, Boolean mloEnable, Integer pmfMode, Boolean enable11r, Boolean hidePwd, Boolean greEnable, SsidVlanSettingOpenApiVO vlanSetting, Boolean prohibitWifiShare) {
        this.name = name;
        this.deviceType = deviceType;
        this.band = band;
        this.guestNetEnable = guestNetEnable;
        this.security = security;
        this.broadcast = broadcast;
        this.vlanEnable = vlanEnable;
        this.vlanId = vlanId;
        this.pskSetting = pskSetting;
        this.entSetting = entSetting;
        this.ppskSetting = ppskSetting;
        this.mloEnable = mloEnable;
        this.pmfMode = pmfMode;
        this.enable11r = enable11r;
        this.hidePwd = hidePwd;
        this.greEnable = greEnable;
        this.vlanSetting = vlanSetting;
        this.prohibitWifiShare = prohibitWifiShare;
    }
}

